/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.kernel;

import hlt.language.design.kernel.And;
import hlt.language.design.kernel.Application;
import hlt.language.design.kernel.Compiler;
import hlt.language.design.kernel.Dummy;
import hlt.language.design.kernel.Enclosure;
import hlt.language.design.kernel.Expression;
import hlt.language.design.kernel.FilterHomomorphism;
import hlt.language.design.kernel.Homomorphism;
import hlt.language.design.kernel.IfThenElse;
import hlt.language.design.kernel.Int;
import hlt.language.design.kernel.Let;
import hlt.language.design.kernel.NamedTuple;
import hlt.language.design.kernel.NoSuchSubexpressionException;
import hlt.language.design.kernel.Parameter;
import hlt.language.design.kernel.ParameterStack;
import hlt.language.design.kernel.ProtoExpression;
import hlt.language.design.kernel.Scope;
import hlt.language.design.kernel.StringConstant;
import hlt.language.design.kernel.Tuple;
import hlt.language.design.kernel.TupleFieldName;
import hlt.language.design.kernel.TupleProjection;
import hlt.language.design.kernel.UndefinedEqualityException;
import hlt.language.design.types.BoxableTypeConstant;
import hlt.language.design.types.FunctionType;
import hlt.language.design.types.Tables;
import hlt.language.design.types.Type;
import hlt.language.design.types.TypeChecker;
import hlt.language.design.types.TypingErrorException;
import hlt.language.util.ArrayList;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.Map;

public class Comprehension
extends ProtoExpression {
    public static boolean OPAQUE_PARAMETERS = true;
    protected Tables _tables;
    protected RawInfo _raw;
    protected Expression _construct;
    protected Expression _operation;
    protected Expression _identity;
    protected Expression _enclosingScope;
    public boolean _doLetWrapping = true;

    public Comprehension(AbstractList abstractList, AbstractList abstractList2, Expression expression) {
        this._construct = new Let(abstractList, abstractList2, expression);
    }

    public Comprehension(Tables tables, Expression expression, Expression expression2, Expression expression3, AbstractList abstractList, AbstractList abstractList2) {
        this(tables, expression, expression2, expression3, abstractList, abstractList2, 0);
    }

    public Comprehension(Tables tables, Expression expression, Expression expression2, Expression expression3, AbstractList abstractList, AbstractList abstractList2, byte by) {
        this._tables = tables;
        this._operation = expression;
        this._identity = expression2;
        if (abstractList == null) {
            abstractList = abstractList2 = new ArrayList(0);
        }
        this._raw = new RawInfo(new Dummy("$OP$").addTypes(expression).setExtent(expression), new Dummy("$ID$").addTypes(expression2).setExtent(expression2), expression3, abstractList, abstractList2, by);
    }

    private Comprehension(Expression expression) {
        this._construct = expression;
    }

    public final Comprehension setNoLetWrapping() {
        this._doLetWrapping = false;
        this._raw.operation = this._operation;
        this._raw.identity = this._identity;
        return this;
    }

    public final Tables tables() {
        return this._tables;
    }

    public final Expression operation() {
        return this._operation;
    }

    public final Expression identity() {
        return this._identity;
    }

    @Override
    public final Expression copy() {
        if (this._raw == null) {
            return new Comprehension(this._construct.copy());
        }
        ArrayList arrayList = new ArrayList(this._raw.patterns.size());
        for (int i = 0; i < this._raw.patterns.size(); ++i) {
            Expression expression = (Expression)this._raw.patterns.get(i);
            if (expression == null) continue;
            arrayList.add(expression.copy());
        }
        ArrayList arrayList2 = new ArrayList(this._raw.expressions.size());
        for (int i = 0; i < this._raw.expressions.size(); ++i) {
            arrayList2.add(((Expression)this._raw.expressions.get(i)).copy());
        }
        return new Comprehension(this._tables, this._operation.copy(), this._identity.copy(), this._raw.expression.copy(), arrayList, arrayList2, this._raw.inPlace);
    }

    @Override
    public final Expression typedCopy() {
        if (this._raw == null) {
            return new Comprehension(this._construct.typedCopy());
        }
        ArrayList arrayList = new ArrayList(this._raw.patterns.size());
        for (int i = 0; i < this._raw.patterns.size(); ++i) {
            Expression expression = (Expression)this._raw.patterns.get(i);
            if (expression == null) continue;
            arrayList.add(expression.typedCopy());
        }
        ArrayList arrayList2 = new ArrayList(this._raw.expressions.size());
        for (int i = 0; i < this._raw.expressions.size(); ++i) {
            arrayList2.add(((Expression)this._raw.expressions.get(i)).typedCopy());
        }
        return new Comprehension(this._tables, this._operation.typedCopy(), this._identity.typedCopy(), this._raw.expression.typedCopy(), arrayList, arrayList2, this._raw.inPlace).addTypes(this);
    }

    @Override
    public final int numberOfSubexpressions() {
        if (this._raw != null) {
            this._construct();
        }
        return this._construct.numberOfSubexpressions();
    }

    @Override
    public final Expression subexpression(int n) throws NoSuchSubexpressionException {
        if (this._raw != null) {
            this._construct();
        }
        return this._construct.subexpression(n);
    }

    @Override
    public final Expression setSubexpression(int n, Expression expression) throws NoSuchSubexpressionException {
        if (this._raw != null) {
            this._construct();
        }
        return this._construct.setSubexpression(n, expression);
    }

    @Override
    public final Expression sanitizeNames(ParameterStack parameterStack) {
        if (this._raw != null) {
            this._construct();
        }
        this._construct = this._construct.sanitizeNames(parameterStack);
        return this;
    }

    @Override
    public final void sanitizeSorts(Enclosure enclosure) {
        this._construct.sanitizeSorts(enclosure);
    }

    private final void _construct() throws UndefinedEqualityException {
        this.desugarPatterns();
        this.unnestInnerFilters();
    }

    @Override
    public Expression substitute(HashMap hashMap) {
        if (this._raw == null) {
            this._construct = this._construct.substitute(hashMap);
            return this;
        }
        if (!hashMap.isEmpty()) {
            this._operation = this._operation.substitute(hashMap);
            this._identity = this._identity.substitute(hashMap);
            this._substituteQualifiers(0, hashMap);
        }
        return this;
    }

    protected void _substituteQualifiers(int n, HashMap hashMap) {
        if (n == this._raw.patterns.size()) {
            this._raw.expression = this._raw.expression.substitute(hashMap);
        } else {
            Expression expression = (Expression)this._raw.patterns.get(n);
            Expression expression2 = (Expression)this._raw.expressions.get(n);
            this._raw.expressions.set(n, expression2.substitute(hashMap));
            if (expression == null) {
                this._substituteQualifiers(n + 1, hashMap);
            } else if (expression instanceof Parameter || expression instanceof Dummy && OPAQUE_PARAMETERS) {
                String string = expression instanceof Dummy ? ((Dummy)expression).name() : ((Parameter)expression).name();
                Object v = hashMap.remove(string);
                this._substituteQualifiers(n + 1, hashMap);
                if (v != null) {
                    hashMap.put(string, v);
                }
            } else {
                this._raw.patterns.set(n, expression.substitute(hashMap));
                this._substituteQualifiers(n + 1, hashMap);
            }
        }
    }

    @Override
    final int linkScopeTree(Expression expression) {
        if (this._scopeTreeIsLinked) {
            return this._nestedComprehensionCount;
        }
        this._enclosingScope = expression;
        this._nestedComprehensionCount = this._raw.expression.linkScopeTree(this);
        int n = this._raw.expressions.size();
        while (n-- > 0) {
            this._nestedComprehensionCount += ((Expression)this._raw.expressions.get(n)).linkScopeTree(this);
        }
        this._scopeTreeIsLinked = true;
        return 1 + this._nestedComprehensionCount;
    }

    @Override
    protected final void desugarPatterns() throws UndefinedEqualityException {
        if (this._raw == null || this._raw.isDesugared) {
            return;
        }
        this._desugarPatterns();
        if (this._nestedComprehensionCount > 0) {
            for (int i = 0; i < this._raw.patterns.size(); ++i) {
                Expression expression = (Expression)this._raw.patterns.get(i);
                if (expression != null) {
                    expression.desugarPatterns();
                }
                ((Expression)this._raw.expressions.get(i)).desugarPatterns();
            }
            this._raw.expression.desugarPatterns();
        }
    }

    private final void _desugarPatterns() throws UndefinedEqualityException {
        int n;
        HashMap hashMap = this._initialSubstitution();
        int n2 = this._raw.patterns.size();
        for (n = 0; n < n2; ++n) {
            this._raw.patterns.set(n, this._desugarPattern(n, (Expression)this._raw.patterns.get(n), hashMap));
        }
        n = this._raw.expressions.size() - n2;
        while (n-- > 0) {
            this._raw.patterns.add(null);
        }
        this._substituteDesugaring(hashMap);
        this._raw.isDesugared = true;
    }

    protected HashMap _initialSubstitution() {
        HashMap<String, IndexedExpression> hashMap = new HashMap<String, IndexedExpression>();
        for (Expression expression = this._enclosingScope; expression != null; expression = expression.enclosingScope()) {
            if (!(expression instanceof Scope)) continue;
            Scope scope = (Scope)expression;
            int n = scope.arity();
            while (n-- > 0) {
                String string = scope.parameter(n).name();
                if (hashMap.get(string) != null) continue;
                hashMap.put(string, new IndexedExpression(new Dummy(scope.parameter(n))));
            }
        }
        return hashMap;
    }

    protected Parameter _desugarPattern(int n, Expression expression, HashMap hashMap) throws UndefinedEqualityException {
        if (expression == null || expression instanceof Parameter) {
            return (Parameter)expression;
        }
        Parameter parameter = null;
        Dummy dummy = null;
        if (expression instanceof Dummy) {
            dummy = (Dummy)expression;
            parameter = new Parameter(dummy);
            if (!OPAQUE_PARAMETERS) {
                IndexedExpression indexedExpression = (IndexedExpression)hashMap.get(dummy.name());
                if (indexedExpression == null) {
                    if (!this._tables.isDefinedScalar(dummy.name())) {
                        hashMap.put(dummy.name(), new IndexedExpression(n, dummy));
                    }
                } else {
                    parameter = new Parameter(indexedExpression.expression.typeRef());
                    dummy = new Dummy(parameter);
                    this._raw.expressions.add(new Application(this._tables.equality(), dummy, indexedExpression.expression.typedCopy()));
                }
            }
            return parameter;
        }
        parameter = new Parameter(expression.typeRef());
        dummy = new Dummy(parameter.name());
        if (expression instanceof Tuple) {
            this._desugarTuplePattern(n, (Tuple)expression, dummy, hashMap);
        } else {
            this._raw.expressions.add(new Application(this._tables.equality(), dummy, expression));
        }
        return parameter;
    }

    protected final void _desugarTuplePattern(int n, Tuple tuple, Expression expression, HashMap hashMap) throws UndefinedEqualityException {
        if (tuple instanceof NamedTuple) {
            this._desugarNamedTuplePattern(n, (NamedTuple)tuple, expression, hashMap);
            return;
        }
        int n2 = tuple.dimension();
        for (int i = 0; i < n2; ++i) {
            this._desugarTupleComponent(n, tuple.component(i), new TupleProjection(expression, new Int(i + 1)), hashMap);
        }
    }

    private final void _desugarNamedTuplePattern(int n, NamedTuple namedTuple, Expression expression, HashMap hashMap) throws UndefinedEqualityException {
        TupleFieldName[] tupleFieldNameArray = namedTuple.fields();
        int n2 = tupleFieldNameArray.length;
        for (int i = 0; i < n2; ++i) {
            this._desugarTupleComponent(n, namedTuple.component(i), new TupleProjection(expression, new StringConstant(tupleFieldNameArray[i].name())), hashMap);
        }
    }

    protected void _desugarTupleComponent(int n, Expression expression, TupleProjection tupleProjection, HashMap hashMap) throws UndefinedEqualityException {
        if (expression instanceof Dummy) {
            Dummy dummy = (Dummy)expression;
            IndexedExpression indexedExpression = (IndexedExpression)hashMap.get(dummy.name());
            if (indexedExpression == null && !this._tables.isDefinedScalar(dummy.name())) {
                hashMap.put(dummy.name(), new IndexedExpression(n, tupleProjection));
            } else {
                this._raw.expressions.add(new Application(this._tables.equality(), tupleProjection, dummy.typedCopy()));
            }
            return;
        }
        if (expression instanceof Tuple) {
            this._desugarTuplePattern(n, (Tuple)expression, tupleProjection, hashMap);
        } else {
            this._raw.expressions.add(new Application(this._tables.equality(), tupleProjection, expression));
        }
    }

    private final void _substituteDesugaring(HashMap hashMap) {
        Object object;
        if (hashMap.isEmpty()) {
            return;
        }
        int n = this._raw.expressions.size();
        for (int i = 0; !(i >= n || (object = (Parameter)this._raw.patterns.get(i)) != null && ((Parameter)object).isInternal()); ++i) {
        }
        object = new HashMap(hashMap.size());
        for (int i = i; i < n; ++i) {
            Comprehension._updateSubstitution(i, (HashMap)object, hashMap);
            this._raw.expressions.set(i, ((Expression)this._raw.expressions.get(i)).substitute((HashMap)object));
        }
        this._raw.expression = this._raw.expression.substitute((HashMap)object);
    }

    private static final void _updateSubstitution(int n, HashMap hashMap, HashMap hashMap2) {
        int n2;
        ArrayList arrayList = new ArrayList();
        for (Map.Entry entry : hashMap2.entrySet()) {
            String string = (String)entry.getKey();
            IndexedExpression indexedExpression = (IndexedExpression)entry.getValue();
            if (n > indexedExpression.index) continue;
            hashMap.put(string, indexedExpression.expression);
            arrayList.add(string);
        }
        int n3 = n2 = arrayList.size();
        while (n3-- > 0) {
            hashMap2.remove(arrayList.get(n3));
        }
    }

    @Override
    protected final void unnestInnerFilters() {
        if (this._nestedComprehensionCount > 0) {
            this._raw.expression.unnestInnerFilters();
            int n = this._raw.expressions.size();
            while (n-- > 0) {
                ((Expression)this._raw.expressions.get(n)).unnestInnerFilters();
            }
        }
        this._unnestFilters();
    }

    private final void _unnestFilters() {
        Qualifier[] qualifierArray = new Qualifier[this._raw.patterns == null ? 0 : this._raw.patterns.size()];
        int n = qualifierArray.length;
        while (n-- > 0) {
            qualifierArray[n] = new Qualifier((Parameter)this._raw.patterns.get(n), (Expression)this._raw.expressions.get(n));
        }
        if (qualifierArray.length > 0) {
            this._normalize(qualifierArray);
        }
        this._construct = this._translate(qualifierArray, 0);
        if (this._doLetWrapping && !this._isLetWrapped()) {
            Parameter[] parameterArray = new Parameter[]{new Parameter("$OP$"), new Parameter("$ID$")};
            Expression[] expressionArray = new Expression[]{this._operation, this._identity};
            this._construct = new Let(parameterArray, expressionArray, this._construct);
        }
        this._raw = null;
    }

    private final boolean _isLetWrapped() {
        for (Expression expression = this._enclosingScope; expression != null; expression = expression.enclosingScope()) {
            if (!(expression instanceof Comprehension)) continue;
            Comprehension comprehension = (Comprehension)expression;
            return this.operation().equals(comprehension.operation()) && this.identity().equals(comprehension.identity());
        }
        return false;
    }

    private final void _normalize(Qualifier[] qualifierArray) {
        this._unnestFilters(qualifierArray.length - 1, qualifierArray);
    }

    private final void _unnestFilters(int n, Qualifier[] qualifierArray) {
        int n2;
        if (n == -1) {
            return;
        }
        int n3 = n;
        this._unnestFilters(n3 - 1, qualifierArray);
        Qualifier qualifier = qualifierArray[n];
        for (n2 = n - 1; n2 >= 0 && qualifierArray[n2] == null; --n2) {
        }
        if (n2 < n - 1) {
            qualifierArray[n] = null;
            n = n2 + 1;
            qualifierArray[n] = qualifier;
        }
        if (qualifier.isGenerator()) {
            return;
        }
        while (n > 0) {
            if (qualifierArray[n - 1].isGenerator()) {
                if (qualifier.expression.containsFreeName(qualifierArray[n - 1].parameter.name())) {
                    if (qualifier.isSelector(qualifierArray[n - 1].parameter)) {
                        qualifierArray[n - 1].addSelector(qualifier.expression);
                        Comprehension._eraseQualifier(n, n3, qualifierArray);
                    } else if (qualifierArray[n - 1].selectors == null && qualifier.isSlicing(qualifierArray[n - 1].parameter)) {
                        qualifierArray[n - 1].addSlicing(qualifier.expression);
                        Comprehension._eraseQualifier(n, n3, qualifierArray);
                    }
                    return;
                }
                qualifierArray[n] = qualifierArray[n - 1];
                qualifierArray[--n] = qualifier;
                continue;
            }
            if (n > 1) {
                if (!qualifier.expression.containsFreeName(qualifierArray[n - 2].parameter.name())) {
                    qualifierArray[n] = qualifierArray[n - 1];
                    qualifierArray[n - 1] = qualifierArray[n - 2];
                    qualifierArray[n -= 2] = qualifier;
                    continue;
                }
                if (qualifier.isSelector(qualifierArray[n - 2].parameter)) {
                    qualifierArray[n - 2].addSelector(qualifier.expression);
                } else if (qualifierArray[n - 2].selectors == null && qualifier.isSlicing(qualifierArray[n - 2].parameter)) {
                    qualifierArray[n - 2].addSlicing(qualifier.expression);
                } else {
                    qualifierArray[n - 1].expression = new And(qualifierArray[n - 1].expression, qualifier.expression);
                }
                Comprehension._eraseQualifier(n, n3, qualifierArray);
                return;
            }
            if (!this._isFurtherUnnestable(qualifier.expression)) {
                qualifierArray[n - 1].expression = new And(qualifierArray[n - 1].expression, qualifier.expression);
            }
            Comprehension._eraseQualifier(n, n3, qualifierArray);
            return;
        }
        if (this._isFurtherUnnestable(qualifier.expression)) {
            Comprehension._eraseQualifier(n, n3, qualifierArray);
        }
    }

    private final boolean _isFurtherUnnestable(Expression expression) {
        Expression expression2 = this._enclosingScope;
        while (expression2 != null && expression2.nestedComprehensionCount() == 1) {
            ProtoExpression protoExpression;
            if (expression2 instanceof Comprehension) {
                protoExpression = (Comprehension)expression2;
                if (this.operation().equals(((Comprehension)protoExpression).operation()) && this.identity().equals(((Comprehension)protoExpression).identity())) {
                    ((Comprehension)protoExpression).addFilter(expression);
                    return true;
                }
                return false;
            }
            protoExpression = (Scope)expression2;
            int n = ((Scope)protoExpression).arity();
            while (n-- > 0) {
                if (!expression.containsFreeName(((Scope)protoExpression).parameter(n).name())) continue;
                return false;
            }
            expression2 = ((Scope)protoExpression).enclosingScope();
        }
        return false;
    }

    final void addFilter(Expression expression) {
        this._raw.patterns.add(null);
        this._raw.expressions.add(expression);
    }

    private static final void _eraseQualifier(int n, int n2, Qualifier[] qualifierArray) {
        qualifierArray[n] = null;
        for (int i = n; i < n2 && qualifierArray[i + 1] != null; ++i) {
            qualifierArray[i] = qualifierArray[i + 1];
            qualifierArray[i + 1] = null;
        }
    }

    private final Expression _translate(Qualifier[] qualifierArray, int n) {
        if (n == qualifierArray.length || qualifierArray[n] == null) {
            return new Application(this._raw.op(), this._raw.expression, this._raw.id());
        }
        Expression expression = null;
        Homomorphism homomorphism = null;
        if (n < qualifierArray.length - 1 && qualifierArray[n].parameter != null && qualifierArray[n + 1] != null && qualifierArray[n + 1].parameter == null) {
            expression = this._translate(qualifierArray, n + 2);
            if (qualifierArray[n].selectors != null) {
                return this._selectorExpression(qualifierArray[n], qualifierArray[n + 1].expression, expression);
            }
            homomorphism = new FilterHomomorphism(this._tables, qualifierArray[n].expression, new Scope(qualifierArray[n].parameter, expression), this._raw.op(), this._raw.id(), new Scope((Parameter)qualifierArray[n].parameter.typedCopy(), qualifierArray[n + 1].expression));
        } else {
            expression = this._translate(qualifierArray, n + 1);
            if (qualifierArray[n].parameter == null) {
                return new IfThenElse(qualifierArray[n].expression, expression, this._raw.id());
            }
            if (qualifierArray[n].selectors != null) {
                return this._selectorExpression(qualifierArray[n], null, expression);
            }
            homomorphism = new Homomorphism(qualifierArray[n].expression, new Scope(qualifierArray[n].parameter, expression), this._raw.op(), this._raw.id());
        }
        if (qualifierArray[n].slicings != null) {
            homomorphism.setSlicings(qualifierArray[n].slicings);
        }
        if (this._raw.inPlace == 1) {
            return homomorphism.enableInPlace();
        }
        if (this._raw.inPlace == 2) {
            return homomorphism.disableInPlace();
        }
        return homomorphism;
    }

    private final Expression _selectorExpression(Qualifier qualifier, Expression expression, Expression expression2) {
        int n;
        Expression expression3 = new Application(this._tables.in(), new Dummy(qualifier.parameter), qualifier.expression);
        for (n = 1; n < qualifier.selectors.size(); ++n) {
            expression3 = new And(expression3, (Expression)qualifier.selectors.get(n));
        }
        if (qualifier.slicings != null) {
            for (n = 0; n < qualifier.slicings.size(); ++n) {
                expression3 = new And(expression3, ((Application)qualifier.slicings.get(n)).undoDummyLocal());
            }
        }
        if (expression != null) {
            expression3 = new And(expression3, expression);
        }
        return new Let(qualifier.parameter, ((Application)qualifier.selectors.get(0)).argument(1), (Expression)new IfThenElse(expression3, expression2, this._raw.id()));
    }

    @Override
    public final void setCheckedType() {
        if (this.setCheckedTypeLocked()) {
            return;
        }
        this._construct.setCheckedType();
        this.setCheckedType(this._construct.checkedType());
    }

    @Override
    public final void typeCheck(TypeChecker typeChecker) throws TypingErrorException {
        if (this.typeCheckLocked()) {
            return;
        }
        if (!(this._construct instanceof Let)) {
            this._construct.typeCheck(this._type, typeChecker);
            return;
        }
        Let let = (Let)this._construct;
        let.setType(this._type);
        Scope scope = (Scope)let.function();
        typeChecker.unify(scope.parameter(0).typeRef(), this.operation().typeRef(), this);
        typeChecker.unify(scope.parameter(1).typeRef(), this.identity().typeRef(), this);
        Expression expression = let.argument(0);
        Expression expression2 = let.argument(1);
        Type[] typeArray = new Type[]{expression.typeRef(), expression2.typeRef()};
        FunctionType functionType = new FunctionType(typeArray, let.typeRef()).setNoCurrying();
        expression2.typeCheck(typeChecker);
        let.function().typeCheck(functionType, typeChecker);
        expression.typeCheck(functionType.domains()[0], typeChecker);
    }

    @Override
    public final void compile(Compiler compiler) {
        if (this._construct instanceof Let) {
            this._fixTypeBoxing();
        }
        this._construct.compile(compiler);
    }

    private final void _fixTypeBoxing() {
        Let let = (Let)this._construct;
        FunctionType functionType = (FunctionType)((FunctionType)let.function().checkedType()).domain(0);
        FunctionType functionType2 = (FunctionType)let.argument(0).checkedType();
        Type type = let.argument(1).checkedType();
        if (type.kind() == 1) {
            ((BoxableTypeConstant)type).setBoxed(false);
        }
        if (functionType2.domain(0).kind() == 1) {
            ((BoxableTypeConstant)functionType2.domain(0)).setBoxed(false);
            functionType2.unsetDomainBox(0);
            ((BoxableTypeConstant)functionType.domain(0)).setBoxed(false);
            functionType.unsetDomainBox(0);
            if (functionType2.domain(0).isEqualTo(functionType2.domain(1))) {
                ((BoxableTypeConstant)functionType2.domain(1)).setBoxed(false);
                functionType2.unsetDomainBox(1);
                ((BoxableTypeConstant)functionType.domain(1)).setBoxed(false);
                functionType.unsetDomainBox(1);
                ((BoxableTypeConstant)functionType2.range()).setBoxed(false);
                functionType2.unsetRangeBox();
                ((BoxableTypeConstant)functionType.range()).setBoxed(false);
                functionType.unsetRangeBox();
            }
        }
    }

    public final String toString() {
        return this._raw == null ? this._construct.toString() : this._raw.toString();
    }

    public class Qualifier {
        public Parameter parameter;
        public Expression expression;
        public ArrayList slicings;
        public ArrayList selectors;

        public Qualifier(Parameter parameter, Expression expression) {
            this.parameter = parameter;
            this.expression = expression;
        }

        final boolean isGenerator() {
            return this.parameter != null;
        }

        final boolean isSlicing(Parameter parameter) {
            return this.expression.isSlicing(Comprehension.this.tables(), parameter);
        }

        final void addSlicing(Expression expression) {
            if (this.slicings == null) {
                this.slicings = new ArrayList();
            }
            this.slicings.add(expression);
        }

        final boolean isSelector(Parameter parameter) {
            return this.expression.isSelector(Comprehension.this.tables(), parameter);
        }

        final void addSelector(Expression expression) {
            if (this.selectors == null) {
                this.selectors = new ArrayList();
            }
            this.selectors.add(expression);
        }

        public final String toString() {
            if (this.parameter == null) {
                return this.expression.toString();
            }
            return this.parameter + " <- " + this.expression + (String)(this.selectors == null ? "" : " selected by " + this.selectors) + (String)(this.slicings == null ? "" : " sliced by " + this.slicings);
        }
    }

    public static class IndexedExpression {
        int index = -1;
        public Expression expression;

        public IndexedExpression(Expression expression) {
            this.expression = expression;
        }

        public IndexedExpression(int n, Expression expression) {
            this.index = n;
            this.expression = expression;
        }

        public final String toString() {
            return this.expression + "/" + this.index;
        }
    }

    public class RawInfo {
        Expression operation;
        Expression identity;
        public Expression expression;
        public AbstractList patterns;
        public AbstractList expressions;
        byte inPlace;
        boolean isDesugared;

        RawInfo(Expression expression, Expression expression2, Expression expression3, AbstractList abstractList, AbstractList abstractList2, byte by) {
            this.expression = expression3;
            this.operation = expression;
            this.identity = expression2;
            this.patterns = abstractList;
            this.expressions = abstractList2;
            this.inPlace = by;
        }

        final Expression op() {
            return this.operation.typedCopy();
        }

        public final Expression id() {
            return this.identity.typedCopy();
        }

        public final String toString() {
            StringBuilder stringBuilder = new StringBuilder("[").append(Comprehension.this.operation()).append(",").append(Comprehension.this.identity()).append("] { ").append(this.expression).append(" | ");
            for (int i = 0; i < this.patterns.size(); ++i) {
                Object e = this.patterns.get(i);
                if (e != null) {
                    stringBuilder.append(e).append(" <- ");
                }
                stringBuilder.append(this.expressions.get(i));
                if (i >= this.patterns.size() - 1) continue;
                stringBuilder.append(", ");
            }
            return stringBuilder.append(" }").toString();
        }
    }
}

