/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.kernel;

import hlt.language.design.instructions.Instruction;
import hlt.language.design.instructions.PushValueObject;
import hlt.language.design.kernel.Compiler;
import hlt.language.design.kernel.Expression;
import hlt.language.design.kernel.Global;
import hlt.language.design.kernel.Int;
import hlt.language.design.kernel.ProtoExpression;
import hlt.language.design.kernel.Real;
import hlt.language.design.kernel.StringConstant;
import hlt.language.design.types.Tables;
import hlt.language.design.types.Type;
import hlt.language.design.types.TypeChecker;
import hlt.language.design.types.TypeParameter;
import hlt.language.design.types.TypingErrorException;
import java.util.Iterator;

public class Constant
extends ProtoExpression {
    private static final byte _OTHER = 0;
    private static final byte _FALSE = 1;
    private static final byte _TRUE = 2;
    public static final Constant VOID = new Constant(Type.VOID);
    private boolean _isNull = false;
    private byte _id = 0;
    public static Global WRAP_INT;
    public static Global UNWRAP_INT;
    public static Global WRAP_REAL;
    public static Global UNWRAP_REAL;

    public Constant() {
    }

    public Constant(Type type) {
        this.setType(type);
    }

    @Override
    public final Expression copy() {
        return this;
    }

    @Override
    public final Expression typedCopy() {
        return this;
    }

    private final Constant _setId(byte by) {
        this._id = by;
        return this;
    }

    public static final Constant TRUE() {
        return new Constant(Type.BOOLEAN())._setId((byte)2);
    }

    @Override
    public final boolean isTrue() {
        return this._id == 2;
    }

    public static final Constant FALSE() {
        return new Constant(Type.BOOLEAN())._setId((byte)1);
    }

    @Override
    public final boolean isFalse() {
        return this._id == 1;
    }

    public static final Constant NULL() {
        return new Constant(new TypeParameter()).setIsNull();
    }

    public final Constant setIsNull() {
        this._isNull = true;
        return this;
    }

    @Override
    public final boolean isNull() {
        return this._isNull;
    }

    public static final Constant NULL(Type type) {
        if (type.isVoid()) {
            return VOID;
        }
        if (type.isBoolean()) {
            return Constant.FALSE();
        }
        if (type.isInt()) {
            return new Int(0);
        }
        if (type.isReal()) {
            return new Real(0.0);
        }
        if (type.isString()) {
            return new StringConstant();
        }
        return new Constant(type).setIsNull();
    }

    public static final void initialize(Tables tables) {
        WRAP_INT = new Global(tables, "wrapInt").globalConstant(Type.INT(), Type.BOXED_INT());
        UNWRAP_INT = new Global(tables, "unwrapInt").globalConstant(Type.BOXED_INT(), Type.INT());
        WRAP_REAL = new Global(tables, "wrapReal").globalConstant(Type.REAL(), Type.BOXED_REAL());
        UNWRAP_REAL = new Global(tables, "unwrapReal").globalConstant(Type.BOXED_REAL(), Type.REAL());
    }

    @Override
    public final void setCheckedType() {
        if (this.setCheckedTypeLocked()) {
            return;
        }
        this._checkedType = this.type().copy();
    }

    @Override
    public void typeCheck(TypeChecker typeChecker) throws TypingErrorException {
        if (this.typeCheckLocked()) {
            return;
        }
        if (this._otherTypes != null) {
            Iterator iterator = this._otherTypes.iterator();
            while (iterator.hasNext()) {
                typeChecker.unify(this.type(), (Type)iterator.next(), this);
            }
        }
    }

    @Override
    public void compile(Compiler compiler) {
        if (this.isVoid()) {
            return;
        }
        if (this.isTrue()) {
            compiler.generate(Instruction.PUSH_TRUE);
            return;
        }
        if (this.isFalse() || this._isNull && this.checkedType().isBoolean()) {
            compiler.generate(Instruction.PUSH_FALSE);
            return;
        }
        if (this._isNull) {
            switch (this.boxSort()) {
                case 0: {
                    return;
                }
                case 1: {
                    if (this.checkedType().isBoxedType()) {
                        compiler.generate(Instruction.PUSH_ZERO_I);
                    } else {
                        compiler.generate(Instruction.PUSH_0_I);
                    }
                    return;
                }
                case 2: {
                    if (this.checkedType().isBoxedType()) {
                        compiler.generate(Instruction.PUSH_ZERO_R);
                    } else {
                        compiler.generate(Instruction.PUSH_0_R);
                    }
                    return;
                }
            }
            if (this.checkedType().isString()) {
                compiler.generate(Instruction.PUSH_EMPTY_STR);
                return;
            }
            compiler.generate(Instruction.PUSH_NULL);
            return;
        }
        compiler.generate(new PushValueObject(this));
    }

    public boolean equals(Object object) {
        if (!(object instanceof Constant)) {
            return false;
        }
        if (this._isNull) {
            return ((Constant)object).isNull();
        }
        return this == object;
    }

    private Type _getType() {
        if (this._checkedType != null) {
            return this._checkedType;
        }
        return this.type();
    }

    public String toString() {
        if (this.isVoid()) {
            return "()";
        }
        if (this.isFalse()) {
            return "false";
        }
        if (this.isTrue()) {
            return "true";
        }
        if (this._isNull) {
            return "null(" + this._getType() + ")";
        }
        return "<unknown constant>";
    }
}

