/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.kernel;

import hlt.language.design.kernel.Abstraction;
import hlt.language.design.kernel.Compiler;
import hlt.language.design.kernel.DefinitionException;
import hlt.language.design.kernel.Expression;
import hlt.language.design.kernel.NoSuchSubexpressionException;
import hlt.language.design.kernel.ProtoExpression;
import hlt.language.design.types.ClassType;
import hlt.language.design.types.DefinedEntry;
import hlt.language.design.types.FunctionType;
import hlt.language.design.types.Symbol;
import hlt.language.design.types.Tables;
import hlt.language.design.types.TypeChecker;
import hlt.language.design.types.TypingErrorException;
import java.util.AbstractList;

public class Definition
extends ProtoExpression {
    private Symbol _symbol;
    private Expression _body;
    private DefinedEntry _codeEntry;
    private boolean _isField = false;
    private boolean _isProjection = false;
    private boolean _isSetOnEvaluation = false;

    public Definition(Symbol symbol, Expression expression) {
        this._symbol = symbol;
        this._body = expression;
    }

    public Definition(Tables tables, String string, Expression expression) {
        this._symbol = tables.symbol(string);
        this._body = expression;
    }

    public Definition(Tables tables, String string, String string2, Expression expression) {
        this(tables, string, new Abstraction(string2, expression));
    }

    public Definition(Tables tables, String string, AbstractList abstractList, Expression expression) {
        this(tables, string, new Abstraction(abstractList, expression));
    }

    public Definition(Tables tables, String string, Expression expression, boolean bl) {
        this(tables, string, expression);
        this._isField = bl;
    }

    public Definition(Tables tables, String string, AbstractList abstractList, Expression expression, boolean bl) {
        this(tables, string, abstractList, expression);
        this._isField = bl;
    }

    @Override
    public final Expression copy() {
        Definition definition = new Definition(this._symbol, this._body.copy());
        definition._codeEntry = this._codeEntry;
        definition._isField = this._isField;
        definition._isProjection = this._isProjection;
        definition._isSetOnEvaluation = this._isSetOnEvaluation;
        return definition;
    }

    @Override
    public final Expression typedCopy() {
        Definition definition = (Definition)new Definition(this._symbol, this._body.typedCopy()).addTypes(this);
        definition._codeEntry = this._codeEntry;
        definition._isField = this._isField;
        definition._isProjection = this._isProjection;
        definition._isSetOnEvaluation = this._isSetOnEvaluation;
        return definition;
    }

    @Override
    public final int numberOfSubexpressions() {
        return 1;
    }

    @Override
    public final Expression subexpression(int n) throws NoSuchSubexpressionException {
        if (n == 0) {
            return this._body;
        }
        throw new NoSuchSubexpressionException(this, n);
    }

    @Override
    public final Expression setSubexpression(int n, Expression expression) throws NoSuchSubexpressionException {
        if (n != 0) {
            throw new NoSuchSubexpressionException(this, n);
        }
        this._body = expression;
        return this;
    }

    public final Symbol symbol() {
        return this._symbol;
    }

    public final boolean isProjection() {
        return this._isProjection;
    }

    public final Definition setIsProjection() {
        this._isProjection = true;
        return this;
    }

    @Override
    public final void setCheckedType() {
        if (this.setCheckedTypeLocked()) {
            return;
        }
        this._body.setCheckedType();
        this.setCheckedType(this.type().standardize());
    }

    public final DefinedEntry codeEntry() {
        return this._codeEntry;
    }

    public final Definition setOnEvaluation() {
        this._isSetOnEvaluation = true;
        return this;
    }

    public final boolean isSetOnEvaluation() {
        return this._isSetOnEvaluation;
    }

    public final void registerCodeEntry() throws DefinitionException {
        this._codeEntry = this._symbol.registerCodeEntry(this._checkedType);
        if (this._isSetOnEvaluation) {
            this._codeEntry.setOnEvaluation();
        }
    }

    @Override
    public final void typeCheck(TypeChecker typeChecker) throws TypingErrorException {
        if (this.typeCheckLocked()) {
            return;
        }
        this._body.typeCheck(typeChecker);
        typeChecker.unify(this._type, this._body.typeRef(), this);
        if (this._isField) {
            typeChecker.disallowVoid(((FunctionType)this.type()).curryedRange(), this, "field " + this._symbol + " of class " + ((ClassType)((FunctionType)this.type()).domain(0)).name());
        }
    }

    @Override
    public final Expression shiftOffsets(int n, int n2, int n3, int n4, int n5, int n6) {
        throw new UnsupportedOperationException("method shiftOffsets may not be called on a Definition!");
    }

    @Override
    public final void compile(Compiler compiler) {
        if (this._isField) {
            this._codeEntry.setFieldInfo();
        }
        if (this._isProjection) {
            this._codeEntry.setIsProjection();
        }
        compiler.setCodeEntry(this._codeEntry);
        this._body.compile(compiler);
    }

    public final String toString() {
        return this._symbol + " = " + this._body;
    }
}

