/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.kernel;

import hlt.language.design.instructions.Instruction;
import hlt.language.design.kernel.Compiler;
import hlt.language.design.kernel.Expression;
import hlt.language.design.kernel.NoSuchSubexpressionException;
import hlt.language.design.kernel.ProtoExpression;
import hlt.language.design.types.CheckExitableGoal;
import hlt.language.design.types.TypeChecker;
import hlt.language.design.types.TypingErrorException;

public class ExitWithValue
extends ProtoExpression {
    private Expression _value;
    private boolean _typeAsValue = true;

    public ExitWithValue(Expression expression) {
        this._value = expression;
    }

    public ExitWithValue(Expression expression, boolean bl) {
        this._value = expression;
        this._typeAsValue = bl;
    }

    public final Expression value() {
        return this._value;
    }

    @Override
    public final Expression copy() {
        return new ExitWithValue(this._value.copy(), this._typeAsValue);
    }

    @Override
    public final Expression typedCopy() {
        return new ExitWithValue(this._value.typedCopy(), this._typeAsValue).addTypes(this);
    }

    @Override
    public final int numberOfSubexpressions() {
        return 1;
    }

    @Override
    public final Expression subexpression(int n) throws NoSuchSubexpressionException {
        if (n == 0) {
            return this._value;
        }
        throw new NoSuchSubexpressionException(this, n);
    }

    @Override
    public final Expression setSubexpression(int n, Expression expression) throws NoSuchSubexpressionException {
        if (n != 0) {
            throw new NoSuchSubexpressionException(this, n);
        }
        this._value = expression;
        return this;
    }

    @Override
    public final void setCheckedType() {
        if (this.setCheckedTypeLocked()) {
            return;
        }
        this.setCheckedType(this.type().copy());
        this._value.setCheckedType();
    }

    @Override
    public final void typeCheck(TypeChecker typeChecker) throws TypingErrorException {
        if (this.typeCheckLocked()) {
            return;
        }
        this._value.typeCheck(typeChecker);
        typeChecker.prove(new CheckExitableGoal(this._value.type(), this));
        if (this._typeAsValue) {
            typeChecker.unify(this._type, this._value.type(), this);
        }
    }

    @Override
    public final void compile(Compiler compiler) {
        this._value.compile(compiler);
        switch (this._value.checkedType().boxSort()) {
            case 0: {
                compiler.generate(Instruction.NL_RETURN_VOID);
                return;
            }
            case 1: {
                compiler.generate(Instruction.NL_RETURN_I);
                return;
            }
            case 2: {
                compiler.generate(Instruction.NL_RETURN_R);
                return;
            }
        }
        compiler.generate(Instruction.NL_RETURN_O);
    }

    public final String toString() {
        if (this._value.checkedType().isVoid()) {
            return "return";
        }
        return "return " + this._value;
    }
}

