/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.kernel;

import hlt.language.design.kernel.Abstraction;
import hlt.language.design.kernel.Application;
import hlt.language.design.kernel.Compiler;
import hlt.language.design.kernel.Constant;
import hlt.language.design.kernel.Dummy;
import hlt.language.design.kernel.Enclosure;
import hlt.language.design.kernel.Global;
import hlt.language.design.kernel.Local;
import hlt.language.design.kernel.NoSuchSubexpressionException;
import hlt.language.design.kernel.Parameter;
import hlt.language.design.kernel.ParameterStack;
import hlt.language.design.kernel.UndefinedEqualityException;
import hlt.language.design.types.FunctionType;
import hlt.language.design.types.StaticSemanticsErrorException;
import hlt.language.design.types.Tables;
import hlt.language.design.types.Type;
import hlt.language.design.types.TypeChecker;
import hlt.language.design.types.TypeParameter;
import hlt.language.design.types.TypingErrorException;
import hlt.language.tools.Misc;
import hlt.language.util.Locatable;
import hlt.language.util.Location;
import hlt.language.util.Span;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public abstract class Expression
implements Locatable {
    public static boolean VOID_ASSIGNMENTS = false;
    protected boolean _typeCheckLocked = false;
    protected boolean _setCheckedTypeLocked = false;
    protected HashSet _otherTypes;
    protected int _nestedComprehensionCount;
    protected boolean _scopeTreeIsLinked;
    private Locatable _extent;

    public abstract Expression copy();

    public abstract Expression typedCopy();

    public final boolean typeCheckLocked() {
        if (!this._typeCheckLocked) {
            this._typeCheckLocked = true;
            return false;
        }
        return true;
    }

    public final boolean setCheckedTypeLocked() {
        if (!this._setCheckedTypeLocked) {
            this._setCheckedTypeLocked = true;
            return false;
        }
        return true;
    }

    public boolean isSlicing(Tables tables, Parameter parameter) {
        return false;
    }

    public boolean isHiddenSlicing(Tables tables, Parameter parameter) {
        return false;
    }

    public boolean isSelector(Tables tables, Parameter parameter) {
        return false;
    }

    public final boolean isEquality(Tables tables) throws UndefinedEqualityException {
        if (!(this instanceof Dummy) && !(this instanceof Global)) {
            return false;
        }
        return tables.isEquality(this instanceof Dummy ? ((Dummy)this).name() : ((Global)this).name());
    }

    public final boolean isConstant() {
        return this instanceof Constant;
    }

    public final boolean isVoid() {
        return this == Constant.VOID;
    }

    public boolean isTrue() {
        return this.isConstant() && ((Constant)this).isTrue();
    }

    public boolean isFalse() {
        return this.isConstant() && ((Constant)this).isFalse();
    }

    public boolean isNull() {
        return this.isConstant() && ((Constant)this).isNull();
    }

    public abstract Type type();

    public abstract void setType(Type var1);

    public abstract Type typeRef();

    public abstract Type checkedType();

    public abstract void setCheckedType();

    public abstract void setCheckedType(Type var1);

    public Expression substitute(HashMap hashMap) {
        if (!hashMap.isEmpty()) {
            int n = this.numberOfSubexpressions();
            while (n-- > 0) {
                this.setSubexpression(n, this.subexpression(n).substitute(hashMap));
            }
        }
        return this;
    }

    public Expression enclosingScope() {
        return null;
    }

    final int nestedComprehensionCount() {
        return this._nestedComprehensionCount;
    }

    int linkScopeTree(Expression expression) {
        if (this._scopeTreeIsLinked) {
            return this._nestedComprehensionCount;
        }
        int n = this.numberOfSubexpressions();
        while (n-- > 0) {
            this._nestedComprehensionCount += this.subexpression(n).linkScopeTree(expression);
        }
        this._scopeTreeIsLinked = true;
        return this._nestedComprehensionCount;
    }

    void desugarPatterns() {
        if (this._nestedComprehensionCount > 0) {
            int n = this.numberOfSubexpressions();
            while (n-- > 0) {
                this.subexpression(n).desugarPatterns();
            }
        }
    }

    void unnestInnerFilters() {
        if (this._nestedComprehensionCount > 0) {
            int n = this.numberOfSubexpressions();
            while (n-- > 0) {
                this.subexpression(n).unnestInnerFilters();
            }
        }
    }

    public boolean containsFreeName(String string) {
        int n = this.numberOfSubexpressions();
        while (n-- > 0) {
            if (!this.subexpression(n).containsFreeName(string)) continue;
            return true;
        }
        return false;
    }

    public Expression sanitizeNames(ParameterStack parameterStack) {
        int n = this.numberOfSubexpressions();
        while (n-- > 0) {
            this.setSubexpression(n, this.subexpression(n).sanitizeNames(parameterStack));
        }
        return this;
    }

    public void sanitizeSorts(Enclosure enclosure) {
        int n = this.numberOfSubexpressions();
        while (n-- > 0) {
            this.subexpression(n).sanitizeSorts(enclosure);
        }
    }

    public Expression shiftOffsets(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = this.numberOfSubexpressions();
        while (n7-- > 0) {
            this.setSubexpression(n7, this.subexpression(n7).shiftOffsets(n, n2, n3, n4, n5, n6));
        }
        return this;
    }

    public final Expression shiftOffsets(int n, int n2, int n3) {
        return this.shiftOffsets(n, n2, n3, 0, 0, 0);
    }

    public abstract void typeCheck(TypeChecker var1) throws TypingErrorException;

    public void typeCheck(Type type, TypeChecker typeChecker) throws TypingErrorException {
        typeChecker.unify(this.typeRef(), type, this);
        this.typeCheck(typeChecker);
    }

    public final void typeCheck(Global global, TypeChecker typeChecker) throws TypingErrorException {
        this.typeCheck(typeChecker);
        typeChecker.prune(global, this.typeRef(), this);
        global.typeCheck(this.typeRef(), typeChecker);
    }

    public abstract void compile(Compiler var1);

    public int numberOfSubexpressions() {
        return 0;
    }

    public Expression subexpression(int n) throws NoSuchSubexpressionException {
        throw new NoSuchSubexpressionException(this, n);
    }

    public Expression setSubexpression(int n, Expression expression) throws NoSuchSubexpressionException {
        return this;
    }

    public Parameter[] parameters() {
        return null;
    }

    public final byte sort() {
        return this.checkedType().sort();
    }

    public byte boxSort() {
        return this.checkedType().boxSort();
    }

    public final Expression addType(Type type) {
        Type type2 = this.type();
        if (type == null) {
            return this;
        }
        if (type2 == null) {
            this.setType(type);
        } else {
            if ((type2 = type2.value()) == (type = type.value())) {
                return this;
            }
            if (type2.kind() == 2) {
                ((TypeParameter)type2).bind(type);
            } else if (type.kind() == 2) {
                ((TypeParameter)type).bind(type2);
            } else {
                if (this._otherTypes == null) {
                    this._otherTypes = new HashSet(1);
                }
                this._otherTypes.add(type);
            }
        }
        return this;
    }

    public final HashSet otherTypes() {
        return this._otherTypes;
    }

    public final Expression setOtherTypes(HashSet hashSet) {
        this._otherTypes = hashSet;
        return this;
    }

    public final Expression addTypes(Expression expression) {
        this.addType(expression.typeRef());
        HashSet hashSet = expression.otherTypes();
        if (hashSet != null) {
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                this.addType((Type)iterator.next());
            }
        }
        return this;
    }

    public final Locatable extent() {
        return this._extent;
    }

    public final Expression setExtent(Locatable locatable) {
        this._extent = locatable;
        return this;
    }

    @Override
    public final Location getStart() {
        return this._extent == null ? null : this._extent.getStart();
    }

    @Override
    public final Location getEnd() {
        return this._extent == null ? null : this._extent.getEnd();
    }

    @Override
    public final Locatable setStart(Location location) {
        if (this._extent == null) {
            this._extent = new Span();
        }
        this._extent.setStart(location);
        return this;
    }

    @Override
    public final Locatable setEnd(Location location) {
        if (this._extent == null) {
            this._extent = new Span();
        }
        this._extent.setEnd(location);
        return this;
    }

    protected final StaticSemanticsErrorException locate(StaticSemanticsErrorException staticSemanticsErrorException) {
        return staticSemanticsErrorException.setExtent(this);
    }

    @Override
    public final String locationString() {
        return Misc.locationString(this._extent);
    }

    final Expression pad(FunctionType functionType) {
        Application application;
        FunctionType functionType2 = (FunctionType)this.checkedType();
        int n = functionType2.arity();
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            if (!functionType.argumentSortsDisagree(functionType2, i)) continue;
            bl = false;
            break;
        }
        if (bl && !functionType.resultSortsDisagree(functionType2)) {
            return this;
        }
        Parameter[] parameterArray = new Parameter[n];
        Local[] localArray = new Local[n];
        Expression[] expressionArray = new Expression[n];
        for (int i = 0; i < n; ++i) {
            parameterArray[i] = new Parameter();
            localArray[i] = new Local(parameterArray[i]);
            localArray[i].setOffset(n - 1 - i);
            if (functionType.mustWrapArgument(functionType2, i)) {
                expressionArray[i] = new Application(functionType.domain(i).wrapper(), localArray[i]);
                if (functionType.domain(i).sort() == 1) {
                    parameterArray[i].setCheckedType(Type.INT());
                    expressionArray[i].setCheckedType(Type.BOXED_INT());
                    continue;
                }
                parameterArray[i].setCheckedType(Type.REAL());
                expressionArray[i].setCheckedType(Type.BOXED_REAL());
                continue;
            }
            if (functionType.mustUnwrapArgument(functionType2, i)) {
                expressionArray[i] = new Application(functionType.domain(i).unwrapper(), localArray[i]);
                if (functionType.domain(i).sort() == 1) {
                    parameterArray[i].setCheckedType(Type.BOXED_INT());
                    expressionArray[i].setCheckedType(Type.INT());
                    continue;
                }
                parameterArray[i].setCheckedType(Type.BOXED_REAL());
                expressionArray[i].setCheckedType(Type.REAL());
                continue;
            }
            parameterArray[i].setCheckedType(functionType2.domain(i));
            expressionArray[i] = localArray[i];
        }
        Application application2 = application = new Application(this, expressionArray);
        if (functionType.mustWrapResult(functionType2)) {
            application2 = new Application(functionType.range().wrapper(), application);
            if (functionType.range().sort() == 1) {
                application.setCheckedType(Type.INT());
                application2.setCheckedType(Type.BOXED_INT());
            } else {
                application.setCheckedType(Type.REAL());
                application2.setCheckedType(Type.BOXED_REAL());
            }
        } else if (functionType.mustUnwrapResult(functionType2)) {
            application2 = new Application(functionType.range().unwrapper(), application);
            if (functionType.range().sort() == 1) {
                application.setCheckedType(Type.BOXED_INT());
                application2.setCheckedType(Type.INT());
            } else {
                application.setCheckedType(Type.BOXED_REAL());
                application2.setCheckedType(Type.REAL());
            }
        } else {
            application.setCheckedType(functionType2.range());
        }
        Abstraction abstraction = new Abstraction(parameterArray, (Expression)application2);
        abstraction.setNonExitable();
        abstraction.setSortedArities();
        this.shiftOffsets(abstraction.intArity(), abstraction.realArity(), abstraction.objectArity());
        return abstraction;
    }
}

