/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.kernel;

import hlt.language.design.instructions.SetIntField;
import hlt.language.design.instructions.SetObjectField;
import hlt.language.design.instructions.SetRealField;
import hlt.language.design.kernel.Application;
import hlt.language.design.kernel.AssignmentErrorException;
import hlt.language.design.kernel.Compiler;
import hlt.language.design.kernel.Expression;
import hlt.language.design.kernel.Global;
import hlt.language.design.kernel.NoSuchSubexpressionException;
import hlt.language.design.kernel.ProtoExpression;
import hlt.language.design.kernel.TupleProjection;
import hlt.language.design.kernel.TupleUpdate;
import hlt.language.design.types.ClassType;
import hlt.language.design.types.DefinedEntry;
import hlt.language.design.types.NamedTupleType;
import hlt.language.design.types.Type;
import hlt.language.design.types.TypeChecker;
import hlt.language.design.types.TypingErrorException;

public class FieldUpdate
extends ProtoExpression {
    private Expression _object;
    private Global _field;
    private Expression _value;
    private Expression _tupleUpdate;
    private boolean _fieldIsBoxed = false;
    private boolean _valueIsBoxed = false;

    public final Expression tupleUpdate() {
        return this._tupleUpdate;
    }

    public FieldUpdate(Expression expression, Global global, Expression expression2) {
        this._object = expression;
        this._field = global;
        this._value = expression2;
    }

    @Override
    public final Expression copy() {
        return new FieldUpdate(this._object.copy(), (Global)this._field.copy(), this._value.copy());
    }

    @Override
    public final Expression typedCopy() {
        return new FieldUpdate(this._object.typedCopy(), (Global)this._field.typedCopy(), this._value.typedCopy());
    }

    @Override
    public final int numberOfSubexpressions() {
        return 3;
    }

    @Override
    public final Expression subexpression(int n) throws NoSuchSubexpressionException {
        switch (n) {
            case 0: {
                return this._object;
            }
            case 1: {
                return this._field;
            }
            case 2: {
                return this._value;
            }
        }
        throw new NoSuchSubexpressionException(this, n);
    }

    @Override
    public final Expression setSubexpression(int n, Expression expression) throws NoSuchSubexpressionException {
        switch (n) {
            case 0: {
                this._object = expression;
                break;
            }
            case 1: {
                this._field = (Global)expression;
                break;
            }
            case 2: {
                this._value = expression;
                break;
            }
            default: {
                throw new NoSuchSubexpressionException(this, n);
            }
        }
        return this;
    }

    @Override
    public final void setCheckedType() {
        if (this.setCheckedTypeLocked()) {
            return;
        }
        this.setCheckedType(this.type().copy());
        if (this._tupleUpdate == null) {
            this._object.setCheckedType();
            this._field.setCheckedType();
            this._value.setCheckedType();
        } else {
            this._tupleUpdate.setCheckedType();
        }
    }

    @Override
    public final void typeCheck(TypeChecker typeChecker) throws TypingErrorException {
        if (this.typeCheckLocked()) {
            return;
        }
        Application application = new Application((Expression)this._field, this._object);
        ((Expression)application).typeCheck(typeChecker);
        if (this._object.type().actualType() instanceof NamedTupleType) {
            this._tupleUpdate = new TupleUpdate(new TupleProjection(this._object, this._field.name()), this._value);
            if (VOID_ASSIGNMENTS) {
                typeChecker.unify(this._type, Type.VOID, this);
                this._tupleUpdate.typeCheck(typeChecker);
            } else {
                this._tupleUpdate.typeCheck(this._type, typeChecker);
            }
            return;
        }
        this._fieldIsBoxed = ((Expression)application).type().isBoxedType();
        this._value.typeCheck(typeChecker);
        this._valueIsBoxed = this._value.type().isBoxedType();
        if (!(this._object.type() instanceof ClassType)) {
            throw this.locate(new AssignmentErrorException((Object)("bad field update: " + this._object.type() + " is not a class type")));
        }
        if (!this._field.codeEntry().isField()) {
            throw this.locate(new AssignmentErrorException((Object)("bad field update: " + this._field + " is not a field for class type " + this._object.type())));
        }
        typeChecker.disallowVoid(this._value.type(), this._value, "assigned value");
        if (VOID_ASSIGNMENTS) {
            typeChecker.unify(((Expression)application).typeRef(), this._value.typeRef());
            typeChecker.typeCheck(this, Type.VOID);
        } else {
            typeChecker.typeCheck(this, ((Expression)application).typeRef());
            typeChecker.typeCheck(this, this._value.typeRef());
            this.type().setBoxed(this._fieldIsBoxed);
        }
    }

    @Override
    public final void compile(Compiler compiler) {
        if (this._tupleUpdate != null) {
            this._tupleUpdate.compile(compiler);
            return;
        }
        DefinedEntry definedEntry = this._field.definedEntry();
        byte by = this._fieldIsBoxed ? (byte)3 : (byte)this._value.sort();
        this._value.compile(compiler);
        if (this._fieldIsBoxed) {
            if (!this._valueIsBoxed) {
                compiler.generateWrapper(this._value.sort());
            }
        } else if (this._valueIsBoxed) {
            compiler.generateUnwrapper(this._value.sort());
        }
        this._object.compile(compiler);
        switch (by) {
            case 1: {
                compiler.generate(new SetIntField(definedEntry));
                break;
            }
            case 2: {
                compiler.generate(new SetRealField(definedEntry));
                break;
            }
            default: {
                compiler.generate(new SetObjectField(definedEntry));
            }
        }
        if (VOID_ASSIGNMENTS) {
            compiler.generateStackPop(by);
        }
    }

    public final String toString() {
        return this._object + "." + this._field + " = " + this._value;
    }
}

