/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.kernel;

import hlt.language.design.instructions.ApplyIntCollectionFilterHomomorphism;
import hlt.language.design.instructions.ApplyObjectCollectionFilterHomomorphism;
import hlt.language.design.instructions.ApplyRealCollectionFilterHomomorphism;
import hlt.language.design.instructions.ApplySlicedInPlaceObjectFilterHomomorphism;
import hlt.language.design.instructions.ApplySlicedObjectCollectionFilterHomomorphism;
import hlt.language.design.instructions.ApplySlicedObjectFilterHomomorphism;
import hlt.language.design.instructions.Instruction;
import hlt.language.design.kernel.And;
import hlt.language.design.kernel.Compiler;
import hlt.language.design.kernel.Expression;
import hlt.language.design.kernel.Homomorphism;
import hlt.language.design.kernel.NoSuchSubexpressionException;
import hlt.language.design.kernel.Parameter;
import hlt.language.design.kernel.Scope;
import hlt.language.design.types.BoxableTypeConstant;
import hlt.language.design.types.Collection;
import hlt.language.design.types.FunctionType;
import hlt.language.design.types.Tables;
import hlt.language.design.types.Type;
import hlt.language.design.types.TypeChecker;
import hlt.language.design.types.TypingErrorException;
import hlt.language.tools.Misc;
import hlt.language.util.ArrayList;

public class FilterHomomorphism
extends Homomorphism {
    private Expression _filter;
    private Tables _tables;

    public FilterHomomorphism(Tables tables, Expression expression, Expression expression2, Expression expression3, Expression expression4, Expression expression5) {
        super(expression, expression2, expression3, expression4);
        this._tables = tables;
        this._filter = expression5;
    }

    private FilterHomomorphism(Tables tables, Expression expression, Expression expression2, Expression expression3, Expression expression4, Expression expression5, byte by) {
        this(tables, expression, expression2, expression3, expression4, expression5);
        this._inPlace = by;
    }

    @Override
    public final Expression copy() {
        FilterHomomorphism filterHomomorphism = new FilterHomomorphism(this._tables, this._collection.copy(), this._function.copy(), this._operation.copy(), this._identity.copy(), this._filter.copy(), this._inPlace);
        if (this._slicings != null) {
            Expression[] expressionArray = new Expression[this._slicings.length];
            int n = expressionArray.length;
            while (n-- > 0) {
                expressionArray[n] = this._slicings[n].copy();
            }
            filterHomomorphism.setSlicings(expressionArray);
        }
        return filterHomomorphism;
    }

    @Override
    public final Expression typedCopy() {
        FilterHomomorphism filterHomomorphism = new FilterHomomorphism(this._tables, this._collection.typedCopy(), this._function.typedCopy(), this._operation.typedCopy(), this._identity.typedCopy(), this._filter.copy(), this._inPlace);
        if (this._slicings != null) {
            Expression[] expressionArray = new Expression[this._slicings.length];
            int n = expressionArray.length;
            while (n-- > 0) {
                expressionArray[n] = this._slicings[n].typedCopy();
            }
            filterHomomorphism.setSlicings(expressionArray);
        }
        return filterHomomorphism.addTypes(this);
    }

    @Override
    public int numberOfSubexpressions() {
        if (this._filter == null) {
            return super.numberOfSubexpressions();
        }
        return super.numberOfSubexpressions() + 1;
    }

    @Override
    public final Expression subexpression(int n) throws NoSuchSubexpressionException {
        if (this._filter == null) {
            return super.subexpression(n);
        }
        switch (n) {
            case 0: {
                return this._collection;
            }
            case 1: {
                return this._function;
            }
            case 2: {
                return this._operation;
            }
            case 3: {
                return this._identity;
            }
            case 4: {
                return this._filter;
            }
        }
        int n2 = n - 5;
        if (this._slicings != null && n2 >= 0 && n2 < this._slicings.length) {
            return this._slicings[n2];
        }
        throw new NoSuchSubexpressionException(this, n);
    }

    @Override
    public final Expression setSubexpression(int n, Expression expression) throws NoSuchSubexpressionException {
        if (this._filter == null) {
            return super.setSubexpression(n, expression);
        }
        switch (n) {
            case 0: {
                this._collection = expression;
                break;
            }
            case 1: {
                this._function = expression;
                break;
            }
            case 2: {
                this._operation = expression;
                break;
            }
            case 3: {
                this._identity = expression;
                break;
            }
            case 4: {
                this._filter = expression;
                break;
            }
            default: {
                int n2 = n - 5;
                if (this._slicings != null && n2 >= 0 && n2 < this._slicings.length) {
                    this._slicings[n2] = expression;
                    break;
                }
                throw new NoSuchSubexpressionException(this, n);
            }
        }
        return this;
    }

    @Override
    public final void typeCheck(TypeChecker typeChecker) throws TypingErrorException {
        super.typeCheck(typeChecker);
        this._filter.typeCheck(new FunctionType(this._elementType, (Type)Type.BOOLEAN()), typeChecker);
    }

    @Override
    public final void setCheckedType() {
        if (this.setCheckedTypeLocked()) {
            return;
        }
        this._extractNewSlicings();
        if (this._filter != null) {
            this._filter.setCheckedType();
        }
        this._setCheckedTypeLocked = false;
        super.setCheckedType();
    }

    private final void _extractNewSlicings() {
        int n;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        Expression expression = ((Scope)this._filter).body();
        Parameter parameter = ((Scope)this._filter).parameter(0);
        this._extractFilters(expression, arrayList);
        for (n = 0; n < arrayList.size(); ++n) {
            expression = (Expression)arrayList.get(n);
            if (expression.isHiddenSlicing(this._tables, parameter)) {
                arrayList3.add(expression);
                continue;
            }
            arrayList2.add(expression);
        }
        if (arrayList2.isEmpty()) {
            this._filter = null;
        } else {
            expression = (Expression)arrayList2.get(0);
            for (n = 1; n < arrayList2.size(); ++n) {
                expression = new And(expression, (Expression)arrayList2.get(n));
            }
            ((Scope)this._filter).setBody(expression);
        }
        if (!arrayList3.isEmpty()) {
            int n2;
            n = this._slicings == null ? 0 : this._slicings.length;
            Expression[] expressionArray = new Expression[n + arrayList3.size()];
            for (n2 = 0; n2 < n; ++n2) {
                expressionArray[n2] = this._slicings[n2];
            }
            for (n2 = 0; n2 < arrayList3.size(); ++n2) {
                expressionArray[n + n2] = (Expression)arrayList3.get(n2);
            }
            this._slicings = expressionArray;
        }
    }

    private final void _extractFilters(Expression expression, ArrayList arrayList) {
        if (!(expression instanceof And)) {
            arrayList.add(expression);
            return;
        }
        this._extractFilters(((And)expression).left(), arrayList);
        this._extractFilters(((And)expression).right(), arrayList);
    }

    @Override
    protected final void _fixTypeBoxing() {
        FunctionType functionType;
        super._fixTypeBoxing();
        if (this._filter != null && (functionType = (FunctionType)this._filter.checkedType()).domain(0).kind() == 1) {
            ((BoxableTypeConstant)functionType.domain(0)).setBoxed(false);
            functionType.unsetDomainBox(0);
        }
    }

    @Override
    public final void compile(Compiler compiler) {
        if (this._filter == null) {
            super.compile(compiler);
            return;
        }
        int[][] nArray = null;
        this._fixTypeBoxing();
        this._identity.compile(compiler);
        if (!this._isInPlace()) {
            this._operation.compile(compiler);
        }
        this._function.compile(compiler);
        this._filter.compile(compiler);
        if (this._slicings != null) {
            nArray = this._compileSlicings(compiler);
        }
        this._collection.compile(compiler);
        if (this._isInPlace()) {
            switch (((Collection)((Object)this._collection.checkedType())).baseType().sort()) {
                case 1: {
                    compiler.generate(Instruction.APPLY_IP_FHOM_I);
                    break;
                }
                case 2: {
                    compiler.generate(Instruction.APPLY_IP_FHOM_R);
                    break;
                }
                case 3: {
                    if (this._slicings == null) {
                        compiler.generate(Instruction.APPLY_IP_FHOM_O);
                        break;
                    }
                    compiler.generate(new ApplySlicedInPlaceObjectFilterHomomorphism(nArray));
                }
            }
        } else {
            switch (((Collection)((Object)this._collection.checkedType())).baseType().sort()) {
                case 1: {
                    if (this._isCollection()) {
                        compiler.generate(new ApplyIntCollectionFilterHomomorphism(this._tally()));
                        break;
                    }
                    compiler.generate(Instruction.APPLY_FHOM_I);
                    break;
                }
                case 2: {
                    if (this._isCollection()) {
                        compiler.generate(new ApplyRealCollectionFilterHomomorphism(this._tally()));
                        break;
                    }
                    compiler.generate(Instruction.APPLY_FHOM_R);
                    break;
                }
                case 3: {
                    if (this._slicings == null) {
                        if (this._isCollection()) {
                            compiler.generate(new ApplyObjectCollectionFilterHomomorphism(this._tally()));
                            break;
                        }
                        compiler.generate(Instruction.APPLY_FHOM_O);
                        break;
                    }
                    if (this._isCollection()) {
                        compiler.generate(new ApplySlicedObjectCollectionFilterHomomorphism(nArray, this._tally()));
                        break;
                    }
                    compiler.generate(new ApplySlicedObjectFilterHomomorphism(nArray));
                }
            }
        }
    }

    @Override
    public final String toString() {
        if (this._filter == null) {
            return super.toString();
        }
        StringBuilder stringBuilder = new StringBuilder("f_hom(");
        stringBuilder.append(this._collection).append(',').append(this._function).append(',').append(this._operation).append(',').append(this._identity).append(',').append(this._filter);
        if (this._slicings != null) {
            stringBuilder.append(',').append(Misc.arrayToString(this._slicings));
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }
}

