/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.kernel;

import hlt.language.design.instructions.Call;
import hlt.language.design.kernel.Abstraction;
import hlt.language.design.kernel.Application;
import hlt.language.design.kernel.Compiler;
import hlt.language.design.kernel.Expression;
import hlt.language.design.kernel.Local;
import hlt.language.design.kernel.Parameter;
import hlt.language.design.kernel.ProtoExpression;
import hlt.language.design.types.BuiltinEntry;
import hlt.language.design.types.CodeEntry;
import hlt.language.design.types.DefinedEntry;
import hlt.language.design.types.FunctionType;
import hlt.language.design.types.GlobalTypingGoal;
import hlt.language.design.types.Symbol;
import hlt.language.design.types.Tables;
import hlt.language.design.types.Type;
import hlt.language.design.types.TypeChecker;
import hlt.language.design.types.TypeParameter;
import hlt.language.design.types.TypingErrorException;
import hlt.language.util.ArrayList;

public class Global
extends ProtoExpression {
    private Symbol _symbol;
    private CodeEntry _codeEntry;
    private CodeEntry _checkedCodeEntry;
    private Type _filter = new TypeParameter();
    private Tables _tables;

    public Global(Tables tables, String string) {
        this._tables = tables;
        this._symbol = this._tables.symbol(string);
    }

    public Global(Tables tables, String string, Type type) {
        this(tables, string);
        this.addType(type);
    }

    public Global(Symbol symbol) {
        this._symbol = symbol;
    }

    public Global(Tables tables, Symbol symbol) {
        this._tables = tables;
        this._symbol = symbol;
    }

    @Override
    public final Expression copy() {
        return new Global(this._tables, this._symbol);
    }

    @Override
    public final Expression typedCopy() {
        return new Global(this._tables, this._symbol).addTypes(this);
    }

    public static final Global dummyIndexSet() {
        return new Global(Symbol.INDEX_SET);
    }

    public static final Global dummyIndexable() {
        return new Global(Symbol.INDEXABLE);
    }

    public static final Global dummyCollection() {
        return new Global(Symbol.COLLECTION);
    }

    public final Global globalConstant(Type type) {
        this.setCodeEntry(this.symbol().getCodeEntry(type));
        this.setCheckedType(type);
        return this;
    }

    public final Global globalConstant(Type type, Type type2) {
        return this.globalConstant(new FunctionType(type, type2));
    }

    public final Type filter() {
        return this._filter.value();
    }

    public final Type sieve() {
        Type type = this.filter();
        return type.kind() == 2 ? this.type() : type;
    }

    public final String name() {
        return this._symbol.name();
    }

    @Override
    public final boolean containsFreeName(String string) {
        return string == this.name();
    }

    public final DefinedEntry definedEntry() {
        return (DefinedEntry)this._checkedCodeEntry;
    }

    public final CodeEntry checkedCodeEntry() {
        return this._checkedCodeEntry;
    }

    @Override
    public final void setCheckedType() {
        if (this.setCheckedTypeLocked()) {
            return;
        }
        this._checkedType = this.type().copy();
        this._checkedCodeEntry = this._codeEntry;
    }

    @Override
    public final void setCheckedType(Type type) {
        this._type = type;
        this.setCheckedType();
    }

    public final void resetCheckedType(Type type) {
        this._checkedType = type;
    }

    public final Symbol symbol() {
        return this._symbol;
    }

    public final CodeEntry codeEntry() {
        return this._checkedCodeEntry == null ? this._codeEntry : this._checkedCodeEntry;
    }

    public final void setCodeEntry(CodeEntry codeEntry) {
        this._codeEntry = codeEntry;
    }

    public final boolean isDefined() {
        return this._checkedCodeEntry != null;
    }

    private final ArrayList _eligibles() {
        ArrayList arrayList = this._symbol.typeTable();
        if (this.type().kind() == 2) {
            return arrayList;
        }
        ArrayList arrayList2 = new ArrayList(arrayList.size());
        for (CodeEntry codeEntry : arrayList) {
            if (!codeEntry.type().copy().unify(this.type().copy())) continue;
            arrayList2.add(codeEntry);
        }
        return arrayList2;
    }

    public final ArrayList viableTypes() {
        ArrayList arrayList = this._eligibles();
        if (this.filter().kind() == 2) {
            return arrayList;
        }
        ArrayList arrayList2 = new ArrayList(arrayList.size());
        for (CodeEntry codeEntry : arrayList) {
            if (!codeEntry.type().copy().unify(this.filter().copy())) continue;
            arrayList2.add(codeEntry);
        }
        return arrayList2;
    }

    @Override
    public final void typeCheck(TypeChecker typeChecker) throws TypingErrorException {
        if (this.typeCheckLocked()) {
            return;
        }
        if (!this._symbol.isDefined()) {
            typeChecker.error(new TypingErrorException((Object)("undefined symbol '" + this._symbol + "'")), this);
        }
        typeChecker.prove(new GlobalTypingGoal(this));
    }

    @Override
    public final void typeCheck(Type type, TypeChecker typeChecker) throws TypingErrorException {
        typeChecker.prune(this, type, this);
        this.typeCheck(typeChecker);
        typeChecker.unify(this.typeRef(), type, this);
    }

    @Override
    public final void compile(Compiler compiler) {
        if (this._checkedCodeEntry.isBuiltIn()) {
            if (this._checkedCodeEntry.type().kind() == 3) {
                this._compileCurryedBuiltin(compiler);
            } else {
                compiler.generate(((BuiltinEntry)this._checkedCodeEntry).builtIn());
            }
            return;
        }
        if (this.definedEntry().isInlinable()) {
            compiler.inline(this.definedEntry().code());
        } else {
            compiler.generate(new Call(this.definedEntry()));
        }
    }

    private final void _compileCurryedBuiltin(Compiler compiler) {
        FunctionType functionType = (FunctionType)this._checkedType;
        int n = functionType.arity();
        Parameter[] parameterArray = new Parameter[n];
        Expression[] expressionArray = new Local[n];
        for (int i = 0; i < n; ++i) {
            parameterArray[i] = new Parameter();
            parameterArray[i].setCheckedType(functionType.domain(i));
            expressionArray[i] = new Local(parameterArray[i]);
        }
        Application application = new Application((Expression)this, expressionArray);
        application.setCheckedType(functionType.range());
        Abstraction abstraction = new Abstraction(parameterArray, (Expression)application);
        abstraction.setNonExitable();
        abstraction.setSortedArities();
        int n2 = abstraction.intArity();
        int n3 = abstraction.realArity();
        int n4 = abstraction.objectArity();
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        block6: for (int i = 0; i < n; ++i) {
            switch (parameterArray[i].boxSort()) {
                case 1: {
                    ((Local)expressionArray[i]).setOffset(n2 - 1 - n5++);
                    continue block6;
                }
                case 2: {
                    ((Local)expressionArray[i]).setOffset(n3 - 1 - n6++);
                    continue block6;
                }
                case 3: {
                    ((Local)expressionArray[i]).setOffset(n4 - 1 - n7++);
                }
            }
        }
        abstraction.compile(compiler);
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Global)) {
            return false;
        }
        return this._symbol.equals(((Global)object).symbol());
    }

    public final String toString() {
        return this.name();
    }
}

