/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.kernel;

import hlt.language.design.instructions.SetGlobal;
import hlt.language.design.kernel.Assignment;
import hlt.language.design.kernel.AssignmentErrorException;
import hlt.language.design.kernel.Compiler;
import hlt.language.design.kernel.Expression;
import hlt.language.design.kernel.Global;
import hlt.language.design.kernel.ParameterStack;
import hlt.language.design.types.DefinedEntry;

public class GlobalAssignment
extends Assignment {
    public GlobalAssignment(Expression expression, Expression expression2) {
        this._lhs = expression;
        this._rhs = expression2;
    }

    @Override
    public final Expression copy() {
        return new GlobalAssignment(this._lhs.copy(), this._rhs.copy());
    }

    @Override
    public final Expression typedCopy() {
        return new GlobalAssignment(this._lhs.typedCopy(), this._rhs.typedCopy()).addTypes(this);
    }

    @Override
    public final Expression sanitizeNames(ParameterStack parameterStack) {
        this._lhs = this._lhs.sanitizeNames(parameterStack);
        this._rhs = this._rhs.sanitizeNames(parameterStack);
        if (!(this._lhs instanceof Global)) {
            throw this.locate(new AssignmentErrorException((Object)("unassignable location: " + this._lhs)));
        }
        return this;
    }

    @Override
    public final void compile(Compiler compiler) {
        Global global = (Global)this._lhs;
        DefinedEntry definedEntry = global.symbol().registerCodeEntry(global.checkedType().standardize());
        definedEntry.setInlinable(false);
        this._rhs.compile(compiler);
        if (this._rhs.checkedType().isBoxedType() && !this._lhs.checkedType().isBoxedType()) {
            compiler.generateUnwrapper(this._rhs.boxSort());
        }
        if (!this._rhs.checkedType().isBoxedType() && this._lhs.checkedType().isBoxedType()) {
            compiler.generateWrapper(this._rhs.boxSort());
        }
        compiler.generate(new SetGlobal(definedEntry));
        if (VOID_ASSIGNMENTS) {
            compiler.generateStackPop(definedEntry.type().boxSort());
        }
    }
}

