/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.kernel;

import hlt.language.design.kernel.Compiler;
import hlt.language.design.kernel.Expression;
import hlt.language.design.kernel.NoSuchSubexpressionException;
import hlt.language.design.kernel.ProtoExpression;
import hlt.language.design.types.DefinedType;
import hlt.language.design.types.Type;
import hlt.language.design.types.TypeChecker;
import hlt.language.design.types.TypingErrorException;

public class HideType
extends ProtoExpression {
    private Expression _expression;
    private Type _opaqueType;

    public HideType(Expression expression, Type type) {
        this._expression = expression;
        this._opaqueType = type;
    }

    @Override
    public final Expression copy() {
        return new HideType(this._expression.copy(), this._opaqueType);
    }

    @Override
    public final Expression typedCopy() {
        return new HideType(this._expression.typedCopy(), this._opaqueType).addTypes(this);
    }

    public final Expression expression() {
        return this._expression;
    }

    public final Type opaqueType() {
        return this._opaqueType;
    }

    @Override
    public final int numberOfSubexpressions() {
        return 1;
    }

    @Override
    public final Expression subexpression(int n) throws NoSuchSubexpressionException {
        if (n == 0) {
            return this._expression;
        }
        throw new NoSuchSubexpressionException(this, n);
    }

    @Override
    public final Expression setSubexpression(int n, Expression expression) throws NoSuchSubexpressionException {
        if (n != 0) {
            throw new NoSuchSubexpressionException(this, n);
        }
        this._expression = expression;
        return this;
    }

    @Override
    public final void setCheckedType() {
        if (this.setCheckedTypeLocked()) {
            return;
        }
        this.setCheckedType(this.type().copy());
        this._expression.setCheckedType();
    }

    @Override
    public final void typeCheck(TypeChecker typeChecker) throws TypingErrorException {
        if (this.typeCheckLocked()) {
            return;
        }
        if (this._opaqueType.kind() != 12) {
            typeChecker.error(this.locate(new TypingErrorException((Object)("can't hide into a non-opaque type: " + this._opaqueType))));
        }
        this._expression.typeCheck(((DefinedType)this._opaqueType).definition(), typeChecker);
        typeChecker.unify(this._type, this._opaqueType, this);
    }

    @Override
    public final void compile(Compiler compiler) {
        this._expression.compile(compiler);
    }

    public final String toString() {
        return this._expression + " as " + this._opaqueType;
    }
}

