/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.kernel;

import hlt.language.design.instructions.ApplyIntCollectionHomomorphism;
import hlt.language.design.instructions.ApplyObjectCollectionHomomorphism;
import hlt.language.design.instructions.ApplyRealCollectionHomomorphism;
import hlt.language.design.instructions.ApplySlicedInPlaceObjectHomomorphism;
import hlt.language.design.instructions.ApplySlicedObjectCollectionHomomorphism;
import hlt.language.design.instructions.ApplySlicedObjectHomomorphism;
import hlt.language.design.instructions.Instruction;
import hlt.language.design.kernel.Application;
import hlt.language.design.kernel.Compiler;
import hlt.language.design.kernel.Expression;
import hlt.language.design.kernel.Global;
import hlt.language.design.kernel.NoSuchSubexpressionException;
import hlt.language.design.kernel.ProtoExpression;
import hlt.language.design.kernel.TupleProjection;
import hlt.language.design.types.BaseTypeGoal;
import hlt.language.design.types.BoxableTypeConstant;
import hlt.language.design.types.Collection;
import hlt.language.design.types.FunctionType;
import hlt.language.design.types.ShadowUnifyGoal;
import hlt.language.design.types.Type;
import hlt.language.design.types.TypeChecker;
import hlt.language.design.types.TypeParameter;
import hlt.language.design.types.TypingErrorException;
import hlt.language.tools.Misc;
import hlt.language.util.ArrayList;

public class Homomorphism
extends ProtoExpression {
    protected Expression _collection;
    protected Expression _function;
    protected Expression _operation;
    protected Expression _identity;
    protected Type _elementType;
    protected Expression[] _slicings;
    protected byte _inPlace = 0;
    public static final byte DEFAULT_IN_PLACE = 0;
    public static final byte ENABLED_IN_PLACE = 1;
    public static final byte DISABLED_IN_PLACE = 2;

    public Homomorphism(Expression expression, Expression expression2, Expression expression3, Expression expression4) {
        this._collection = expression;
        this._function = expression2;
        this._operation = expression3;
        this._identity = expression4;
    }

    public Homomorphism(Expression expression, Expression expression2, Expression expression3, Expression expression4, boolean bl) {
        this(expression, expression2, expression3, expression4);
        if (bl) {
            this.enableInPlace();
        } else {
            this.disableInPlace();
        }
    }

    private Homomorphism(Expression expression, Expression expression2, Expression expression3, Expression expression4, byte by) {
        this(expression, expression2, expression3, expression4);
        this._inPlace = by;
    }

    @Override
    public Expression copy() {
        Homomorphism homomorphism = new Homomorphism(this._collection.copy(), this._function.copy(), this._operation.copy(), this._identity.copy(), this._inPlace);
        if (this._slicings != null) {
            Expression[] expressionArray = new Expression[this._slicings.length];
            int n = expressionArray.length;
            while (n-- > 0) {
                expressionArray[n] = this._slicings[n].copy();
            }
            homomorphism.setSlicings(expressionArray);
        }
        return homomorphism;
    }

    @Override
    public Expression typedCopy() {
        Homomorphism homomorphism = new Homomorphism(this._collection.typedCopy(), this._function.typedCopy(), this._operation.typedCopy(), this._identity.typedCopy(), this._inPlace);
        if (this._slicings != null) {
            Expression[] expressionArray = new Expression[this._slicings.length];
            int n = expressionArray.length;
            while (n-- > 0) {
                expressionArray[n] = this._slicings[n].typedCopy();
            }
            homomorphism.setSlicings(expressionArray);
        }
        return homomorphism.addTypes(this);
    }

    @Override
    public int numberOfSubexpressions() {
        return 4 + (this._slicings == null ? 0 : this._slicings.length);
    }

    @Override
    public Expression subexpression(int n) throws NoSuchSubexpressionException {
        switch (n) {
            case 0: {
                return this._collection;
            }
            case 1: {
                return this._function;
            }
            case 2: {
                return this._operation;
            }
            case 3: {
                return this._identity;
            }
        }
        int n2 = n - 4;
        if (this._slicings != null && n2 >= 0 && n2 < this._slicings.length) {
            return this._slicings[n2];
        }
        throw new NoSuchSubexpressionException(this, n);
    }

    @Override
    public Expression setSubexpression(int n, Expression expression) throws NoSuchSubexpressionException {
        switch (n) {
            case 0: {
                this._collection = expression;
                break;
            }
            case 1: {
                this._function = expression;
                break;
            }
            case 2: {
                this._operation = expression;
                break;
            }
            case 3: {
                this._identity = expression;
                break;
            }
            default: {
                int n2 = n - 4;
                if (this._slicings != null && n2 >= 0 && n2 < this._slicings.length) {
                    this._slicings[n2] = expression;
                    break;
                }
                throw new NoSuchSubexpressionException(this, n);
            }
        }
        return this;
    }

    public final void setSlicings(ArrayList arrayList) {
        this._slicings = new Expression[arrayList.size()];
        int n = this._slicings.length;
        while (n-- > 0) {
            this._slicings[n] = (Expression)arrayList.get(n);
        }
    }

    public final void setSlicings(Expression[] expressionArray) {
        this._slicings = expressionArray;
    }

    public final Homomorphism enableInPlace() {
        this._inPlace = 1;
        return this;
    }

    public final Homomorphism disableInPlace() {
        this._inPlace = (byte)2;
        return this;
    }

    @Override
    public void setCheckedType() {
        if (this.setCheckedTypeLocked()) {
            return;
        }
        this._collection.setCheckedType();
        this._function.setCheckedType();
        this._operation.setCheckedType();
        this._identity.setCheckedType();
        if (this._slicings != null) {
            int n = this._slicings.length;
            while (n-- > 0) {
                this._slicings[n].setCheckedType();
            }
        }
        this.setCheckedType(this.type().copy());
    }

    @Override
    public void typeCheck(TypeChecker typeChecker) throws TypingErrorException {
        if (this.typeCheckLocked()) {
            return;
        }
        this._elementType = new TypeParameter();
        TypeParameter typeParameter = new TypeParameter();
        this._collection.typeCheck(Global.dummyCollection(), typeChecker);
        this._identity.typeCheck(this._type, typeChecker);
        TypeParameter typeParameter2 = new TypeParameter();
        typeChecker.prove(new BaseTypeGoal(this._collection, this._elementType));
        typeChecker.prove(new ShadowUnifyGoal(typeParameter2, this._type));
        FunctionType functionType = new FunctionType(typeParameter, (Type)typeParameter2, this._type);
        this._operation.typeCheck(functionType, typeChecker);
        FunctionType functionType2 = new FunctionType(this._elementType, this._type);
        this._function.typeCheck(functionType2, typeChecker);
        if (this.type().rank() == ((Type)typeParameter).value().rank()) {
            typeChecker.prove(new ShadowUnifyGoal(this._type, typeParameter));
        } else {
            typeChecker.prove(new BaseTypeGoal(this, typeParameter));
        }
        if (this._slicings != null) {
            int n = this._slicings.length;
            while (n-- > 0) {
                this._slicings[n].typeCheck(Type.BOOLEAN(), typeChecker);
            }
        }
    }

    protected final boolean _isCollection() {
        FunctionType functionType = (FunctionType)this._operation.checkedType();
        return functionType.domain(1).rank() == 1 + functionType.domain(0).rank();
    }

    protected final boolean _isInPlace() {
        if (this._inPlace == 0) {
            return this._isCollection();
        }
        return this._inPlace == 1;
    }

    protected void _fixTypeBoxing() {
        Type type = this._identity.checkedType();
        FunctionType functionType = (FunctionType)this._operation.checkedType();
        FunctionType functionType2 = (FunctionType)this._function.checkedType();
        if (type.kind() == 1) {
            ((BoxableTypeConstant)type).setBoxed(false);
        }
        if (functionType.domain(0).kind() == 1) {
            ((BoxableTypeConstant)functionType.domain(0)).setBoxed(false);
            functionType.unsetDomainBox(0);
            if (functionType.domain(0).isEqualTo(functionType.domain(1))) {
                ((BoxableTypeConstant)functionType.domain(1)).setBoxed(false);
                functionType.unsetDomainBox(1);
                ((BoxableTypeConstant)functionType.range()).setBoxed(false);
                functionType.unsetRangeBox();
            }
        }
        if (functionType2.domain(0).kind() == 1) {
            ((BoxableTypeConstant)functionType2.domain(0)).setBoxed(false);
            functionType2.unsetDomainBox(0);
        }
    }

    @Override
    public void compile(Compiler compiler) {
        int[][] nArray = null;
        this._fixTypeBoxing();
        this._identity.compile(compiler);
        if (!this._isInPlace()) {
            this._operation.compile(compiler);
        }
        this._function.compile(compiler);
        if (this._slicings != null) {
            nArray = this._compileSlicings(compiler);
        }
        this._collection.compile(compiler);
        if (this._isInPlace()) {
            switch (((Collection)((Object)this._collection.checkedType())).baseType().sort()) {
                case 1: {
                    compiler.generate(Instruction.APPLY_IP_HOM_I);
                    break;
                }
                case 2: {
                    compiler.generate(Instruction.APPLY_IP_HOM_R);
                    break;
                }
                case 3: {
                    if (this._slicings == null) {
                        compiler.generate(Instruction.APPLY_IP_HOM_O);
                        break;
                    }
                    compiler.generate(new ApplySlicedInPlaceObjectHomomorphism(nArray));
                }
            }
        } else {
            switch (((Collection)((Object)this._collection.checkedType())).baseType().sort()) {
                case 1: {
                    if (this._isCollection()) {
                        compiler.generate(new ApplyIntCollectionHomomorphism(this._tally()));
                        break;
                    }
                    compiler.generate(Instruction.APPLY_HOM_I);
                    break;
                }
                case 2: {
                    if (this._isCollection()) {
                        compiler.generate(new ApplyRealCollectionHomomorphism(this._tally()));
                        break;
                    }
                    compiler.generate(Instruction.APPLY_HOM_R);
                    break;
                }
                case 3: {
                    if (this._slicings == null) {
                        if (this._isCollection()) {
                            compiler.generate(new ApplyObjectCollectionHomomorphism(this._tally()));
                            break;
                        }
                        compiler.generate(Instruction.APPLY_HOM_O);
                        break;
                    }
                    if (this._isCollection()) {
                        compiler.generate(new ApplySlicedObjectCollectionHomomorphism(nArray, this._tally()));
                        break;
                    }
                    compiler.generate(new ApplySlicedObjectHomomorphism(nArray));
                }
            }
        }
    }

    protected final int[][] _compileSlicings(Compiler compiler) {
        int[][] nArrayArray = new int[this._slicings.length][];
        int n = this._slicings.length;
        while (n-- > 0) {
            nArrayArray[n] = Homomorphism._compileSlicing(this._slicings[n], compiler);
        }
        return nArrayArray;
    }

    private static final int[] _compileSlicing(Expression expression, Compiler compiler) {
        TupleProjection tupleProjection = (TupleProjection)((Application)expression).argument(0);
        int n = tupleProjection.depth();
        int[] nArray = new int[n + 1];
        nArray[n] = tupleProjection.boxSort();
        int n2 = n;
        while (n2-- > 0) {
            nArray[n2] = tupleProjection.offset();
            if (n2 <= 0) continue;
            tupleProjection = (TupleProjection)tupleProjection.tuple();
        }
        Expression expression2 = ((Application)expression).argument(1);
        expression2.compile(compiler);
        if (!expression2.checkedType().isBoxedType()) {
            compiler.generateWrapper(expression2.sort());
        }
        return nArray;
    }

    protected final Instruction _tally() {
        switch (((FunctionType)this._operation.checkedType()).domain(0).sort()) {
            case 1: {
                return Instruction.APPLY_COLL_I;
            }
            case 2: {
                return Instruction.APPLY_COLL_R;
            }
        }
        return Instruction.APPLY_COLL_O;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("hom(");
        stringBuilder.append(this._collection).append(',').append(this._function).append(',').append(this._operation).append(',').append(this._identity);
        if (this._slicings != null) {
            stringBuilder.append(',').append(Misc.arrayToString(this._slicings));
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    protected final String _inPlace() {
        switch (this._inPlace) {
            case 1: {
                return "enabled in place";
            }
            case 2: {
                return "disabled in place";
            }
        }
        return "default: " + (this._isInPlace() ? "in " : "not in ") + "place";
    }
}

