/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.kernel;

import hlt.language.design.instructions.Jump;
import hlt.language.design.instructions.JumpOnFalse;
import hlt.language.design.kernel.Compiler;
import hlt.language.design.kernel.Expression;
import hlt.language.design.kernel.NoSuchSubexpressionException;
import hlt.language.design.kernel.ProtoExpression;
import hlt.language.design.types.Type;
import hlt.language.design.types.TypeChecker;
import hlt.language.design.types.TypingErrorException;

public class IfThenElse
extends ProtoExpression {
    private Expression _condition;
    private Expression _thenExpression;
    private Expression _elseExpression;

    public IfThenElse(Expression expression, Expression expression2, Expression expression3) {
        this._condition = expression;
        this._thenExpression = expression2;
        this._elseExpression = expression3;
    }

    @Override
    public final Expression copy() {
        return new IfThenElse(this._condition.copy(), this._thenExpression.copy(), this._elseExpression.copy());
    }

    @Override
    public final Expression typedCopy() {
        return new IfThenElse(this._condition.typedCopy(), this._thenExpression.typedCopy(), this._elseExpression.typedCopy()).addTypes(this);
    }

    @Override
    public final int numberOfSubexpressions() {
        return 3;
    }

    @Override
    public final Expression subexpression(int n) throws NoSuchSubexpressionException {
        switch (n) {
            case 0: {
                return this._condition;
            }
            case 1: {
                return this._thenExpression;
            }
            case 2: {
                return this._elseExpression;
            }
        }
        throw new NoSuchSubexpressionException(this, n);
    }

    @Override
    public final Expression setSubexpression(int n, Expression expression) throws NoSuchSubexpressionException {
        switch (n) {
            case 0: {
                this._condition = expression;
                break;
            }
            case 1: {
                this._thenExpression = expression;
                break;
            }
            case 2: {
                this._elseExpression = expression;
                break;
            }
            default: {
                throw new NoSuchSubexpressionException(this, n);
            }
        }
        return this;
    }

    @Override
    public final void setCheckedType() {
        if (this.setCheckedTypeLocked()) {
            return;
        }
        this.setCheckedType(this.type().copy());
        this._condition.setCheckedType();
        this._thenExpression.setCheckedType();
        this._elseExpression.setCheckedType();
    }

    @Override
    public final void typeCheck(TypeChecker typeChecker) throws TypingErrorException {
        if (this.typeCheckLocked()) {
            return;
        }
        this._condition.typeCheck(Type.BOOLEAN(), typeChecker);
        this._thenExpression.typeCheck(this.typeRef(), typeChecker);
        this._elseExpression.typeCheck(this.typeRef(), typeChecker);
    }

    @Override
    public final void compile(Compiler compiler) {
        this._condition.compile(compiler);
        if (this._condition.checkedType().isBoxedType()) {
            compiler.generateUnwrapper((byte)1);
        }
        JumpOnFalse jumpOnFalse = new JumpOnFalse();
        compiler.generate(jumpOnFalse);
        this._thenExpression.compile(compiler);
        Jump jump = new Jump();
        compiler.generate(jump);
        jumpOnFalse.setAddress(compiler.targetAddress());
        this._elseExpression.compile(compiler);
        jump.setAddress(compiler.targetAddress());
    }

    public final String toString() {
        return "if " + this._condition + " then " + this._thenExpression + " else " + this._elseExpression;
    }
}

