/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.kernel;

import hlt.language.design.instructions.PushValueInt;
import hlt.language.design.kernel.Compiler;
import hlt.language.design.kernel.Constant;
import hlt.language.design.types.Type;

public class Int
extends Constant {
    private int _value;

    public Int(int n, boolean bl) {
        this._type = bl ? Type.INT : Type.INT();
        this._setValue(n);
    }

    public Int(int n) {
        super(Type.INT());
        this._setValue(n);
    }

    public final int value() {
        return this._value;
    }

    private final void _setValue(int n) {
        this._value = n;
        if (n == 0) {
            this.setIsNull();
        }
    }

    @Override
    public final void compile(Compiler compiler) {
        compiler.generate(new PushValueInt(this._value));
    }

    @Override
    public final boolean equals(Object object) {
        if (!(object instanceof Int)) {
            return false;
        }
        return this._value == ((Int)object).value();
    }

    @Override
    public final String toString() {
        return String.valueOf(this._value);
    }
}

