/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.kernel;

import hlt.language.design.kernel.Application;
import hlt.language.design.kernel.Expression;
import hlt.language.design.kernel.Parameter;
import hlt.language.design.kernel.Scope;
import hlt.language.design.types.FunctionType;
import hlt.language.design.types.Type;
import hlt.language.design.types.TypeChecker;
import hlt.language.design.types.TypingErrorException;
import java.util.AbstractList;

public class Let
extends Application {
    protected Let() {
    }

    public Let(Parameter parameter, Expression expression, Expression expression2) {
        super((Expression)new Scope(parameter, expression2), expression);
    }

    public Let(AbstractList abstractList, AbstractList abstractList2, Expression expression) {
        super((Expression)new Scope(abstractList, expression), abstractList2);
    }

    public Let(Parameter[] parameterArray, Expression[] expressionArray, Expression expression) {
        super((Expression)new Scope(parameterArray, expression), expressionArray);
    }

    public Let(AbstractList abstractList, AbstractList abstractList2, AbstractList abstractList3, Expression expression) {
        super((Expression)new Scope(abstractList, expression), abstractList3);
        int n = abstractList.size();
        while (n-- > 0) {
            ((Scope)this.function()).parameter(n).setType((Type)abstractList2.get(n));
        }
    }

    @Override
    public void typeCheck(TypeChecker typeChecker) throws TypingErrorException {
        if (this.typeCheckLocked()) {
            return;
        }
        Scope scope = (Scope)this.function();
        Type[] typeArray = new Type[this.arity()];
        int n = this.arity();
        while (n-- > 0) {
            typeChecker.unify(scope.parameter(n).typeRef(), this._arguments[n].typeRef(), this);
            this._arguments[n].typeCheck(typeChecker);
            typeArray[n] = this._arguments[n].typeRef();
        }
        FunctionType functionType = new FunctionType(typeArray, this._type).setNoCurrying();
        this._function.typeCheck(functionType, typeChecker);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("let ");
        Scope scope = (Scope)this.function();
        for (int i = 0; i < this.arity(); ++i) {
            stringBuilder.append(scope.parameter(i)).append(" = ").append(this.argument(i)).append("; ");
        }
        stringBuilder.append("in ").append(scope.body());
        return stringBuilder.toString();
    }
}

