/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.kernel;

import hlt.language.design.instructions.PushOffsetInt;
import hlt.language.design.instructions.PushOffsetObject;
import hlt.language.design.instructions.PushOffsetReal;
import hlt.language.design.kernel.Compiler;
import hlt.language.design.kernel.Enclosure;
import hlt.language.design.kernel.Expression;
import hlt.language.design.kernel.Parameter;
import hlt.language.design.kernel.ParameterStack;
import hlt.language.design.types.Type;
import hlt.language.design.types.TypeChecker;
import hlt.language.design.types.TypingErrorException;
import java.util.Iterator;

public class Local
extends Expression {
    private Parameter _parameter;
    private int _offset = -1;

    public Local(Parameter parameter) {
        this._parameter = parameter;
    }

    public Local(Parameter parameter, Type type) {
        this._parameter = parameter;
        this.setType(type);
    }

    @Override
    public final Expression copy() {
        throw new UnsupportedOperationException("method copy may not be called on a Local! (" + this + ")");
    }

    @Override
    public final Expression typedCopy() {
        throw new UnsupportedOperationException("method typedCopy may not be called on a Local! (" + this + ")");
    }

    public final Parameter parameter() {
        return this._parameter;
    }

    public final int offset() {
        return this._offset;
    }

    public final void setOffset(int n) {
        this._offset = n;
    }

    public final void incOffset() {
        ++this._offset;
    }

    public final String name() {
        return this._parameter.name();
    }

    @Override
    public final Type typeRef() {
        return this._parameter.typeRef();
    }

    @Override
    public final Type type() {
        return this._parameter.type();
    }

    @Override
    public final void setType(Type type) {
        this._parameter.addType(type);
    }

    @Override
    public final Type checkedType() {
        return this._parameter.checkedType();
    }

    @Override
    public void setCheckedType() {
    }

    @Override
    public final void setCheckedType(Type type) {
    }

    @Override
    public final boolean containsFreeName(String string) {
        return string == this.name();
    }

    @Override
    public final void typeCheck(TypeChecker typeChecker) throws TypingErrorException {
        if (this.typeCheckLocked()) {
            return;
        }
        if (this._otherTypes != null) {
            Iterator iterator = this._otherTypes.iterator();
            while (iterator.hasNext()) {
                typeChecker.unify(this.type(), (Type)iterator.next(), this);
            }
        }
    }

    @Override
    public Expression sanitizeNames(ParameterStack parameterStack) {
        throw new UnsupportedOperationException("method sanitizeNames may not be called on a Local! (" + this + ")");
    }

    @Override
    public void sanitizeSorts(Enclosure enclosure) {
        enclosure.setLocalInfo(this);
    }

    @Override
    public Expression shiftOffsets(int n, int n2, int n3, int n4, int n5, int n6) {
        switch (this.boxSort()) {
            case 1: {
                if (this._offset < n4) break;
                this._offset += n;
                break;
            }
            case 2: {
                if (this._offset < n5) break;
                this._offset += n2;
                break;
            }
            case 3: {
                if (this._offset < n6) break;
                this._offset += n3;
            }
        }
        return this;
    }

    @Override
    public void compile(Compiler compiler) {
        switch (this.boxSort()) {
            case 1: {
                compiler.generate(new PushOffsetInt(this._offset));
                return;
            }
            case 2: {
                compiler.generate(new PushOffsetReal(this._offset));
                return;
            }
            case 3: {
                compiler.generate(new PushOffsetObject(this._offset));
                return;
            }
        }
    }

    public final String toString() {
        return this.name();
    }
}

