/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.kernel;

import hlt.language.design.instructions.SetOffsetInt;
import hlt.language.design.instructions.SetOffsetObject;
import hlt.language.design.instructions.SetOffsetReal;
import hlt.language.design.kernel.Assignment;
import hlt.language.design.kernel.AssignmentErrorException;
import hlt.language.design.kernel.Compiler;
import hlt.language.design.kernel.Expression;
import hlt.language.design.kernel.Local;
import hlt.language.design.kernel.ParameterStack;

public class LocalAssignment
extends Assignment {
    public LocalAssignment(Expression expression, Expression expression2) {
        this._lhs = expression;
        this._rhs = expression2;
    }

    @Override
    public final Expression copy() {
        return new LocalAssignment(this._lhs.copy(), this._rhs.copy());
    }

    @Override
    public final Expression typedCopy() {
        return new LocalAssignment(this._lhs.typedCopy(), this._rhs.typedCopy()).addTypes(this);
    }

    @Override
    public final Expression sanitizeNames(ParameterStack parameterStack) {
        this._lhs = this._lhs.sanitizeNames(parameterStack);
        this._rhs = this._rhs.sanitizeNames(parameterStack);
        if (!(this._lhs instanceof Local)) {
            throw this.locate(new AssignmentErrorException((Object)("unassignable location: " + this._lhs)));
        }
        return this;
    }

    @Override
    public final void compile(Compiler compiler) {
        this._rhs.compile(compiler);
        switch (this._lhs.boxSort()) {
            case 1: {
                if (this._rhs.checkedType().isBoxedType()) {
                    compiler.generateUnwrapper((byte)1);
                }
                compiler.generate(new SetOffsetInt(((Local)this._lhs).offset()));
                break;
            }
            case 2: {
                if (this._rhs.checkedType().isBoxedType()) {
                    compiler.generateUnwrapper((byte)2);
                }
                compiler.generate(new SetOffsetReal(((Local)this._lhs).offset()));
                break;
            }
            case 3: {
                if (!this._rhs.checkedType().isBoxedType()) {
                    compiler.generateWrapper(this._rhs.sort());
                }
                compiler.generate(new SetOffsetObject(((Local)this._lhs).offset()));
            }
        }
        if (VOID_ASSIGNMENTS) {
            compiler.generateStackPop(this._lhs.boxSort());
        }
    }
}

