/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.kernel;

import hlt.language.design.instructions.Jump;
import hlt.language.design.instructions.JumpOnFalse;
import hlt.language.design.kernel.Compiler;
import hlt.language.design.kernel.Expression;
import hlt.language.design.kernel.NoSuchSubexpressionException;
import hlt.language.design.types.Type;
import hlt.language.design.types.TypeChecker;
import hlt.language.design.types.TypingErrorException;
import hlt.language.tools.Misc;

public class Loop
extends Expression {
    private Expression _condition;
    private Expression _body;

    public Loop(Expression expression, Expression expression2) {
        this._condition = expression;
        this._body = expression2;
    }

    @Override
    public final Expression copy() {
        return new Loop(this._condition.copy(), this._body.copy());
    }

    @Override
    public final Expression typedCopy() {
        return new Loop(this._condition.typedCopy(), this._body.typedCopy()).addTypes(this);
    }

    @Override
    public final int numberOfSubexpressions() {
        return 2;
    }

    @Override
    public final Expression subexpression(int n) throws NoSuchSubexpressionException {
        switch (n) {
            case 0: {
                return this._condition;
            }
            case 1: {
                return this._body;
            }
        }
        throw new NoSuchSubexpressionException(this, n);
    }

    @Override
    public final Expression setSubexpression(int n, Expression expression) throws NoSuchSubexpressionException {
        switch (n) {
            case 0: {
                this._condition = expression;
                break;
            }
            case 1: {
                this._body = expression;
                break;
            }
            default: {
                throw new NoSuchSubexpressionException(this, n);
            }
        }
        return this;
    }

    @Override
    public final Type type() {
        return Type.VOID;
    }

    @Override
    public final void setType(Type type) {
        throw new UnsupportedOperationException("setType(Type) in class " + Misc.simpleClassName(this));
    }

    @Override
    public final Type typeRef() {
        return this.type();
    }

    @Override
    public final Type checkedType() {
        return this.type();
    }

    @Override
    public final void setCheckedType() {
        if (this.setCheckedTypeLocked()) {
            return;
        }
        this._condition.setCheckedType();
        this._body.setCheckedType();
    }

    @Override
    public final void setCheckedType(Type type) {
    }

    @Override
    public final void typeCheck(TypeChecker typeChecker) throws TypingErrorException {
        if (this.typeCheckLocked()) {
            return;
        }
        this._condition.typeCheck(Type.BOOLEAN(), typeChecker);
        this._body.typeCheck(typeChecker);
    }

    @Override
    public final void compile(Compiler compiler) {
        int n = compiler.targetAddress();
        this._condition.compile(compiler);
        if (this._condition.checkedType().isBoxedType()) {
            compiler.generateUnwrapper((byte)1);
        }
        JumpOnFalse jumpOnFalse = new JumpOnFalse();
        compiler.generate(jumpOnFalse);
        this._body.compile(compiler);
        compiler.generateStackPop(this._body.boxSort());
        compiler.generate(new Jump(n));
        jumpOnFalse.setAddress(compiler.targetAddress());
    }

    public final String toString() {
        return "while " + this._condition + " do " + this._body;
    }
}

