/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.kernel;

import hlt.language.design.kernel.Expression;
import hlt.language.design.kernel.Tuple;
import hlt.language.design.kernel.TupleFieldName;
import hlt.language.design.types.NamedTupleType;
import hlt.language.design.types.Type;
import hlt.language.design.types.TypeChecker;
import hlt.language.design.types.TypeParameter;
import hlt.language.design.types.TypingErrorException;
import hlt.language.tools.Misc;
import java.util.AbstractList;

public class NamedTuple
extends Tuple {
    private TupleFieldName[] _fields;

    private NamedTuple(Expression[] expressionArray, TupleFieldName[] tupleFieldNameArray) {
        this._components = expressionArray;
        this._fields = tupleFieldNameArray;
    }

    public NamedTuple(AbstractList abstractList, AbstractList abstractList2) {
        int n;
        this._fields = new TupleFieldName[abstractList2.size()];
        for (n = 0; n < this._fields.length; ++n) {
            this._fields[n] = new TupleFieldName((String)abstractList2.get(n), n);
        }
        if (this._fields.length > 0) {
            Misc.sort(this._fields);
        }
        this._components = new Expression[abstractList.size()];
        for (n = 0; n < this._components.length; ++n) {
            this._components[n] = (Expression)abstractList.get(this._fields[n].index());
        }
    }

    @Override
    public final Expression copy() {
        if (this._components == null) {
            return this;
        }
        Expression[] expressionArray = new Expression[this._components.length];
        int n = expressionArray.length;
        while (n-- > 0) {
            expressionArray[n] = this._components[n].copy();
        }
        return new NamedTuple(expressionArray, this._fields);
    }

    @Override
    public final Expression typedCopy() {
        if (this._components == null) {
            return this;
        }
        Expression[] expressionArray = new Expression[this._components.length];
        int n = expressionArray.length;
        while (n-- > 0) {
            expressionArray[n] = this._components[n].typedCopy();
        }
        return new NamedTuple(expressionArray, this._fields).addTypes(this);
    }

    public final TupleFieldName[] fields() {
        return this._fields;
    }

    public final TupleFieldName field(int n) {
        for (int i = 0; i < this._fields.length; ++i) {
            if (this._fields[i].index() != n) continue;
            return this._fields[i];
        }
        return null;
    }

    @Override
    public final void typeCheck(TypeChecker typeChecker) throws TypingErrorException {
        if (this.typeCheckLocked()) {
            return;
        }
        this._checkDuplicateFields(typeChecker);
        Type[] typeArray = new Type[this.dimension()];
        int n = this.dimension();
        while (n-- > 0) {
            typeArray[n] = new TypeParameter();
            this._components[n].typeCheck(typeArray[n], typeChecker);
            typeChecker.disallowVoid(typeArray[n].value(), this._components[n], "tuple component");
        }
        typeChecker.typeCheck(this, new NamedTupleType(typeArray, this._fields));
    }

    private final void _checkDuplicateFields(TypeChecker typeChecker) throws TypingErrorException {
        TupleFieldName tupleFieldName = null;
        int n = this._fields.length;
        while (n-- > 0) {
            if (this._fields[n].equals(tupleFieldName)) {
                typeChecker.error(new TypingErrorException((Object)("duplicate field: " + tupleFieldName)).setExtent(this));
            }
            tupleFieldName = this._fields[n];
        }
    }

    @Override
    public final String toString() {
        int[] nArray = new int[this.dimension()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[this._fields[i].index()] = i;
        }
        StringBuilder stringBuilder = new StringBuilder("<");
        for (int i = 0; i < this.dimension(); ++i) {
            stringBuilder.append(this._fields[nArray[i]]).append("=").append(this.component(nArray[i])).append(i == this.dimension() - 1 ? "" : ",");
        }
        return stringBuilder.append(">").toString();
    }
}

