/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.kernel;

import hlt.language.design.instructions.Instruction;
import hlt.language.design.kernel.Compiler;
import hlt.language.design.kernel.Expression;
import hlt.language.design.kernel.Global;
import hlt.language.design.kernel.NoSuchSubexpressionException;
import hlt.language.design.kernel.ProtoExpression;
import hlt.language.design.types.ArrayType;
import hlt.language.design.types.Type;
import hlt.language.design.types.TypeChecker;
import hlt.language.design.types.TypingErrorException;
import java.util.AbstractList;

public class NewArray
extends ProtoExpression {
    private Type _baseType;
    private Expression[] _dimension;
    private static final byte _IA = 0;
    private static final byte _IM = 1;
    private static final byte _RA = 2;
    private static final byte _RM = 3;
    private static final byte _OA = 4;
    private static final byte _OM = 5;

    public NewArray(Type type, Expression[] expressionArray) {
        this._baseType = type;
        this._dimension = expressionArray;
    }

    public NewArray(Type type, AbstractList abstractList) {
        this._baseType = type;
        this._dimension = new Expression[abstractList.size()];
        for (int i = 0; i < this._dimension.length; ++i) {
            this._dimension[i] = (Expression)abstractList.get(i);
        }
    }

    @Override
    public final Expression copy() {
        Expression[] expressionArray = new Expression[this._dimension.length];
        int n = expressionArray.length;
        while (n-- > 0) {
            expressionArray[n] = this._dimension[n].copy();
        }
        return new NewArray(this._baseType, expressionArray);
    }

    @Override
    public final Expression typedCopy() {
        Expression[] expressionArray = new Expression[this._dimension.length];
        int n = expressionArray.length;
        while (n-- > 0) {
            expressionArray[n] = this._dimension[n].typedCopy();
        }
        return new NewArray(this._baseType, expressionArray).addTypes(this);
    }

    @Override
    public final int numberOfSubexpressions() {
        return this._dimension.length;
    }

    @Override
    public final Expression subexpression(int n) throws NoSuchSubexpressionException {
        if (n >= 0 && n < this._dimension.length) {
            return this._dimension[n];
        }
        throw new NoSuchSubexpressionException(this, n);
    }

    @Override
    public final Expression setSubexpression(int n, Expression expression) throws NoSuchSubexpressionException {
        if (n < 0 || n >= this._dimension.length) {
            throw new NoSuchSubexpressionException(this, n);
        }
        this._dimension[n] = expression;
        return this;
    }

    public final Expression[] dimension() {
        return this._dimension;
    }

    public final Type baseType() {
        return this._baseType.value();
    }

    @Override
    public final void setCheckedType() {
        if (this.setCheckedTypeLocked()) {
            return;
        }
        for (int i = 0; i < this._dimension.length; ++i) {
            this._dimension[i].setCheckedType();
        }
        this.setCheckedType(this.type().copy());
    }

    @Override
    public final void typeCheck(TypeChecker typeChecker) throws TypingErrorException {
        if (this.typeCheckLocked()) {
            return;
        }
        for (int i = 0; i < this._dimension.length; ++i) {
            this._dimension[i].typeCheck(Global.dummyIndexSet(), typeChecker);
        }
        typeChecker.typeCheck(this, this._baseType.array(this._dimension));
    }

    @Override
    public final void compile(Compiler compiler) {
        Expression expression = this._dimension[this._dimension.length - 1];
        Type type = expression.checkedType();
        boolean bl = type.isInt();
        byte by = ((ArrayType)this._checkedType).innerType(this._dimension.length).boxSort();
        int n = 0;
        expression.compile(compiler);
        if (bl) {
            if (type.isBoxedType()) {
                compiler.generateUnwrapper((byte)1);
            }
            switch (by) {
                case 1: {
                    n = NewArray._kind(compiler.generate(Instruction.PUSH_ARRAY_I));
                    break;
                }
                case 2: {
                    n = NewArray._kind(compiler.generate(Instruction.PUSH_ARRAY_R));
                    break;
                }
                case 3: {
                    n = NewArray._kind(compiler.generate(Instruction.PUSH_ARRAY_O));
                }
            }
        } else {
            switch (by) {
                case 1: {
                    n = NewArray._kind(compiler.generate(Instruction.PUSH_MAP_I));
                    break;
                }
                case 2: {
                    n = NewArray._kind(compiler.generate(Instruction.PUSH_MAP_R));
                    break;
                }
                case 3: {
                    n = NewArray._kind(compiler.generate(Instruction.PUSH_MAP_O));
                }
            }
        }
        int n2 = this._dimension.length - 1;
        while (n2-- > 0) {
            expression = this._dimension[n2];
            bl = expression.checkedType().isInt();
            expression.compile(compiler);
            if (bl) {
                switch (n) {
                    case 0: {
                        compiler.generate(Instruction.FILL_ARRAY_IA);
                        break;
                    }
                    case 1: {
                        compiler.generate(Instruction.FILL_ARRAY_IM);
                        break;
                    }
                    case 2: {
                        compiler.generate(Instruction.FILL_ARRAY_RA);
                        break;
                    }
                    case 3: {
                        compiler.generate(Instruction.FILL_ARRAY_RM);
                        break;
                    }
                    case 4: {
                        compiler.generate(Instruction.FILL_ARRAY_OA);
                        break;
                    }
                    case 5: {
                        compiler.generate(Instruction.FILL_ARRAY_OM);
                    }
                }
                n = 4;
                continue;
            }
            switch (n) {
                case 0: {
                    compiler.generate(Instruction.FILL_MAP_IA);
                    break;
                }
                case 1: {
                    compiler.generate(Instruction.FILL_MAP_IM);
                    break;
                }
                case 2: {
                    compiler.generate(Instruction.FILL_MAP_RA);
                    break;
                }
                case 3: {
                    compiler.generate(Instruction.FILL_MAP_RM);
                    break;
                }
                case 4: {
                    compiler.generate(Instruction.FILL_MAP_OA);
                    break;
                }
                case 5: {
                    compiler.generate(Instruction.FILL_MAP_OM);
                }
            }
            n = 5;
        }
    }

    private static final byte _kind(Instruction instruction) {
        if (instruction == Instruction.PUSH_ARRAY_I) {
            return 0;
        }
        if (instruction == Instruction.PUSH_ARRAY_R) {
            return 2;
        }
        if (instruction == Instruction.PUSH_ARRAY_O) {
            return 4;
        }
        if (instruction == Instruction.PUSH_MAP_I) {
            return 1;
        }
        if (instruction == Instruction.PUSH_MAP_R) {
            return 3;
        }
        if (instruction == Instruction.PUSH_MAP_O) {
            return 5;
        }
        return 5;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder("new " + this.baseType());
        for (int i = 0; i < this._dimension.length; ++i) {
            stringBuilder.append("[" + this._dimension[i] + "]");
        }
        return stringBuilder.toString();
    }
}

