/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.kernel;

import hlt.language.design.instructions.Instruction;
import hlt.language.design.instructions.PushValueInt;
import hlt.language.design.kernel.Compiler;
import hlt.language.design.kernel.Expression;
import hlt.language.design.kernel.NewCollection;
import hlt.language.design.types.BagType;
import hlt.language.design.types.Type;
import hlt.language.design.types.TypeChecker;
import hlt.language.design.types.TypeParameter;
import hlt.language.design.types.TypingErrorException;
import java.util.AbstractList;

public class NewBag
extends NewCollection {
    public NewBag() {
        this._kind = 8;
        this._baseType = new TypeParameter();
    }

    public NewBag(Type type) {
        this._kind = 8;
        this._baseType = type;
    }

    public NewBag(AbstractList abstractList) {
        this((Type)new TypeParameter(), abstractList);
    }

    public NewBag(Type type, AbstractList abstractList) {
        this._kind = 8;
        this._baseType = type;
        if (abstractList != null && !abstractList.isEmpty()) {
            this._elements = new Expression[abstractList.size()];
            int n = this._elements.length;
            while (n-- > 0) {
                this._elements[n] = (Expression)abstractList.get(n);
            }
        }
    }

    private NewBag(Type type, Expression[] expressionArray) {
        this._kind = 8;
        this._baseType = type;
        this._elements = expressionArray;
    }

    @Override
    protected NewCollection newCollection(Type type, Expression[] expressionArray) {
        return new NewBag(type, expressionArray);
    }

    @Override
    public final void typeCheck(TypeChecker typeChecker) throws TypingErrorException {
        if (this.typeCheckLocked()) {
            return;
        }
        int n = this.numberOfSubexpressions();
        while (n-- > 0) {
            this._elements[n].typeCheck(this._baseType, typeChecker);
        }
        typeChecker.typeCheck(this, new BagType(this._baseType));
    }

    @Override
    public final void compile(Compiler compiler) {
        if (this._elements != null) {
            int n = this._elements.length;
            while (n-- > 0) {
                this._elements[n].compile(compiler);
            }
            compiler.generate(new PushValueInt(this._elements.length));
        }
        switch (((BagType)this._checkedType).baseType().boxSort()) {
            case 1: {
                compiler.generate(this._elements == null ? Instruction.PUSH_SET_I : Instruction.MAKE_SET_I);
                return;
            }
            case 2: {
                compiler.generate(this._elements == null ? Instruction.PUSH_SET_R : Instruction.MAKE_SET_R);
                return;
            }
            case 3: {
                compiler.generate(this._elements == null ? Instruction.PUSH_SET_O : Instruction.MAKE_SET_O);
            }
        }
    }

    public final String toString() {
        if (this._elements == null) {
            return "new bag{" + (this._checkedType == null ? "" : this._checkedType.toString()) + "}";
        }
        StringBuilder stringBuilder = new StringBuilder("bag{");
        for (int i = 0; i < this._elements.length; ++i) {
            stringBuilder.append(this._elements[i] + (i == this._elements.length - 1 ? "}" : ","));
        }
        return stringBuilder.toString();
    }
}

