/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.kernel;

import hlt.language.design.instructions.PushNewObject;
import hlt.language.design.kernel.Compiler;
import hlt.language.design.kernel.Constant;
import hlt.language.design.types.ClassType;
import hlt.language.design.types.Type;
import hlt.language.design.types.TypeChecker;
import hlt.language.design.types.TypingErrorException;

public class NewObject
extends Constant {
    public NewObject(Type type) {
        this.setType(type);
    }

    @Override
    public final void typeCheck(TypeChecker typeChecker) throws TypingErrorException {
        if (this.typeCheckLocked()) {
            return;
        }
        if (!(this._type instanceof ClassType)) {
            typeChecker.error(this.locate(new TypingErrorException((Object)("bad class type: " + this._type))));
        }
        ClassType classType = (ClassType)this._type;
        int n = classType.arity();
        while (n-- > 0) {
            typeChecker.disallowVoid(classType.argument(n), this, "class type instantiation");
        }
    }

    @Override
    public final void compile(Compiler compiler) {
        compiler.generate(new PushNewObject((ClassType)this._type));
    }

    @Override
    public final String toString() {
        return "new " + this._type;
    }
}

