/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.kernel;

import hlt.language.design.kernel.Compiler;
import hlt.language.design.kernel.Expression;
import hlt.language.design.kernel.NoSuchSubexpressionException;
import hlt.language.design.kernel.ProtoExpression;
import hlt.language.design.types.DefinedType;
import hlt.language.design.types.TypeChecker;
import hlt.language.design.types.TypingErrorException;

public class OpenType
extends ProtoExpression {
    private Expression _expression;

    public OpenType(Expression expression) {
        this._expression = expression;
    }

    public final Expression expression() {
        return this._expression;
    }

    @Override
    public final Expression copy() {
        return new OpenType(this._expression.copy());
    }

    @Override
    public final Expression typedCopy() {
        return new OpenType(this._expression.typedCopy()).addTypes(this);
    }

    @Override
    public final int numberOfSubexpressions() {
        return 1;
    }

    @Override
    public final Expression subexpression(int n) throws NoSuchSubexpressionException {
        if (n == 0) {
            return this._expression;
        }
        throw new NoSuchSubexpressionException(this, n);
    }

    @Override
    public final Expression setSubexpression(int n, Expression expression) throws NoSuchSubexpressionException {
        if (n != 0) {
            throw new NoSuchSubexpressionException(this, n);
        }
        this._expression = expression;
        return this;
    }

    @Override
    public final void setCheckedType() {
        if (this.setCheckedTypeLocked()) {
            return;
        }
        this.setCheckedType(this.type().copy());
        this._expression.setCheckedType();
    }

    @Override
    public final void typeCheck(TypeChecker typeChecker) throws TypingErrorException {
        if (this.typeCheckLocked()) {
            return;
        }
        this._expression.typeCheck(typeChecker);
        if (this._expression.type().kind() != 12) {
            typeChecker.error(this.locate(new TypingErrorException((Object)("can't open a non-opaque type: " + this._expression.type()))));
        }
        typeChecker.unify(this._type, ((DefinedType)this._expression.type()).definition(), this);
    }

    @Override
    public final void compile(Compiler compiler) {
        this._expression.compile(compiler);
    }

    public final String toString() {
        return "OpenType(" + this._expression + ")";
    }
}

