/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.kernel;

import hlt.language.design.instructions.Instruction;
import hlt.language.design.instructions.Jump;
import hlt.language.design.instructions.JumpOnFalse;
import hlt.language.design.instructions.JumpOnTrue;
import hlt.language.design.kernel.AndOr;
import hlt.language.design.kernel.Compiler;
import hlt.language.design.kernel.Expression;

public class Or
extends AndOr {
    public Or(Expression expression, Expression expression2) {
        super(expression, expression2);
    }

    @Override
    public final Expression copy() {
        return new Or(this._left.copy(), this._left.copy());
    }

    @Override
    public final Expression typedCopy() {
        return new Or(this._left.copy(), this._left.copy()).addTypes(this);
    }

    @Override
    public final void compile(Compiler compiler) {
        this._left.compile(compiler);
        if (this._left.checkedType().isBoxedType()) {
            compiler.generateUnwrapper((byte)1);
        }
        JumpOnTrue jumpOnTrue = new JumpOnTrue();
        compiler.generate(jumpOnTrue);
        this._rite.compile(compiler);
        if (this._rite.checkedType().isBoxedType()) {
            compiler.generateUnwrapper((byte)1);
        }
        JumpOnFalse jumpOnFalse = new JumpOnFalse();
        compiler.generate(jumpOnFalse);
        jumpOnTrue.setAddress(compiler.targetAddress());
        if (this.checkedType().isBoxedType()) {
            compiler.generate(Instruction.PUSH_BOXED_TRUE);
        } else {
            compiler.generate(Instruction.PUSH_TRUE);
        }
        Jump jump = new Jump();
        compiler.generate(jump);
        jumpOnFalse.setAddress(compiler.targetAddress());
        if (this.checkedType().isBoxedType()) {
            compiler.generate(Instruction.PUSH_BOXED_FALSE);
        } else {
            compiler.generate(Instruction.PUSH_FALSE);
        }
        jump.setAddress(compiler.targetAddress());
    }

    public final String toString() {
        return this._left + " or " + this._rite;
    }
}

