/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.kernel;

import hlt.language.design.instructions.PushScope;
import hlt.language.design.kernel.Abstraction;
import hlt.language.design.kernel.Compiler;
import hlt.language.design.kernel.Enclosure;
import hlt.language.design.kernel.Expression;
import hlt.language.design.kernel.NoSuchSubexpressionException;
import hlt.language.design.kernel.Parameter;
import hlt.language.design.kernel.ParameterStack;
import hlt.language.design.kernel.ProtoExpression;
import hlt.language.design.types.FunctionType;
import hlt.language.design.types.Type;
import hlt.language.design.types.TypeChecker;
import hlt.language.design.types.TypingErrorException;
import java.util.AbstractList;
import java.util.HashMap;

public class Scope
extends ProtoExpression {
    protected Parameter[] _parameters;
    protected Expression _body;
    protected int _intArity;
    protected int _realArity;
    protected int _objectArity;
    private Expression _enclosingScope;
    protected boolean _isSortSanitized = false;

    public Scope(Parameter[] parameterArray, Expression expression) {
        this._parameters = parameterArray;
        this._body = expression;
        this._flatten();
    }

    public Scope(Parameter parameter, Expression expression) {
        this._parameters = new Parameter[1];
        this._parameters[0] = parameter;
        this._body = expression;
        this._flatten();
    }

    public Scope(String string, Expression expression) {
        this(new Parameter(string.intern()), expression);
    }

    public Scope(Expression expression) {
        this(new Parameter(), expression);
    }

    public Scope(AbstractList abstractList, Expression expression) {
        if (abstractList == null || abstractList.isEmpty()) {
            this._parameters = new Parameter[1];
            this._parameters[0] = Parameter.VOID;
        } else {
            this._parameters = new Parameter[abstractList.size()];
            for (int i = 0; i < this._parameters.length; ++i) {
                this._parameters[i] = new Parameter(((String)abstractList.get(i)).intern());
            }
        }
        this._body = expression;
        this._flatten();
    }

    @Override
    public Expression copy() {
        Parameter[] parameterArray = new Parameter[this._parameters.length];
        int n = parameterArray.length;
        while (n-- > 0) {
            parameterArray[n] = (Parameter)this._parameters[n].copy();
        }
        return new Scope(parameterArray, this._body.copy());
    }

    @Override
    public Expression typedCopy() {
        Parameter[] parameterArray = new Parameter[this._parameters.length];
        int n = parameterArray.length;
        while (n-- > 0) {
            parameterArray[n] = (Parameter)this._parameters[n].typedCopy();
        }
        return new Scope(parameterArray, this._body.typedCopy()).addTypes(this);
    }

    protected void _flatten() {
        if (this._body instanceof Scope && !(this._body instanceof Abstraction)) {
            Parameter[] parameterArray = ((Scope)this._body).parameters();
            Parameter[] parameterArray2 = new Parameter[this._parameters.length + parameterArray.length];
            int n = this._parameters.length;
            while (n-- > 0) {
                parameterArray2[n] = this._parameters[n];
            }
            for (n = this._parameters.length; n < parameterArray2.length; ++n) {
                parameterArray2[n] = parameterArray[n - this._parameters.length];
            }
            this._parameters = parameterArray2;
            this._body = ((Scope)this._body).body();
        }
    }

    public final int arity() {
        return this._parameters.length;
    }

    public final int intArity() {
        return this._intArity;
    }

    public final int realArity() {
        return this._realArity;
    }

    public final int objectArity() {
        return this._objectArity;
    }

    public final int voidArity() {
        return this._parameters.length - this._intArity - this._realArity - this._objectArity;
    }

    public final void setSortedArities() {
        block5: for (int i = 0; i < this._parameters.length; ++i) {
            switch (this._parameters[i].boxSort()) {
                case 1: {
                    ++this._intArity;
                    continue block5;
                }
                case 2: {
                    ++this._realArity;
                    continue block5;
                }
                case 3: {
                    ++this._objectArity;
                }
            }
        }
    }

    @Override
    public final int numberOfSubexpressions() {
        return this._parameters.length + 1;
    }

    @Override
    public final Expression subexpression(int n) throws NoSuchSubexpressionException {
        if (n >= 0 && n < this._parameters.length) {
            return this._parameters[n];
        }
        if (n == this._parameters.length) {
            return this._body;
        }
        throw new NoSuchSubexpressionException(this, n);
    }

    @Override
    public final Expression setSubexpression(int n, Expression expression) throws NoSuchSubexpressionException {
        if (n >= 0 && n < this._parameters.length) {
            this._parameters[n] = (Parameter)expression;
        } else if (n == this._parameters.length) {
            this._body = expression;
        } else {
            throw new NoSuchSubexpressionException(this, n);
        }
        return this;
    }

    @Override
    public final Parameter[] parameters() {
        return this._parameters;
    }

    public final Parameter parameter(int n) {
        return this._parameters[n];
    }

    public final Expression body() {
        return this._body;
    }

    public final void setBody(Expression expression) {
        this._body = expression;
    }

    @Override
    public final void setCheckedType(Type type) {
        this._checkedType = type;
        this.setSortedArities();
    }

    @Override
    public final void setCheckedType() {
        if (this.setCheckedTypeLocked()) {
            return;
        }
        this._checkedType = this.type().copy();
        for (int i = 0; i < this._parameters.length; ++i) {
            this._parameters[i].setCheckedType();
        }
        this._body.setCheckedType();
        this.setSortedArities();
    }

    @Override
    public void typeCheck(TypeChecker typeChecker) throws TypingErrorException {
        if (this.typeCheckLocked()) {
            return;
        }
        Type[] typeArray = new Type[this.arity()];
        for (int i = 0; i < this.arity(); ++i) {
            this._parameters[i].typeCheck(typeChecker);
            typeArray[i] = this._parameters[i].typeRef();
        }
        typeChecker.unify(this._type, new FunctionType(typeArray, this._body.typeRef()), this);
        this._body.typeCheck(typeChecker);
    }

    @Override
    public final boolean containsFreeName(String string) {
        int n = this._parameters.length;
        while (n-- > 0) {
            if (string != this._parameters[n].name()) continue;
            return false;
        }
        return this._body.containsFreeName(string);
    }

    @Override
    public final Expression enclosingScope() {
        return this._enclosingScope;
    }

    @Override
    final int linkScopeTree(Expression expression) {
        if (this._scopeTreeIsLinked) {
            return this._nestedComprehensionCount;
        }
        this._enclosingScope = expression;
        this._nestedComprehensionCount = this._body.linkScopeTree(this);
        this._scopeTreeIsLinked = true;
        return this._nestedComprehensionCount;
    }

    @Override
    public Expression substitute(HashMap hashMap) {
        if (hashMap.isEmpty()) {
            return this;
        }
        Object[] objectArray = new Object[this._parameters.length];
        int n = this._parameters.length;
        while (n-- > 0) {
            objectArray[n] = hashMap.remove(this._parameters[n].name());
        }
        if (!hashMap.isEmpty()) {
            this._body = this._body.substitute(hashMap);
        }
        n = this._parameters.length;
        while (n-- > 0) {
            if (objectArray[n] == null) continue;
            hashMap.put(this._parameters[n].name(), objectArray[n]);
        }
        return this;
    }

    @Override
    public final Expression sanitizeNames(ParameterStack parameterStack) {
        int n;
        for (n = 0; n < this._parameters.length; ++n) {
            parameterStack.push(this._parameters[n]);
        }
        this._body = this._body.sanitizeNames(parameterStack);
        for (n = 0; n < this._parameters.length; ++n) {
            parameterStack.pop();
        }
        return this;
    }

    @Override
    public void sanitizeSorts(Enclosure enclosure) {
        if (this._isSortSanitized) {
            return;
        }
        enclosure.push(this);
        this._body.sanitizeSorts(enclosure);
        enclosure.pop();
        this._isSortSanitized = true;
    }

    @Override
    public Expression shiftOffsets(int n, int n2, int n3, int n4, int n5, int n6) {
        this._body = this._body.shiftOffsets(n, n2, n3, n4 + this._intArity, n5 + this._realArity, n6 + this._objectArity);
        return this;
    }

    protected PushScope _pushInstruction() {
        return new PushScope(this.voidArity(), this._intArity, this._realArity, this._objectArity);
    }

    @Override
    public final void compile(Compiler compiler) {
        compiler.generate(this._pushInstruction(), this._body);
    }

    public String toString() {
        Object object = "scope";
        object = (String)object + "(";
        for (int i = 0; i < this.arity(); ++i) {
            object = (String)object + this._parameters[i];
            if (i >= this.arity() - 1) continue;
            object = (String)object + ",";
        }
        return (String)object + ") " + this._body;
    }
}

