/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.kernel;

import hlt.language.design.kernel.Compiler;
import hlt.language.design.kernel.Expression;
import hlt.language.design.kernel.NoSuchSubexpressionException;
import hlt.language.design.types.Type;
import hlt.language.design.types.TypeChecker;
import hlt.language.design.types.TypingErrorException;
import java.util.AbstractList;

public class Sequence
extends Expression {
    protected Expression[] _expressions;

    public Sequence(AbstractList abstractList) {
        this._expressions = new Expression[abstractList.size()];
        for (int i = 0; i < this._expressions.length; ++i) {
            this._expressions[i] = (Expression)abstractList.get(i);
        }
    }

    public Sequence(Expression[] expressionArray) {
        this._expressions = expressionArray;
    }

    public Sequence(Expression expression, Expression expression2) {
        Expression[] expressionArray = new Expression[]{expression, expression2};
        this._expressions = expressionArray;
    }

    @Override
    public Expression copy() {
        Expression[] expressionArray = new Expression[this._expressions.length];
        int n = expressionArray.length;
        while (n-- > 0) {
            expressionArray[n] = this._expressions[n].copy();
        }
        return new Sequence(expressionArray);
    }

    @Override
    public Expression typedCopy() {
        Expression[] expressionArray = new Expression[this._expressions.length];
        int n = expressionArray.length;
        while (n-- > 0) {
            expressionArray[n] = this._expressions[n].typedCopy();
        }
        return new Sequence(expressionArray).addTypes(this);
    }

    @Override
    public final int numberOfSubexpressions() {
        return this._expressions.length;
    }

    @Override
    public final Expression subexpression(int n) throws NoSuchSubexpressionException {
        if (n >= 0 && n < this._expressions.length) {
            return this._expressions[n];
        }
        throw new NoSuchSubexpressionException(this, n);
    }

    @Override
    public final Expression setSubexpression(int n, Expression expression) throws NoSuchSubexpressionException {
        if (n < 0 || n >= this._expressions.length) {
            throw new NoSuchSubexpressionException(this, n);
        }
        this._expressions[n] = expression;
        return this;
    }

    @Override
    public final Type type() {
        return this._expressions[this._expressions.length - 1].type();
    }

    @Override
    public final void setType(Type type) {
    }

    @Override
    public final Type typeRef() {
        return this._expressions[this._expressions.length - 1].typeRef();
    }

    @Override
    public final Type checkedType() {
        return this._expressions[this._expressions.length - 1].checkedType();
    }

    @Override
    public final void setCheckedType() {
        if (this.setCheckedTypeLocked()) {
            return;
        }
        for (int i = 0; i < this._expressions.length; ++i) {
            this._expressions[i].setCheckedType();
        }
    }

    @Override
    public final void setCheckedType(Type type) {
    }

    @Override
    public final void typeCheck(TypeChecker typeChecker) throws TypingErrorException {
        if (this.typeCheckLocked()) {
            return;
        }
        for (int i = 0; i < this._expressions.length; ++i) {
            this._expressions[i].typeCheck(typeChecker);
        }
    }

    @Override
    public void compile(Compiler compiler) {
        for (int i = 0; i < this._expressions.length; ++i) {
            this._expressions[i].compile(compiler);
            if (i >= this._expressions.length - 1) continue;
            compiler.generateStackPop(this._expressions[i].boxSort());
        }
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder("{ ");
        for (int i = 0; i < this._expressions.length; ++i) {
            stringBuilder.append(this._expressions[i] + "; ");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

