/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.kernel;

import hlt.language.design.instructions.PushTuple;
import hlt.language.design.kernel.Compiler;
import hlt.language.design.kernel.Expression;
import hlt.language.design.kernel.NoSuchSubexpressionException;
import hlt.language.design.kernel.ProtoExpression;
import hlt.language.design.types.TupleType;
import hlt.language.design.types.Type;
import hlt.language.design.types.TypeChecker;
import hlt.language.design.types.TypeParameter;
import hlt.language.design.types.TypingErrorException;
import java.util.AbstractList;

public class Tuple
extends ProtoExpression {
    protected Expression[] _components;
    public static final Tuple EMPTY = (Tuple)new Tuple().addType(TupleType.EMPTY);

    protected Tuple() {
    }

    private Tuple(Expression[] expressionArray) {
        this._components = expressionArray;
    }

    public static final Tuple newTuple(AbstractList abstractList) {
        if (abstractList == null || abstractList.size() == 0) {
            return EMPTY;
        }
        Expression[] expressionArray = new Expression[abstractList.size()];
        int n = expressionArray.length;
        while (n-- > 0) {
            expressionArray[n] = (Expression)abstractList.get(n);
        }
        return new Tuple(expressionArray);
    }

    @Override
    public Expression copy() {
        if (this._components == null) {
            return this;
        }
        Expression[] expressionArray = new Expression[this._components.length];
        int n = expressionArray.length;
        while (n-- > 0) {
            expressionArray[n] = this._components[n].copy();
        }
        return new Tuple(expressionArray);
    }

    @Override
    public Expression typedCopy() {
        if (this._components == null) {
            return this;
        }
        Expression[] expressionArray = new Expression[this._components.length];
        int n = expressionArray.length;
        while (n-- > 0) {
            expressionArray[n] = this._components[n].typedCopy();
        }
        return new Tuple(expressionArray).addTypes(this);
    }

    @Override
    public final int numberOfSubexpressions() {
        return this._components == null ? 0 : this._components.length;
    }

    @Override
    public final Expression subexpression(int n) throws NoSuchSubexpressionException {
        if (n >= 0 && n < this._components.length) {
            return this._components[n];
        }
        throw new NoSuchSubexpressionException(this, n);
    }

    @Override
    public final Expression setSubexpression(int n, Expression expression) throws NoSuchSubexpressionException {
        if (n < 0 || n >= this._components.length) {
            throw new NoSuchSubexpressionException(this, n);
        }
        this._components[n] = expression;
        return this;
    }

    public final int dimension() {
        return this._components == null ? 0 : this._components.length;
    }

    public final Expression component(int n) {
        return this._components[n];
    }

    @Override
    public final void setCheckedType() {
        if (this.setCheckedTypeLocked()) {
            return;
        }
        int n = this.dimension();
        while (n-- > 0) {
            this._components[n].setCheckedType();
        }
        this.setCheckedType(this.type().copy());
    }

    @Override
    public void typeCheck(TypeChecker typeChecker) throws TypingErrorException {
        if (this.typeCheckLocked()) {
            return;
        }
        Type[] typeArray = new Type[this.dimension()];
        int n = this.dimension();
        while (n-- > 0) {
            typeArray[n] = new TypeParameter();
            this._components[n].typeCheck(typeArray[n], typeChecker);
            typeChecker.disallowVoid(typeArray[n].value(), this._components[n], "tuple component");
        }
        typeChecker.typeCheck(this, TupleType.newTupleType(typeArray));
    }

    @Override
    public final void compile(Compiler compiler) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        TupleType tupleType = (TupleType)this.checkedType().actualType();
        int n4 = this.dimension();
        while (n4-- > 0) {
            this._components[n4].compile(compiler);
            switch (tupleType.component(n4).boxSort()) {
                case 1: {
                    ++n;
                    break;
                }
                case 2: {
                    ++n2;
                    break;
                }
                case 3: {
                    ++n3;
                }
            }
        }
        compiler.generate(new PushTuple(n, n2, n3));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("<");
        for (int i = 0; i < this.dimension(); ++i) {
            stringBuilder.append(this.component(i) + (i == this.dimension() - 1 ? "" : ","));
        }
        return stringBuilder.append(">").toString();
    }
}

