/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.kernel;

import hlt.language.design.instructions.GetIntTupleComponent;
import hlt.language.design.instructions.GetObjectTupleComponent;
import hlt.language.design.instructions.GetRealTupleComponent;
import hlt.language.design.kernel.Compiler;
import hlt.language.design.kernel.Constant;
import hlt.language.design.kernel.Dummy;
import hlt.language.design.kernel.DummyLocal;
import hlt.language.design.kernel.Expression;
import hlt.language.design.kernel.Int;
import hlt.language.design.kernel.NoSuchSubexpressionException;
import hlt.language.design.kernel.Parameter;
import hlt.language.design.kernel.ProtoExpression;
import hlt.language.design.kernel.StringConstant;
import hlt.language.design.types.NamedTupleType;
import hlt.language.design.types.TupleType;
import hlt.language.design.types.TypeChecker;
import hlt.language.design.types.TypingErrorException;

public class TupleProjection
extends ProtoExpression {
    private Expression _tuple;
    private Constant _field;
    private int _position;

    public TupleProjection(Expression expression, Constant constant) {
        this._tuple = expression;
        this._field = constant;
    }

    public TupleProjection(Expression expression, int n) {
        this(expression, new Int(n));
    }

    public TupleProjection(Expression expression, String string) {
        this(expression, new StringConstant(string));
    }

    @Override
    public final Expression copy() {
        return new TupleProjection(this._tuple.copy(), this._field);
    }

    @Override
    public final Expression typedCopy() {
        return new TupleProjection(this._tuple.typedCopy(), this._field).addTypes(this);
    }

    public final Expression tuple() {
        return this._tuple;
    }

    public final Constant field() {
        return this._field;
    }

    @Override
    public final int numberOfSubexpressions() {
        return 2;
    }

    @Override
    public final Expression subexpression(int n) throws NoSuchSubexpressionException {
        switch (n) {
            case 0: {
                return this._tuple;
            }
            case 1: {
                return this._field;
            }
        }
        throw new NoSuchSubexpressionException(this, n);
    }

    @Override
    public final Expression setSubexpression(int n, Expression expression) throws NoSuchSubexpressionException {
        switch (n) {
            case 0: {
                this._tuple = expression;
                break;
            }
            case 1: {
                this._field = (Constant)expression;
                break;
            }
            default: {
                throw new NoSuchSubexpressionException(this, n);
            }
        }
        return this;
    }

    public final boolean slicesParameter(Parameter parameter) {
        if (this._tuple instanceof TupleProjection) {
            return ((TupleProjection)this._tuple).slicesParameter(parameter);
        }
        if (this._tuple instanceof Dummy && ((Dummy)this._tuple).name() == parameter.name()) {
            this._tuple = new DummyLocal(parameter).addTypes(this._tuple).setExtent(this._tuple);
            return true;
        }
        return false;
    }

    public final int depth() {
        return 1 + (this._tuple instanceof TupleProjection ? ((TupleProjection)this._tuple).depth() : 0);
    }

    @Override
    public final void setCheckedType() {
        if (this.setCheckedTypeLocked()) {
            return;
        }
        this._tuple.setCheckedType();
        this.setCheckedType(this.type().copy());
    }

    public final void setPosition(String string) {
        this._position = ((NamedTupleType)this._tuple.type()).position(string);
    }

    @Override
    public final void typeCheck(TypeChecker typeChecker) throws TypingErrorException {
        TupleType tupleType;
        if (this.typeCheckLocked()) {
            return;
        }
        this._tuple.typeCheck(typeChecker);
        if (!(this._tuple.type().actualType() instanceof TupleType)) {
            typeChecker.error(new TypingErrorException((Object)("bad tuple type: " + this._tuple.type())), this);
        }
        if ((tupleType = (TupleType)this._tuple.type().actualType()).dimension() == 0) {
            typeChecker.error(new TypingErrorException((Object)"empty tuple projection"), this);
        }
        if (this._field instanceof StringConstant) {
            if (tupleType.kind() != 6) {
                typeChecker.error(new TypingErrorException((Object)("bad tuple field position: " + this._field + " should be an integer constant in [1," + tupleType.dimension() + "] range")), this._field);
            } else {
                this._position = ((NamedTupleType)tupleType).position(((StringConstant)this._field).stringValue());
                if (this._position == 0) {
                    typeChecker.error(new TypingErrorException((Object)("bad tuple field name: " + this._field + " is not in " + ((NamedTupleType)tupleType).fieldSet())), this._field);
                }
            }
        } else if (this._field instanceof Int) {
            if (tupleType.kind() == 6) {
                if (TypeChecker.ALLOWS_POSITIONAL_NAMED_TUPLES) {
                    this._position = ((NamedTupleType)tupleType).fieldPosition(((Int)this._field).value());
                    if (this._position <= 0 || this._position > tupleType.dimension()) {
                        typeChecker.error(new TypingErrorException((Object)("bad tuple field position: " + this._field + " is not in [1," + tupleType.dimension() + "] range")), this._field);
                    }
                } else {
                    typeChecker.error(new TypingErrorException((Object)("bad tuple field name: " + this._field + " should be a name in " + ((NamedTupleType)tupleType).fieldSet())), this._field);
                }
            } else {
                this._position = ((Int)this._field).value();
                if (this._position <= 0 || this._position > tupleType.dimension()) {
                    typeChecker.error(new TypingErrorException((Object)("bad tuple field position: " + this._field + " is not in [1," + tupleType.dimension() + "] range")), this._field);
                }
            }
        } else {
            typeChecker.error(new TypingErrorException((Object)("bad tuple field: " + this._field)), this._field);
        }
        typeChecker.typeCheck(this, tupleType.component(this._position - 1));
    }

    @Override
    public final void compile(Compiler compiler) {
        this._tuple.compile(compiler);
        switch (this.boxSort()) {
            case 1: {
                compiler.generate(new GetIntTupleComponent(this.offset()));
                return;
            }
            case 2: {
                compiler.generate(new GetRealTupleComponent(this.offset()));
                return;
            }
            case 3: {
                compiler.generate(new GetObjectTupleComponent(this.offset()));
            }
        }
    }

    public final int offset() {
        int n = 0;
        byte by = this.boxSort();
        TupleType tupleType = (TupleType)this._tuple.checkedType().actualType();
        for (int i = 0; i < this._position; ++i) {
            if (tupleType.component(i).boxSort() != by) continue;
            ++n;
        }
        return n;
    }

    public final String toString() {
        return this._tuple + "@" + this._field;
    }
}

