/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.kernel;

import hlt.language.design.instructions.Instruction;
import hlt.language.design.instructions.SetIntTupleComponent;
import hlt.language.design.instructions.SetObjectTupleComponent;
import hlt.language.design.instructions.SetRealTupleComponent;
import hlt.language.design.kernel.Compiler;
import hlt.language.design.kernel.Expression;
import hlt.language.design.kernel.NoSuchSubexpressionException;
import hlt.language.design.kernel.ProtoExpression;
import hlt.language.design.kernel.TupleProjection;
import hlt.language.design.types.Type;
import hlt.language.design.types.TypeChecker;
import hlt.language.design.types.TypingErrorException;

public class TupleUpdate
extends ProtoExpression {
    private Expression _component;
    private Expression _value;
    private boolean _componentIsBoxed = false;
    private boolean _valueIsBoxed = false;

    public TupleUpdate(Expression expression, Expression expression2) {
        this._component = expression;
        this._value = expression2;
    }

    @Override
    public final Expression copy() {
        return new TupleUpdate(this._component.copy(), this._value.copy());
    }

    @Override
    public final Expression typedCopy() {
        return new TupleUpdate(this._component.typedCopy(), this._value.typedCopy()).addTypes(this);
    }

    @Override
    public final int numberOfSubexpressions() {
        return 2;
    }

    @Override
    public final Expression subexpression(int n) throws NoSuchSubexpressionException {
        switch (n) {
            case 0: {
                return this._component;
            }
            case 1: {
                return this._value;
            }
        }
        throw new NoSuchSubexpressionException(this, n);
    }

    @Override
    public final Expression setSubexpression(int n, Expression expression) throws NoSuchSubexpressionException {
        switch (n) {
            case 0: {
                this._component = expression;
                break;
            }
            case 1: {
                this._value = expression;
                break;
            }
            default: {
                throw new NoSuchSubexpressionException(this, n);
            }
        }
        return this;
    }

    public final Expression tuple() {
        return ((TupleProjection)this._component).tuple();
    }

    @Override
    public final void setCheckedType() {
        if (this.setCheckedTypeLocked()) {
            return;
        }
        this._component.setCheckedType();
        this._value.setCheckedType();
        this._checkedType = this.type().copy();
    }

    @Override
    public final void typeCheck(TypeChecker typeChecker) throws TypingErrorException {
        if (this.typeCheckLocked()) {
            return;
        }
        this._component.typeCheck(typeChecker);
        this._componentIsBoxed = this._component.type().isBoxedType();
        this._value.typeCheck(typeChecker);
        this._valueIsBoxed = this._value.type().isBoxedType();
        typeChecker.disallowVoid(this._value.type(), this._value, "assigned value");
        if (VOID_ASSIGNMENTS) {
            typeChecker.unify(this._component.typeRef(), this._value.typeRef());
            typeChecker.typeCheck(this, Type.VOID);
        } else {
            typeChecker.typeCheck(this, this._component.typeRef());
            typeChecker.typeCheck(this, this._value.typeRef());
            this.type().setBoxed(this._componentIsBoxed);
        }
    }

    @Override
    public final void compile(Compiler compiler) {
        this.tuple().compile(compiler);
        this._value.compile(compiler);
        if (this._componentIsBoxed) {
            if (!this._valueIsBoxed) {
                compiler.generateWrapper(this._value.sort());
            }
        } else if (this._valueIsBoxed) {
            compiler.generateUnwrapper(this._value.sort());
        }
        byte by = this._componentIsBoxed ? (byte)3 : (byte)this._value.sort();
        compiler.generate(this._setTupleComponent(by));
        if (VOID_ASSIGNMENTS) {
            compiler.generateStackPop(by);
        }
    }

    private final Instruction _setTupleComponent(byte by) {
        int n = ((TupleProjection)this._component).offset();
        switch (by) {
            case 1: {
                return new SetIntTupleComponent(n);
            }
            case 2: {
                return new SetRealTupleComponent(n);
            }
        }
        return new SetObjectTupleComponent(n);
    }

    public final String toString() {
        return this._component + " = " + this._value;
    }
}

