/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.types;

import hlt.language.design.kernel.Expression;
import hlt.language.design.types.ArrayType;
import hlt.language.design.types.FailedUnificationException;
import hlt.language.design.types.Goal;
import hlt.language.design.types.Type;
import hlt.language.design.types.TypeChecker;
import hlt.language.util.Locatable;

public class ArrayIndexTypeGoal
extends Goal {
    private Expression _expression;
    private ArrayType _type;

    public ArrayIndexTypeGoal(Expression expression, ArrayType arrayType) {
        this._expression = expression;
        this._type = arrayType;
    }

    @Override
    final Locatable extent() {
        return this._expression;
    }

    final Expression expression() {
        return this._expression;
    }

    final Type arrayType() {
        return this._type;
    }

    @Override
    final void prove(TypeChecker typeChecker) throws FailedUnificationException {
        this.trail(typeChecker);
        this._expression.type().unify(this._type.indexType(), typeChecker);
    }

    @Override
    public final String toString() {
        return super.toString() + ": (array index type) array type => " + this._type.value() + ", expression => " + this._expression;
    }
}

