/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.types;

import hlt.language.design.types.ConstructedType;
import hlt.language.design.types.FailedUnificationException;
import hlt.language.design.types.NoSuchTypeComponentException;
import hlt.language.design.types.SetType;
import hlt.language.design.types.Type;
import hlt.language.design.types.TypeChecker;
import hlt.language.design.types.TypeClashException;
import hlt.language.design.types.TypeParameter;
import hlt.language.design.types.TypingErrorException;
import java.util.HashMap;
import java.util.HashSet;

public class ArrayType
extends ConstructedType {
    private Type _baseType;
    private Type _indexSetType;

    public ArrayType() {
        this._baseType = new TypeParameter();
        this._indexSetType = new TypeParameter();
    }

    public ArrayType(Type type) {
        if (type.value().isVoid()) {
            throw new TypingErrorException((Object)"void array base type");
        }
        this._baseType = type;
        this._indexSetType = new TypeParameter();
    }

    public ArrayType(Type type, Type type2) {
        this(type);
        this._indexSetType = type2;
    }

    @Override
    public final int numberOfTypeComponents() {
        return 2;
    }

    @Override
    public final Type typeRefComponent(int n) throws NoSuchTypeComponentException {
        switch (n) {
            case 0: {
                return this._baseType;
            }
            case 1: {
                return this._indexSetType;
            }
        }
        throw new NoSuchTypeComponentException(this, n);
    }

    @Override
    public final void setTypeRefComponent(int n, Type type) throws NoSuchTypeComponentException {
        switch (n) {
            case 0: {
                this._baseType = type;
                return;
            }
            case 1: {
                this._indexSetType = type;
                return;
            }
        }
        throw new NoSuchTypeComponentException(this, n);
    }

    @Override
    public final byte kind() {
        return 4;
    }

    @Override
    public final Type baseType() {
        return this._baseType.value();
    }

    public final Type indexSetType() {
        return this._indexSetType.value();
    }

    public final boolean isMap() {
        return !this.indexSetType().isInt();
    }

    public final Type indexType() {
        Type type = this._indexSetType.value();
        if (type.isInt() || type == Type.INT_RANGE) {
            return Type.INT();
        }
        return ((SetType)type).baseType();
    }

    @Override
    public final boolean isPolymorphic() {
        return this.baseType().isPolymorphic();
    }

    public final Type innermostType() {
        Type type = this.baseType();
        if (type.kind() == 4) {
            return ((ArrayType)type).innermostType();
        }
        return type;
    }

    public final Type innerType(int n) {
        if (n == 0) {
            return this;
        }
        Type type = this.baseType();
        if (type.kind() == 4) {
            return ((ArrayType)type).innerType(n - 1);
        }
        return type;
    }

    public final int dimension() {
        Type type = this.baseType();
        if (type.kind() == 4) {
            return 1 + ((ArrayType)type).dimension();
        }
        return 1;
    }

    public final Type dimension(int n) {
        int n2 = this.dimension() - 1;
        if (n > n2) {
            return null;
        }
        return this.relativeDimension(n2 - n, n2);
    }

    final Type relativeDimension(int n, int n2) {
        if (n == n2) {
            return this.indexSetType();
        }
        return ((ArrayType)this.baseType()).relativeDimension(n, n2 - 1);
    }

    public final Type projection(int n) {
        if (n <= 0) {
            return this;
        }
        Type type = this.baseType();
        if (n == 1) {
            return type;
        }
        if (type.kind() == 4) {
            return ((ArrayType)type).projection(n - 1);
        }
        return null;
    }

    @Override
    public final Type flatten() {
        this._baseType = this.baseType().flatten();
        this._indexSetType = this.indexSetType().flatten();
        return this;
    }

    @Override
    public final Type copy(HashMap hashMap) {
        return new ArrayType(this.baseType().copy(hashMap), this.indexSetType().copy(hashMap));
    }

    @Override
    public Type instantiate(HashMap hashMap) {
        return new ArrayType(this.baseType().instantiate(hashMap), this.indexSetType().instantiate(hashMap));
    }

    @Override
    public final void unify(Type type, TypeChecker typeChecker) throws FailedUnificationException {
        if ((type = type.value()) == this) {
            return;
        }
        switch (type.kind()) {
            case 2: {
                type.unify(this, typeChecker);
                return;
            }
            case 4: {
                this.baseType().unify(((ArrayType)type).baseType(), typeChecker);
                if (this.baseType().isVoid()) {
                    typeChecker.error(new TypingErrorException((Object)"void array base type"));
                }
                this.indexSetType().unify(((ArrayType)type).indexSetType(), typeChecker);
                return;
            }
        }
        typeChecker.error(new TypeClashException(this, type));
    }

    @Override
    public final boolean unify(Type type) {
        if ((type = type.findValue()) == this) {
            return true;
        }
        switch (type.kind()) {
            case 2: {
                ((TypeParameter)type).bind(this);
                return true;
            }
            case 4: {
                return this.baseType().unify(((ArrayType)type).baseType()) && this.indexSetType().unify(((ArrayType)type).indexSetType());
            }
        }
        return false;
    }

    @Override
    public final void checkOccurrence(TypeParameter typeParameter, Type type, TypeChecker typeChecker) throws FailedUnificationException {
        this.baseType().checkOccurrence(typeParameter, type, typeChecker);
        this.indexSetType().checkOccurrence(typeParameter, type, typeChecker);
    }

    @Override
    public final HashSet getParameters(HashSet hashSet) {
        return this.indexSetType().getParameters(this.baseType().getParameters(hashSet));
    }

    @Override
    public final int eqCode() {
        return this.kind() + this.baseType().eqCode() + this.indexSetType().eqCode();
    }

    @Override
    public final boolean isEqualTo(Type type) {
        return this == type || type.kind() == 4 && this.baseType().isEqualTo(((ArrayType)type).baseType()) && this.indexSetType().isEqualTo(((ArrayType)type).indexSetType());
    }

    @Override
    public final boolean isEqualTo(Type type, HashMap hashMap) {
        return this == type || type.kind() == 4 && this.baseType().isEqualTo(((ArrayType)type).baseType(), hashMap) && this.indexSetType().isEqualTo(((ArrayType)type).indexSetType(), hashMap);
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder("[").append(this.indexSetType()).append("]");
        Type type = this.baseType();
        while (type.kind() == 4) {
            stringBuilder.append("[").append(((ArrayType)type).indexSetType()).append("]");
            type = ((ArrayType)type).baseType();
        }
        return type + stringBuilder.toString();
    }
}

