/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.types;

import hlt.language.design.kernel.Expression;
import hlt.language.design.types.FailedUnificationException;
import hlt.language.design.types.Goal;
import hlt.language.design.types.Type;
import hlt.language.design.types.TypeChecker;
import hlt.language.util.Locatable;

public class BaseTypeGoal
extends Goal {
    private Expression _expression;
    private Type _type;

    public BaseTypeGoal(Expression expression, Type type) {
        this._expression = expression;
        this._type = type;
    }

    @Override
    final Locatable extent() {
        return this._expression;
    }

    final Expression expression() {
        return this._expression;
    }

    final Type type() {
        return this._type;
    }

    @Override
    final void prove(TypeChecker typeChecker) throws FailedUnificationException {
        this.trail(typeChecker);
        this._expression.type().baseType().unify(this._type, typeChecker);
    }

    @Override
    public final String toString() {
        return super.toString() + ": (base type) type => " + this._type.value() + ", base type => " + this._expression.type().baseType() + ", expression => " + this._expression;
    }
}

