/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.types;

import hlt.language.design.types.ConstructedType;
import hlt.language.design.types.FailedUnificationException;
import hlt.language.design.types.NoSuchTypeComponentException;
import hlt.language.design.types.Type;
import hlt.language.design.types.TypeChecker;
import hlt.language.design.types.TypeClashException;
import hlt.language.design.types.TypeParameter;
import java.util.HashMap;

public class BoxableTypeConstant
extends ConstructedType {
    private Type _type;
    private boolean _isBoxed = false;

    @Override
    public final int numberOfTypeComponents() {
        return 1;
    }

    @Override
    public final Type typeRefComponent(int n) throws NoSuchTypeComponentException {
        if (n == 0) {
            return this._type;
        }
        throw new NoSuchTypeComponentException(this, n);
    }

    @Override
    public final void setTypeRefComponent(int n, Type type) throws NoSuchTypeComponentException {
        if (n != 0) {
            throw new NoSuchTypeComponentException(this, n);
        }
        this._type = type;
    }

    public BoxableTypeConstant(Type type) {
        this._type = type;
    }

    public BoxableTypeConstant(Type type, boolean bl) {
        this._type = type.kind() != 1 ? type : ((BoxableTypeConstant)type).type();
        this._isBoxed = bl;
    }

    @Override
    public final Type setBoxed(boolean bl) {
        this._isBoxed = bl;
        return this;
    }

    @Override
    public final byte sort() {
        return this._type.sort();
    }

    public final Type type() {
        return this._type;
    }

    @Override
    public final boolean isBoxedType() {
        return this._isBoxed;
    }

    @Override
    public final byte kind() {
        return 1;
    }

    @Override
    public final Type copy(HashMap hashMap) {
        return new BoxableTypeConstant(this._type, this._isBoxed);
    }

    @Override
    public final void unify(Type type, TypeChecker typeChecker) throws FailedUnificationException {
        if ((type = type.value()) == this) {
            return;
        }
        switch (type.kind()) {
            case 1: {
                this._type.unify(((BoxableTypeConstant)type).type(), typeChecker);
                return;
            }
            case 0: {
                this._type.unify(type, typeChecker);
                return;
            }
            case 2: {
                type.unify(this, typeChecker);
                return;
            }
        }
        typeChecker.error(new TypeClashException(this, type));
    }

    @Override
    public final boolean unify(Type type) {
        if ((type = type.findValue()) == this) {
            return true;
        }
        switch (type.kind()) {
            case 2: {
                ((TypeParameter)type).bind(this);
                return true;
            }
            case 1: {
                return this._type.unify(((BoxableTypeConstant)type).type());
            }
            case 0: {
                return this._type.unify(type);
            }
        }
        return false;
    }

    @Override
    public final int eqCode() {
        return this.kind() + this._type.eqCode() * (this._isBoxed ? 2 : 1);
    }

    @Override
    public final boolean isEqualTo(Type type) {
        if (this == type) {
            return true;
        }
        if (!(type instanceof BoxableTypeConstant)) {
            return false;
        }
        return this._type == ((BoxableTypeConstant)type).type();
    }

    @Override
    public final boolean isEqualTo(Type type, HashMap hashMap) {
        return this.isEqualTo(type);
    }

    public final String toString() {
        Object object = this._isBoxed ? "[" + this._type + "]" : this._type.toString();
        return object;
    }
}

