/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.types;

import hlt.language.design.types.Bindable;
import hlt.language.design.types.GoalProver;
import hlt.language.design.types.TypeChecker;
import hlt.language.design.types.Valuable;
import java.util.BitSet;

class BoxingMask
extends BitSet
implements Bindable {
    private BoxingMask _value = this;
    private int _width;

    BoxingMask(int n) {
        super(n + 1);
        this._width = n;
    }

    BoxingMask(BoxingMask boxingMask) {
        this(boxingMask.width());
        this.or(boxingMask);
    }

    private final void _set(int n, boolean bl) {
        if (bl) {
            this.set(n);
        } else {
            this.clear(n);
        }
    }

    final int width() {
        return this._width;
    }

    final void setRangeBox() {
        this.set(0);
    }

    final void setRangeBox(boolean bl) {
        this._set(0, bl);
    }

    final void unsetRangeBox() {
        this.clear(0);
    }

    final boolean rangeIsBoxed() {
        return this.get(0);
    }

    final void setDomainBox(int n) {
        this.set(n + 1);
    }

    final void setDomainBox(int n, boolean bl) {
        this._set(n + 1, bl);
    }

    final void unsetDomainBox(int n) {
        this.clear(n + 1);
    }

    final boolean domainIsBoxed(int n) {
        return this.get(n + 1);
    }

    @Override
    public final boolean isBound() {
        return this._value != this;
    }

    @Override
    public final boolean isUnbound() {
        return this._value == this;
    }

    @Override
    public final boolean bind(Valuable valuable) {
        this._value = (BoxingMask)valuable;
        return true;
    }

    @Override
    public final boolean bind(Valuable valuable, GoalProver goalProver) {
        if (this != (valuable = valuable.getValue())) {
            this._value = (BoxingMask)valuable;
            goalProver.trail(this);
        }
        return true;
    }

    @Override
    public final void unbind() {
        this._value = this;
    }

    @Override
    public final Valuable getValue() {
        return this.value();
    }

    public final BoxingMask value() {
        return this._value == this ? this._value : this._value.value();
    }

    private final BoxingMask _unify(BoxingMask boxingMask) {
        BoxingMask boxingMask2 = new BoxingMask(this);
        boxingMask2.or(boxingMask);
        return boxingMask2;
    }

    public final void unify(BoxingMask boxingMask, TypeChecker typeChecker) {
        if (this.equals(boxingMask = boxingMask.value())) {
            return;
        }
        BoxingMask boxingMask2 = this._unify(boxingMask);
        if (!this.equals(boxingMask2)) {
            this.bind(boxingMask2);
            typeChecker.trail(this);
        }
        if (!boxingMask.equals(boxingMask2)) {
            boxingMask.bind(boxingMask2);
            typeChecker.trail(boxingMask);
        }
    }

    @Override
    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this._width; ++i) {
            stringBuilder.append(this.domainIsBoxed(i) ? "[]" : "_");
        }
        stringBuilder.append(" -> ");
        stringBuilder.append(this.rangeIsBoxed() ? "[]" : "_");
        return stringBuilder.toString();
    }
}

