/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.types;

import hlt.language.design.backend.ObjectInstance;
import hlt.language.design.backend.Runtime;
import hlt.language.design.backend.RuntimeInt;
import hlt.language.design.backend.RuntimeReal;
import hlt.language.design.instructions.Instruction;
import hlt.language.design.instructions.PushClosure;
import hlt.language.design.types.ClassDeclarationException;
import hlt.language.design.types.ClassType;
import hlt.language.design.types.DefinedEntry;
import hlt.language.design.types.DuplicateCodeEntryException;
import hlt.language.design.types.FunctionType;
import hlt.language.design.types.ObjectInitializationException;
import hlt.language.design.types.Tables;
import hlt.language.design.types.Type;
import hlt.language.design.types.TypeParameter;
import hlt.language.design.types.TypeTermScheme;
import hlt.language.design.types.TypingErrorException;
import java.util.AbstractList;

public class ClassInfo
extends TypeTermScheme {
    private DefinedEntry[] _fields;
    private DefinedEntry[] _methods;
    private int _intFieldsCount;
    private int _realFieldsCount;
    private int _objectFieldsCount;
    private boolean _isDeclared;
    private boolean _nestedInitialization;

    public final void fillClassInfo(Tables tables, ClassType classType, AbstractList abstractList, AbstractList abstractList2, AbstractList abstractList3, Type[] typeArray) throws ClassDeclarationException {
        this._parameters = (TypeParameter[])typeArray;
        int n = 0;
        int n2 = abstractList3.size();
        while (n2-- > 0) {
            n += abstractList3.get(n2) == null ? 0 : 1;
        }
        this._fields = new DefinedEntry[n];
        this._methods = new DefinedEntry[abstractList3.size() - n];
        n2 = 0;
        int n3 = 0;
        for (int i = 0; i < abstractList.size(); ++i) {
            String string = (String)abstractList.get(i);
            boolean bl = abstractList3.get(i) != null;
            Type type = (Type)abstractList2.get(i);
            FunctionType functionType = new FunctionType(classType, type);
            functionType = (FunctionType)functionType.flatten();
            try {
                if (bl) {
                    if (type.isVoid()) {
                        throw new TypingErrorException((Object)("a class field may not have void type: " + classType.name() + "." + string));
                    }
                    this._fields[n2++] = ((DefinedEntry)tables.symbol(string).getCodeEntry(functionType)).setIsField();
                    continue;
                }
                this._methods[n3++] = (DefinedEntry)tables.symbol(string).getCodeEntry(functionType);
                continue;
            }
            catch (TypingErrorException typingErrorException) {
                throw new ClassDeclarationException((Object)typingErrorException.msg());
            }
            catch (DuplicateCodeEntryException duplicateCodeEntryException) {
                throw new ClassDeclarationException((Object)("duplicate member '" + string + " : " + type + "' in class " + classType.name()));
            }
        }
        this._isDeclared = true;
    }

    public final boolean isDeclared() {
        return this._isDeclared;
    }

    public final void undeclareClass(Tables tables, ClassType classType) {
        int n;
        for (n = 0; n < this._fields.length; ++n) {
            if (this._fields[n] == null) continue;
            this._fields[n].symbol().removeLatestEntry();
        }
        for (n = 0; n < this._methods.length; ++n) {
            if (this._methods[n] == null) continue;
            this._methods[n].symbol().removeLatestEntry();
        }
        this._fields = null;
        this._methods = null;
        this._parameters = null;
        this._intFieldsCount = 0;
        this._realFieldsCount = 0;
        this._objectFieldsCount = 0;
        this._isDeclared = false;
        this._nestedInitialization = false;
    }

    final DefinedEntry[] fields() {
        return this._fields;
    }

    final DefinedEntry[] methods() {
        return this._methods;
    }

    final int intFieldsCount() {
        return this._intFieldsCount;
    }

    final int realFieldsCount() {
        return this._realFieldsCount;
    }

    final int objectFieldsCount() {
        return this._objectFieldsCount;
    }

    final int nextOffset(byte by) {
        switch (by) {
            case 1: {
                return this._intFieldsCount++;
            }
            case 2: {
                return this._realFieldsCount++;
            }
        }
        return this._objectFieldsCount++;
    }

    final void initialize(ObjectInstance objectInstance, ClassType classType, Runtime runtime) throws ObjectInitializationException {
        if (this._nestedInitialization) {
            this._nestedInitialization = false;
            throw new ObjectInitializationException((Object)("infinite nesting in class " + classType));
        }
        this._nestedInitialization = true;
        runtime.saveState();
        block6: for (int i = 0; i < this._fields.length; ++i) {
            runtime.pushObject(objectInstance);
            PushClosure pushClosure = (PushClosure)this._fields[i].initCode()[0];
            Instruction[] instructionArray = new Instruction[]{pushClosure, pushClosure.apply(), Instruction.STOP};
            runtime.setCode(instructionArray);
            runtime.resetIP();
            try {
                runtime.run();
            }
            catch (Exception exception) {
                throw new ObjectInitializationException((Object)("failed initializing field " + this._fields[i] + "\nDetail: " + exception));
            }
            switch (this._fields[i].fieldSort()) {
                case 1: {
                    int n = runtime.resultSort() == 3 ? ((RuntimeInt)runtime.popObject()).value() : runtime.popInt();
                    objectInstance.setIntField(this._fields[i].fieldOffset(), n);
                    continue block6;
                }
                case 2: {
                    double d = runtime.resultSort() == 3 ? ((RuntimeReal)runtime.popObject()).value() : runtime.popReal();
                    objectInstance.setRealField(this._fields[i].fieldOffset(), d);
                    continue block6;
                }
                default: {
                    Object object = runtime.resultSort() == 1 ? new RuntimeInt(runtime.popInt()) : (runtime.resultSort() == 2 ? new RuntimeReal(runtime.popReal()) : runtime.popObject());
                    objectInstance.setObjectField(this._fields[i].fieldOffset(), object);
                }
            }
        }
        runtime.restoreState();
        runtime.pushObject(objectInstance);
        this._nestedInitialization = false;
    }
}

