/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.types;

import hlt.language.design.backend.ObjectInstance;
import hlt.language.design.backend.Runtime;
import hlt.language.design.types.ClassDeclarationException;
import hlt.language.design.types.ClassInfo;
import hlt.language.design.types.DefinedEntry;
import hlt.language.design.types.FunctionType;
import hlt.language.design.types.ObjectInitializationException;
import hlt.language.design.types.Tables;
import hlt.language.design.types.Type;
import hlt.language.design.types.TypeParameter;
import hlt.language.design.types.TypeTerm;
import java.util.AbstractList;

public class ClassType
extends TypeTerm {
    private ClassInfo _classInfo;
    private Tables _tables;

    public ClassType(Tables tables, String string, Type[] typeArray, ClassInfo classInfo) {
        this._tables = tables;
        this._name = string.intern();
        this._arguments = typeArray;
        this._classInfo = classInfo;
    }

    public ClassType(Tables tables, String string) {
        this._tables = tables;
        this._name = string.intern();
        this._classInfo = new ClassInfo();
    }

    public ClassType(Tables tables, String string, AbstractList abstractList) {
        this(tables, string);
        this.setArguments(abstractList);
    }

    @Override
    public final byte kind() {
        return 10;
    }

    public final ClassInfo classInfo() {
        return this._classInfo;
    }

    public final boolean isDeclared() {
        return this._classInfo.isDeclared();
    }

    public final DefinedEntry[] fields() {
        return this._classInfo.fields();
    }

    public final DefinedEntry[] methods() {
        return this._classInfo.methods();
    }

    public final int intFieldsCount() {
        return this._classInfo.intFieldsCount();
    }

    public final int realFieldsCount() {
        return this._classInfo.realFieldsCount();
    }

    public final int objectFieldsCount() {
        return this._classInfo.objectFieldsCount();
    }

    public final int nextOffset(byte by) {
        return this._classInfo.nextOffset(by);
    }

    public final void bindArguments() {
        this._classInfo.bindParameters(this._arguments);
    }

    public final void unbindArguments() {
        this._classInfo.unbindParameters();
    }

    public final ClassType declareMembers(AbstractList abstractList, AbstractList abstractList2, AbstractList abstractList3, AbstractList abstractList4) throws ClassDeclarationException {
        if (abstractList4 != null && !abstractList4.isEmpty()) {
            this._arguments = new TypeParameter[abstractList4.size()];
            for (int i = 0; i < this._arguments.length; ++i) {
                this._arguments[i] = (TypeParameter)abstractList4.get(i);
            }
        }
        this._classInfo.fillClassInfo(this._tables, this, abstractList, abstractList2, abstractList3, this._arguments);
        return this;
    }

    public final void undeclareClass(Tables tables) {
        if (!this._classInfo.isDeclared()) {
            return;
        }
        this._classInfo.undeclareClass(tables, this);
    }

    public final void initialize(ObjectInstance objectInstance, Runtime runtime) throws ObjectInitializationException {
        this._classInfo.initialize(objectInstance, this, runtime);
    }

    private final Type _memberType(DefinedEntry definedEntry) {
        return ((FunctionType)definedEntry.type()).curryedRange();
    }

    @Override
    public final String toFullString() {
        this.bindArguments();
        StringBuilder stringBuilder = new StringBuilder(this.toString());
        if (this.isDeclared()) {
            int n;
            stringBuilder.append("\n\t{\n");
            for (n = 0; n < this.fields().length; ++n) {
                stringBuilder.append("\t  " + this.fields()[n].symbol() + " : " + this._memberType(this.fields()[n]) + ";\n");
            }
            if (this.methods().length > 0) {
                stringBuilder.append("\n");
            }
            for (n = 0; n < this.methods().length; ++n) {
                stringBuilder.append("\t  method " + this.methods()[n].symbol() + " : " + this._memberType(this.methods()[n]) + ";\n");
            }
            stringBuilder.append("\t}");
        } else {
            stringBuilder.append("\t[undeclared class]");
        }
        this.unbindArguments();
        return stringBuilder.toString();
    }
}

