/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.types;

import hlt.language.design.instructions.Instruction;
import hlt.language.design.types.BuiltinEntry;
import hlt.language.design.types.DefinedEntry;
import hlt.language.design.types.Symbol;
import hlt.language.design.types.Type;
import java.util.HashMap;

public abstract class CodeEntry {
    protected Symbol _symbol;
    protected Type _type;
    private static final HashMap _codeIds = new HashMap();

    public static final CodeId getId(Instruction[] instructionArray) {
        CodeId codeId = (CodeId)_codeIds.get(instructionArray);
        if (codeId == null) {
            codeId = new CodeId(_codeIds.size());
            _codeIds.put(instructionArray, codeId);
        }
        return codeId;
    }

    public static final void showCode(Instruction[] instructionArray) {
        CodeEntry._showCode(null, instructionArray, -1);
    }

    public static final void showCode(Instruction[] instructionArray, int n) {
        CodeEntry._showCode(null, instructionArray, n);
    }

    public static final void showCode(CodeEntry codeEntry, Instruction[] instructionArray) {
        CodeEntry._showCode(codeEntry, instructionArray, -1);
    }

    private static final void _showCode(CodeEntry codeEntry, Instruction[] instructionArray, int n) {
        CodeId codeId = CodeEntry.getId(instructionArray);
        if (codeEntry != null) {
            codeId.entry = codeEntry;
        }
        System.out.println();
        System.out.println(codeId);
        System.out.println();
        for (int i = 0; i < instructionArray.length; ++i) {
            if (i == n) {
                System.out.print("====>");
            }
            System.out.println("\t[" + i + "]\t" + instructionArray[i]);
        }
        System.out.println();
    }

    public final Symbol symbol() {
        return this._symbol;
    }

    public final Type type() {
        return this._type;
    }

    public final boolean isBuiltIn() {
        return this instanceof BuiltinEntry;
    }

    public boolean isProjection() {
        return this instanceof DefinedEntry && ((DefinedEntry)this).isProjection();
    }

    public boolean isField() {
        return this instanceof DefinedEntry && ((DefinedEntry)this).isField();
    }

    public boolean isDefinedField() {
        return this instanceof DefinedEntry && ((DefinedEntry)this).isDefinedField();
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CodeEntry)) {
            return false;
        }
        return this._symbol == ((CodeEntry)object).symbol() && this._type.isEqualTo(((CodeEntry)object).type(), new HashMap());
    }

    public String toString() {
        Type.resetNames();
        StringBuilder stringBuilder = new StringBuilder();
        String string = this._symbol != null ? this._symbol.toString() : "<no name>";
        stringBuilder.append(string + " : " + this._type.toQuantifiedString());
        return stringBuilder.toString();
    }

    public static class CodeId {
        int number;
        CodeEntry entry;

        CodeId(int n) {
            this.number = n;
        }

        public final String toString() {
            return "CODE: #" + this.number + (String)(this.entry == null ? "" : " " + this.entry);
        }
    }
}

