/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.types;

import hlt.language.design.types.Collection;
import hlt.language.design.types.ConstructedType;
import hlt.language.design.types.FailedUnificationException;
import hlt.language.design.types.NoSuchTypeComponentException;
import hlt.language.design.types.Type;
import hlt.language.design.types.TypeChecker;
import hlt.language.design.types.TypeClashException;
import hlt.language.design.types.TypeParameter;
import hlt.language.design.types.TypingErrorException;
import java.util.HashMap;
import java.util.HashSet;

public abstract class CollectionType
extends ConstructedType
implements Collection {
    protected Type _baseType;

    public abstract CollectionType newCollectionType(Type var1);

    @Override
    public final int numberOfTypeComponents() {
        return 1;
    }

    @Override
    public final Type typeRefComponent(int n) throws NoSuchTypeComponentException {
        if (n == 0) {
            return this._baseType;
        }
        throw new NoSuchTypeComponentException(this, n);
    }

    @Override
    public final void setTypeRefComponent(int n, Type type) throws NoSuchTypeComponentException {
        if (n != 0) {
            throw new NoSuchTypeComponentException(this, n);
        }
        this._baseType = type;
    }

    @Override
    public final Type baseTypeRef() {
        return this._baseType;
    }

    @Override
    public final Type baseType() {
        return this._baseType.value();
    }

    @Override
    public final boolean isPolymorphic() {
        return this.baseType().isPolymorphic();
    }

    @Override
    public final Type flatten() {
        this._baseType = this.baseType().flatten();
        return this;
    }

    @Override
    public final Type copy(HashMap hashMap) {
        return this.newCollectionType(this.baseType().copy(hashMap));
    }

    @Override
    public final Type instantiate(HashMap hashMap) {
        return this.newCollectionType(this.baseType().instantiate(hashMap));
    }

    @Override
    public final void unify(Type type, TypeChecker typeChecker) throws FailedUnificationException {
        if ((type = type.value()) == this) {
            return;
        }
        if (type.kind() == 2) {
            type.unify(this, typeChecker);
            return;
        }
        if (type instanceof CollectionType && this.kind() == type.kind()) {
            this.baseType().unify(((CollectionType)type).baseType(), typeChecker);
            if (this.baseType().isVoid()) {
                typeChecker.error(new TypingErrorException((Object)"void collection base type"));
            }
            return;
        }
        typeChecker.error(new TypeClashException(this, type));
    }

    @Override
    public final boolean unify(Type type) {
        if ((type = type.findValue()) == this) {
            return true;
        }
        if (type.kind() == 2) {
            ((TypeParameter)type).bind(this);
            return true;
        }
        if (type instanceof CollectionType && this.kind() == type.kind()) {
            return this.baseType().unify(((CollectionType)type).baseType());
        }
        return false;
    }

    @Override
    public final void checkOccurrence(TypeParameter typeParameter, Type type, TypeChecker typeChecker) throws FailedUnificationException {
        this.baseType().checkOccurrence(typeParameter, type, typeChecker);
    }

    @Override
    public final HashSet getParameters(HashSet hashSet) {
        return this.baseType().getParameters(hashSet);
    }

    @Override
    public final int eqCode() {
        return this.kind() + this.baseType().eqCode();
    }

    @Override
    public final boolean isEqualTo(Type type) {
        return this == type || this.kind() == type.kind() && this.baseType().isEqualTo(((CollectionType)type).baseType());
    }

    @Override
    public final boolean isEqualTo(Type type, HashMap hashMap) {
        return this == type || this.kind() == type.kind() && this.baseType().isEqualTo(((CollectionType)type).baseType(), hashMap);
    }
}

