/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.types;

import hlt.language.design.instructions.GetIntField;
import hlt.language.design.instructions.GetObjectField;
import hlt.language.design.instructions.GetRealField;
import hlt.language.design.instructions.Instruction;
import hlt.language.design.instructions.PushClosure;
import hlt.language.design.instructions.PushOffsetObject;
import hlt.language.design.instructions.PushValueInt;
import hlt.language.design.instructions.PushValueObject;
import hlt.language.design.instructions.PushValueReal;
import hlt.language.design.instructions.TupleComponentInstruction;
import hlt.language.design.types.ClassType;
import hlt.language.design.types.CodeEntry;
import hlt.language.design.types.FieldInfo;
import hlt.language.design.types.FunctionType;
import hlt.language.design.types.Symbol;
import hlt.language.design.types.Type;
import java.util.HashSet;

public class DefinedEntry
extends CodeEntry {
    private Instruction[] _code;
    private boolean _inlinable = true;
    private boolean _setOnEval = false;
    private HashSet _unsafeEntries;
    private HashSet _releasableEntries;
    private FieldInfo _fieldInfo;
    private boolean _isField = false;
    private boolean _isProjection = false;

    public DefinedEntry(Type type) {
        this._type = type;
    }

    public DefinedEntry(Symbol symbol, Type type) {
        this(type);
        this._symbol = symbol;
    }

    @Override
    public final boolean isProjection() {
        return this._isProjection;
    }

    public final DefinedEntry setIsProjection() {
        this._isProjection = true;
        return this;
    }

    @Override
    public final boolean isField() {
        return this._isField;
    }

    public final DefinedEntry setIsField() {
        this._isField = true;
        return this;
    }

    @Override
    public final boolean isDefinedField() {
        return this._fieldInfo != null;
    }

    public final void setFieldInfo() {
        this._fieldInfo = new FieldInfo(this);
        this._isField = true;
    }

    public final byte fieldSort() {
        return this.fieldType().boxSort();
    }

    public final int fieldOffset() {
        return this._fieldInfo.fieldOffset();
    }

    public final ClassType objectType() {
        return this._fieldInfo.objectType();
    }

    public final Type fieldType() {
        return this._fieldInfo != null ? this._fieldInfo.fieldType() : ((FunctionType)this.type()).curryedRange();
    }

    public final boolean isSetOnEvaluation() {
        return this._setOnEval;
    }

    public final void setOnEvaluation() {
        this._setOnEval = true;
        this._inlinable = false;
    }

    public final Instruction[] initCode() {
        return this._fieldInfo.initCode();
    }

    public final void setInlinable(boolean bl) {
        this._inlinable = bl;
    }

    public final boolean isInlinable() {
        return this._inlinable && this._code != null;
    }

    public final TupleComponentInstruction projection() {
        int n = this._code.length;
        while (n-- > 0) {
            if (!(this._code[n] instanceof TupleComponentInstruction)) continue;
            return (TupleComponentInstruction)this._code[n];
        }
        return null;
    }

    public final void setCode(Instruction[] instructionArray) {
        this._code = instructionArray;
    }

    public final Instruction[] code() {
        return this._code;
    }

    public final boolean hasNoCode() {
        return this._code == null;
    }

    public final boolean isUnsafe() {
        return this._code == null || this._unsafeEntries != null || this.isField() && this.fieldOffset() == -1;
    }

    public final void registerUnsafeEntry(CodeEntry codeEntry) {
        if (this._unsafeEntries == null) {
            this._unsafeEntries = new HashSet();
        }
        this._unsafeEntries.add(codeEntry);
    }

    public final void removeUnsafeEntry(CodeEntry codeEntry) {
        if (this._unsafeEntries == null) {
            return;
        }
        this._unsafeEntries.remove(codeEntry);
        if (this._unsafeEntries.isEmpty()) {
            this._unsafeEntries = null;
        }
    }

    public final void registerReleasableEntry(CodeEntry codeEntry) {
        if (this._releasableEntries == null) {
            this._releasableEntries = new HashSet();
        }
        this._releasableEntries.add(codeEntry);
    }

    public final void releaseUnsafeEntries() {
        if (this._releasableEntries == null) {
            return;
        }
        for (DefinedEntry definedEntry : this._releasableEntries) {
            definedEntry.removeUnsafeEntry(this);
            if (this._unsafeEntries == null) continue;
            for (DefinedEntry definedEntry2 : this._unsafeEntries) {
                definedEntry.registerUnsafeEntry(definedEntry2);
                definedEntry2.registerReleasableEntry(definedEntry);
            }
        }
        this._releasableEntries = null;
    }

    public final void setValue(int n) {
        Instruction[] instructionArray = new Instruction[]{new PushValueInt(n), Instruction.END};
        this._code = instructionArray;
        this.releaseUnsafeEntries();
        this._setOnEval = false;
    }

    public final void setValue(double d) {
        Instruction[] instructionArray = new Instruction[]{new PushValueReal(d), Instruction.END};
        this._code = instructionArray;
        this.releaseUnsafeEntries();
        this._setOnEval = false;
    }

    public final void setValue(Object object) {
        Instruction[] instructionArray = new Instruction[]{new PushValueObject(object), Instruction.END};
        this._code = instructionArray;
        this.releaseUnsafeEntries();
        this._setOnEval = false;
    }

    public final void setInitCode() {
        PushClosure pushClosure = new PushClosure(2, 0, 0, 1, 0, 0, 0);
        pushClosure.setNonExitable();
        Instruction[] instructionArray = new Instruction[]{pushClosure, Instruction.END, new PushOffsetObject(0), this._getField(), this._returnField()};
        instructionArray[0] = pushClosure.setReferenceCode(instructionArray);
        this._fieldInfo.setInitCode(this._code);
        this._code = instructionArray;
    }

    private final Instruction _getField() {
        switch (this.fieldSort()) {
            case 1: {
                return new GetIntField(this);
            }
            case 2: {
                return new GetRealField(this);
            }
            case 3: {
                return new GetObjectField(this);
            }
        }
        return null;
    }

    private final Instruction _returnField() {
        switch (this.fieldSort()) {
            case 1: {
                return Instruction.RETURN_I;
            }
            case 2: {
                return Instruction.RETURN_R;
            }
            case 3: {
                return Instruction.RETURN_O;
            }
        }
        return null;
    }

    public final void showCode() {
        if (this._code == null) {
            System.out.println(this + " has no code!");
            return;
        }
        System.out.println(this + " has the following code -\n");
        CodeEntry.showCode(this._code);
        if (this._fieldInfo == null) {
            return;
        }
        if (this.initCode() == null) {
            System.out.println(this + " has no initialization code!");
            return;
        }
        System.out.println(this + " has the following initialization code -\n");
        CodeEntry.showCode(this.initCode());
    }

    @Override
    public final String toString() {
        return "[" + (String)(this.isField() ? "field" : (this._code == null ? "un" : "") + "defined") + "] " + super.toString();
    }
}

