/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.types;

import hlt.language.design.types.FailedUnificationException;
import hlt.language.design.types.NoSuchTypeComponentException;
import hlt.language.design.types.Type;
import hlt.language.design.types.TypeChecker;
import hlt.language.design.types.TypeClashException;
import hlt.language.design.types.TypeParameter;
import hlt.language.design.types.TypeTerm;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.HashSet;

public class DefinedType
extends TypeTerm {
    private Type _definition;

    @Override
    public int numberOfTypeComponents() {
        return 1 + this.arity();
    }

    @Override
    public Type typeRefComponent(int n) throws NoSuchTypeComponentException {
        if (n == 0) {
            return this._definition;
        }
        if (n > 0 && n <= this.arity()) {
            return this._arguments[n - 1];
        }
        throw new NoSuchTypeComponentException(this, n);
    }

    @Override
    public void setTypeRefComponent(int n, Type type) throws NoSuchTypeComponentException {
        if (n == 0) {
            this._definition = type;
        } else if (n > 0 && n <= this.arity()) {
            this._arguments[n - 1] = type;
        } else {
            throw new NoSuchTypeComponentException(this, n);
        }
    }

    public DefinedType(String string, Type type) {
        this._name = string.intern();
        this._definition = type.flatten();
    }

    public DefinedType(String string, Type type, Type[] typeArray) {
        this(string, type);
        this.setArguments(typeArray);
    }

    public DefinedType(String string, Type type, AbstractList abstractList) {
        this(string, type);
        this.setArguments(abstractList);
    }

    @Override
    public final Type actualType() {
        Type type = this.definition();
        if (type.kind() != 12) {
            return type;
        }
        return ((DefinedType)type).actualType();
    }

    public final Type definition() {
        return this._definition.value();
    }

    public final DefinedType setDefinition(Type type) {
        this._definition = type;
        return this;
    }

    @Override
    public final byte kind() {
        return 12;
    }

    @Override
    public final boolean isPolymorphic() {
        return this.definition().isPolymorphic();
    }

    @Override
    public final byte sort() {
        return this.definition().sort();
    }

    @Override
    public final boolean isBoxedType() {
        return this.definition().isBoxedType();
    }

    @Override
    public final Type setBoxed(boolean bl) {
        this.definition().setBoxed(bl);
        return this;
    }

    @Override
    public final void unify(Type type, TypeChecker typeChecker) throws FailedUnificationException {
        if ((type = type.value()) == this) {
            return;
        }
        switch (type.kind()) {
            case 2: {
                type.unify(this, typeChecker);
                return;
            }
            case 12: {
                if (type.kind() != 12 || this._name != ((DefinedType)type).name()) {
                    typeChecker.error(new TypeClashException(this, type));
                }
                this.definition().unify(((DefinedType)type).definition(), typeChecker);
                return;
            }
            case 5: 
            case 6: {
                Type type2;
                if (!TypeChecker.ALLOWS_UNIFYING_OPAQUE_TUPLES || (type2 = this.actualType()).kind() != 5 && type2.kind() != 6) break;
                type2.unify(type, typeChecker);
                return;
            }
        }
        typeChecker.error(new TypeClashException(this, type));
    }

    @Override
    public final boolean unify(Type type) {
        if ((type = type.findValue()) == this) {
            return true;
        }
        switch (type.kind()) {
            case 2: {
                ((TypeParameter)type).bind(this);
                return true;
            }
            case 12: {
                return type.kind() == 12 && this._name == ((DefinedType)type).name() && this._definition.unify(((DefinedType)type).definition());
            }
            case 5: 
            case 6: {
                if (!TypeChecker.ALLOWS_UNIFYING_OPAQUE_TUPLES) break;
                Type type2 = this.actualType();
                return (type2.kind() == 5 || type2.kind() == 6) && type2.unify(type);
            }
        }
        return false;
    }

    @Override
    public final void checkOccurrence(TypeParameter typeParameter, Type type, TypeChecker typeChecker) throws FailedUnificationException {
        this.definition().checkOccurrence(typeParameter, type, typeChecker);
    }

    @Override
    public final HashSet getParameters(HashSet hashSet) {
        this.definition().getParameters(hashSet);
        return hashSet;
    }

    @Override
    public final void curry(int n, TypeChecker typeChecker) {
        this.definition().curry(n, typeChecker);
    }

    @Override
    public final Type flatten() {
        this.definition().flatten();
        return this;
    }

    @Override
    public final Type copy(HashMap hashMap) {
        return ((DefinedType)super.copy(hashMap)).setDefinition(this.definition().copy(hashMap));
    }

    @Override
    public final Type instantiate(HashMap hashMap) {
        return ((DefinedType)super.instantiate(hashMap)).setDefinition(this.definition().instantiate(hashMap));
    }

    @Override
    public final int eqCode() {
        return super.hashCode() + this.definition().eqCode();
    }
}

