/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.types;

import hlt.language.design.instructions.Instruction;
import hlt.language.design.types.ClassType;
import hlt.language.design.types.DefinedEntry;
import hlt.language.design.types.FunctionType;
import hlt.language.design.types.Type;

public class FieldInfo {
    private DefinedEntry _entry;
    private int _fieldOffset = -1;
    private Type _fieldType;
    private ClassType _objectType;
    private Instruction[] _initCode;

    FieldInfo(DefinedEntry definedEntry) {
        this._entry = definedEntry;
        FunctionType functionType = (FunctionType)definedEntry.type();
        this._objectType = (ClassType)functionType.domain(0);
        this._fieldType = functionType.curryedRange();
        this._fieldOffset = this._objectType.nextOffset(this.sort());
    }

    final ClassType objectType() {
        return this._objectType;
    }

    final Type fieldType() {
        return this._fieldType.value();
    }

    final byte sort() {
        return this.fieldType().boxSort();
    }

    final int fieldOffset() {
        return this._fieldOffset;
    }

    final Instruction[] initCode() {
        return this._initCode;
    }

    final void setInitCode(Instruction[] instructionArray) {
        this._initCode = instructionArray;
    }
}

