/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.types;

import hlt.language.design.types.BoxableTypeConstant;
import hlt.language.design.types.BoxingMask;
import hlt.language.design.types.ConstructedType;
import hlt.language.design.types.FailedUnificationException;
import hlt.language.design.types.NoSuchTypeComponentException;
import hlt.language.design.types.Type;
import hlt.language.design.types.TypeChecker;
import hlt.language.design.types.TypeClashException;
import hlt.language.design.types.TypeParameter;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.HashSet;

public class FunctionType
extends ConstructedType {
    private Type[] _domains;
    private Type _range;
    private BoxingMask _mask;
    protected boolean _noCurrying = false;

    @Override
    public final int numberOfTypeComponents() {
        return this._domains.length + 1;
    }

    @Override
    public final Type typeRefComponent(int n) {
        if (n >= 0 && n < this._domains.length) {
            return this._domains[n];
        }
        if (n == this._domains.length) {
            return this._range;
        }
        throw new NoSuchTypeComponentException(this, n);
    }

    @Override
    public final void setTypeRefComponent(int n, Type type) {
        if (n >= 0 && n < this._domains.length) {
            this._domains[n] = type;
        } else if (n == this._domains.length) {
            this._range = type;
        } else {
            throw new NoSuchTypeComponentException(this, n);
        }
    }

    public FunctionType() {
        this(1);
    }

    public FunctionType(int n) {
        this(n, (Type)new TypeParameter());
    }

    public FunctionType(int n, Type type) {
        this._domains = new Type[n];
        for (int i = 0; i < n; ++i) {
            this._domains[i] = new TypeParameter();
        }
        this._range = type;
        this._mask = new BoxingMask(n);
        this._setMaskBoxes();
    }

    public FunctionType(Type type, Type type2) {
        Type[] typeArray = new Type[]{type};
        this._domains = typeArray;
        this._range = type2;
        this._mask = new BoxingMask(1);
        this._setMaskBoxes();
    }

    public FunctionType(Type type, Type type2, Type type3) {
        Type[] typeArray = new Type[]{type, type2};
        this._domains = typeArray;
        this._range = type3;
        this._mask = new BoxingMask(1);
        this._setMaskBoxes();
    }

    public FunctionType(Type[] typeArray, Type type) {
        this._domains = typeArray;
        this._range = type;
        this._mask = new BoxingMask(typeArray.length);
        this._setMaskBoxes();
    }

    public FunctionType(Type[] typeArray, Type type, BoxingMask boxingMask) {
        this._domains = typeArray;
        this._range = type;
        this._mask = boxingMask;
    }

    public FunctionType(Type[] typeArray, Type type, FunctionType functionType) {
        this._domains = typeArray;
        this._range = type;
        this._mask = new BoxingMask(typeArray.length);
        this._setMaskBoxes(functionType);
    }

    public FunctionType(AbstractList abstractList, Type type) {
        if (!abstractList.isEmpty()) {
            this._domains = new Type[abstractList.size()];
            for (int i = 0; i < this._domains.length; ++i) {
                this._domains[i] = (Type)abstractList.get(i);
            }
        } else {
            this._domains = new Type[1];
            this._domains[0] = Type.VOID;
        }
        this._range = type;
        this._mask = new BoxingMask(this._domains.length);
        this._setMaskBoxes();
    }

    public final boolean noCurrying() {
        return this._noCurrying;
    }

    public final FunctionType setNoCurrying() {
        return this.setNoCurrying(true);
    }

    public final FunctionType setNoCurrying(boolean bl) {
        this._noCurrying = bl;
        return this;
    }

    @Override
    public final byte kind() {
        return 3;
    }

    public final Type[] domains() {
        return this._domains;
    }

    public final BoxingMask maskRef() {
        return this._mask;
    }

    public final BoxingMask mask() {
        return this._mask.value();
    }

    public final void setDomains(Type[] typeArray) {
        this._domains = typeArray;
    }

    public final void setRange(Type type) {
        this._range = type;
    }

    final void setMask(BoxingMask boxingMask) {
        this._mask = boxingMask;
    }

    public final Type domain(int n) {
        return this._domains[n].value();
    }

    public final Type domainRef(int n) {
        return this._domains[n];
    }

    public final Type rangeRef() {
        return this._range;
    }

    public final Type range() {
        return this._range.value();
    }

    @Override
    public final boolean isPolymorphic() {
        for (int i = 0; i < this._domains.length; ++i) {
            if (!this.domain(i).isPolymorphic()) continue;
            return true;
        }
        return this.range().isPolymorphic();
    }

    public final Type curryedRange() {
        int n = this.arity() - 1;
        if (n == 0) {
            return this.range();
        }
        Type[] typeArray = new Type[n];
        BoxingMask boxingMask = new BoxingMask(n);
        int n2 = n;
        while (n2-- > 0) {
            int n3 = n2 + 1;
            typeArray[n2] = this.domain(n3);
            if (!this.domainIsBoxed(n3)) continue;
            boxingMask.setDomainBox(n2);
        }
        if (this.rangeIsBoxed()) {
            boxingMask.setRangeBox();
        }
        return new FunctionType(typeArray, this.range(), boxingMask);
    }

    public final int arity() {
        return this._domains.length;
    }

    private final void _setMaskBoxes(FunctionType functionType) {
        for (int i = 0; i < this._domains.length; ++i) {
            if (!functionType.domainIsBoxed(i)) continue;
            this._mask.setDomainBox(i);
        }
        if (functionType.rangeIsBoxed()) {
            this._mask.setRangeBox();
        }
    }

    private final void _setMaskBoxes() {
        for (int i = 0; i < this._domains.length; ++i) {
            if (!this._domains[i].isBoxedType() || this._domains[i].kind() == 2) continue;
            this._mask.setDomainBox(i);
        }
        if (this._range.isBoxedType() && this._range.kind() != 2) {
            this._mask.setRangeBox();
        }
    }

    public final boolean trueDomainIsBoxed(int n) {
        return this._mask.domainIsBoxed(n);
    }

    public final boolean domainIsBoxed(int n) {
        return this.mask().domainIsBoxed(n);
    }

    public final void setDomainBox(int n) {
        this.mask().setDomainBox(n);
    }

    public final void unsetDomainBox(int n) {
        this.mask().unsetDomainBox(n);
    }

    public final boolean trueRangeIsBoxed() {
        return this._mask.rangeIsBoxed();
    }

    public final boolean rangeIsBoxed() {
        return this.mask().rangeIsBoxed();
    }

    public final void setRangeBox() {
        this.mask().setRangeBox();
    }

    public final void unsetRangeBox() {
        this.mask().unsetRangeBox();
    }

    public final boolean mustWrapArgument(FunctionType functionType, int n) {
        return !this.trueDomainIsBoxed(n) && functionType.trueDomainIsBoxed(n);
    }

    public final boolean mustUnwrapArgument(FunctionType functionType, int n) {
        return this.trueDomainIsBoxed(n) && !functionType.trueDomainIsBoxed(n);
    }

    public final boolean mustWrapResult(FunctionType functionType) {
        return this.trueRangeIsBoxed() && !functionType.trueRangeIsBoxed();
    }

    public final boolean mustUnwrapResult(FunctionType functionType) {
        return !this.trueRangeIsBoxed() && functionType.trueRangeIsBoxed();
    }

    public final boolean argumentSortsDisagree(FunctionType functionType, int n) {
        return this.mustWrapArgument(functionType, n) || this.mustUnwrapArgument(functionType, n);
    }

    public final boolean resultSortsDisagree(FunctionType functionType) {
        return this.mustWrapResult(functionType) || this.mustUnwrapResult(functionType);
    }

    @Override
    public final Type flatten() {
        for (int i = 0; i < this.arity(); ++i) {
            this._domains[i] = this._domains[i].flatten();
        }
        this._range = this._range.flatten();
        if (this._range.kind() == 3) {
            int n;
            FunctionType functionType = (FunctionType)this._range;
            Type[] typeArray = new Type[this.arity() + functionType.arity()];
            BoxingMask boxingMask = new BoxingMask(this.arity() + functionType.arity());
            for (n = 0; n < this._domains.length; ++n) {
                typeArray[n] = this._domains[n];
                if (!this.domainIsBoxed(n)) continue;
                boxingMask.setDomainBox(n);
            }
            while (n < typeArray.length) {
                typeArray[n] = functionType.domains()[n - this._domains.length];
                if (functionType.domainIsBoxed(n - this._domains.length)) {
                    boxingMask.setDomainBox(n);
                }
                ++n;
            }
            if (functionType.rangeIsBoxed()) {
                boxingMask.setRangeBox();
            }
            this._domains = typeArray;
            this._range = functionType.range();
            this._mask = boxingMask;
        }
        return this;
    }

    @Override
    public final void curry(int n, TypeChecker typeChecker) {
        int n2;
        if (n >= this.arity()) {
            return;
        }
        Type[] typeArray = new Type[n];
        BoxingMask boxingMask = new BoxingMask(n);
        Type[] typeArray2 = new Type[this.arity() - n];
        BoxingMask boxingMask2 = new BoxingMask(typeArray2.length);
        for (n2 = 0; n2 < n; ++n2) {
            typeArray[n2] = this.domain(n2);
            if (!this.domainIsBoxed(n2)) continue;
            boxingMask.setDomainBox(n2);
        }
        boxingMask.setRangeBox();
        for (n2 = n; n2 < this.arity(); ++n2) {
            typeArray2[n2 - n] = this.domain(n2);
            if (!this.domainIsBoxed(n2)) continue;
            boxingMask2.setDomainBox(n2 - n);
        }
        if (this.rangeIsBoxed()) {
            boxingMask2.setRangeBox();
        }
        typeChecker.trail(this, this._domains, this._range, this._mask);
        this._domains = typeArray;
        this._range = new FunctionType(typeArray2, this._range, boxingMask2);
        this._mask = boxingMask;
    }

    public final void curry(int n) {
        int n2;
        if (n >= this.arity()) {
            return;
        }
        Type[] typeArray = new Type[n];
        Type[] typeArray2 = new Type[this.arity() - n];
        for (n2 = 0; n2 < n; ++n2) {
            typeArray[n2] = this.domain(n2);
        }
        for (n2 = n; n2 < this.arity(); ++n2) {
            typeArray2[n2 - n] = this.domain(n2);
        }
        this._domains = typeArray;
        this._range = new FunctionType(typeArray2, this._range);
    }

    public final FunctionType uncurry() {
        int n;
        FunctionType functionType = (FunctionType)this.range();
        Type[] typeArray = new Type[this.arity() + functionType.arity()];
        BoxingMask boxingMask = new BoxingMask(typeArray.length);
        for (n = 0; n < this.arity(); ++n) {
            typeArray[n] = this.domain(n);
            if (!this.domainIsBoxed(n)) continue;
            boxingMask.setDomainBox(n);
        }
        for (n = this.arity(); n < typeArray.length; ++n) {
            int n2 = n - this.arity();
            typeArray[n] = functionType.domain(n2);
            if (!functionType.domainIsBoxed(n2)) continue;
            boxingMask.setDomainBox(n);
        }
        if (functionType.rangeIsBoxed()) {
            boxingMask.setRangeBox();
        }
        return new FunctionType(typeArray, functionType.range(), boxingMask);
    }

    @Override
    public final Type copy(HashMap hashMap) {
        Type type;
        Type[] typeArray = new Type[this.arity()];
        BoxingMask boxingMask = new BoxingMask(this.arity());
        for (int i = 0; i < this.arity(); ++i) {
            if (this.domainIsBoxed(i) || this.domain(i).isBoxedType()) {
                boxingMask.setDomainBox(i);
            }
            if (this.domain(i).kind() == 1) {
                typeArray[i] = new BoxableTypeConstant(this.domain(i), this.domainIsBoxed(i));
                continue;
            }
            typeArray[i] = this.domain(i).copy(hashMap);
            if (!typeArray[i].isPrimitive() || !this.domainIsBoxed(i)) continue;
            typeArray[i] = new BoxableTypeConstant(typeArray[i], true);
        }
        if (this.rangeIsBoxed() || this.range().isBoxedType()) {
            boxingMask.setRangeBox();
        }
        if (this.range().kind() == 1) {
            type = new BoxableTypeConstant(this.range(), this.rangeIsBoxed());
        } else {
            type = this.range().copy(hashMap);
            if (type.isPrimitive() && this.rangeIsBoxed()) {
                type = new BoxableTypeConstant(type, true);
            }
        }
        return new FunctionType(typeArray, type, boxingMask).setNoCurrying(this._noCurrying);
    }

    @Override
    public final Type instantiate(HashMap hashMap) {
        BoxingMask boxingMask = new BoxingMask(this.arity());
        Type type = this.range().instantiate(hashMap);
        if (type.isBoxedType()) {
            boxingMask.setRangeBox();
        }
        Type[] typeArray = new Type[this.arity()];
        for (int i = 0; i < typeArray.length; ++i) {
            typeArray[i] = this.domain(i).instantiate(hashMap);
            if (!typeArray[i].isBoxedType()) continue;
            boxingMask.setDomainBox(i);
        }
        return new FunctionType(typeArray, type, boxingMask).setNoCurrying(this._noCurrying);
    }

    @Override
    public final void unify(Type type, TypeChecker typeChecker) throws FailedUnificationException {
        if ((type = type.value()) == this) {
            return;
        }
        switch (type.kind()) {
            case 2: {
                type.unify(this, typeChecker);
                return;
            }
            case 3: {
                FunctionType functionType = (FunctionType)type;
                if (this.noCurrying() || functionType.noCurrying()) {
                    if (this.arity() != functionType.arity()) {
                        typeChecker.error(new TypeClashException((Object)"wrong number of arguments"));
                    }
                } else {
                    this.curry(functionType.arity(), typeChecker);
                    functionType.curry(this.arity(), typeChecker);
                }
                for (int i = 0; i < this.arity(); ++i) {
                    this.domain(i).unify(functionType.domains()[i], typeChecker);
                }
                this.range().unify(functionType.rangeRef(), typeChecker);
                return;
            }
        }
        typeChecker.error(new TypeClashException(this, type));
    }

    @Override
    public final boolean unify(Type type) {
        if ((type = type.findValue()) == this) {
            return true;
        }
        switch (type.kind()) {
            case 2: {
                ((TypeParameter)type).bind(this);
                return true;
            }
            case 3: {
                int n;
                boolean bl;
                FunctionType functionType = (FunctionType)type;
                if (!this.noCurrying() && !functionType.noCurrying()) {
                    this.curry(functionType.arity());
                    functionType.curry(this.arity());
                }
                boolean bl2 = bl = (n = this.arity()) == functionType.arity();
                while (bl && n-- > 0) {
                    bl &= this._domains[n].findValue().unify(functionType.domains()[n]);
                }
                return bl && this.rangeRef().findValue().unify(functionType.rangeRef());
            }
        }
        return false;
    }

    @Override
    public final void checkOccurrence(TypeParameter typeParameter, Type type, TypeChecker typeChecker) throws FailedUnificationException {
        for (int i = 0; i < this.arity(); ++i) {
            this.domain(i).checkOccurrence(typeParameter, type, typeChecker);
        }
        this.range().checkOccurrence(typeParameter, type, typeChecker);
    }

    @Override
    public final HashSet getParameters(HashSet hashSet) {
        int n = this.arity();
        while (n-- > 0) {
            this.domain(n).getParameters(hashSet);
        }
        return this.range().getParameters(hashSet);
    }

    @Override
    public final int eqCode() {
        int n = this.kind() + this.arity() + this.range().eqCode();
        for (int i = 0; i < this.arity(); ++i) {
            n += (i + 1) * this.domain(i).eqCode();
        }
        return n;
    }

    @Override
    public final boolean isEqualTo(Type type) {
        if (this == type) {
            return true;
        }
        if (type.kind() != 3) {
            return false;
        }
        FunctionType functionType = (FunctionType)type;
        if (this.arity() != functionType.arity()) {
            return false;
        }
        for (int i = 0; i < this.arity(); ++i) {
            if (this.domain(i).isEqualTo(functionType.domain(i))) continue;
            return false;
        }
        return this.range().isEqualTo(functionType.range());
    }

    @Override
    public final boolean isEqualTo(Type type, HashMap hashMap) {
        if (this == type) {
            return true;
        }
        if (type.kind() != 3) {
            return false;
        }
        FunctionType functionType = (FunctionType)type;
        if (this.arity() != functionType.arity()) {
            return false;
        }
        for (int i = 0; i < this.arity(); ++i) {
            if (this.domain(i).isEqualTo(functionType.domain(i), hashMap)) continue;
            return false;
        }
        return this.range().isEqualTo(functionType.range(), hashMap);
    }

    public final String maskString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.arity(); ++i) {
            if (this.domain(i).kind() == 3) {
                stringBuilder.append("(").append(((FunctionType)this.domain(i)).maskString()).append(")");
            } else {
                stringBuilder.append(this.domainIsBoxed(i) ? "[]" : "_");
            }
            if (i >= this.arity() - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(" -> ");
        if (this.range().kind() == 3) {
            stringBuilder.append(((FunctionType)this.range()).maskString());
        } else {
            stringBuilder.append(this.rangeIsBoxed() ? "[]" : "_");
        }
        return stringBuilder.toString();
    }

    public final String toString() {
        Object object;
        if (this.arity() == 1) {
            object = this.domain(0).toString();
            if (this.domain(0).kind() == 3) {
                object = "(" + (String)object + ")";
            }
            object = (String)object + " -> " + this.range();
        } else {
            object = "(";
            for (int i = 0; i < this.arity(); ++i) {
                object = (String)object + this.domain(i);
                if (i >= this.arity() - 1) continue;
                object = (String)object + ", ";
            }
            object = (String)object + ") -> " + this.range();
        }
        return object;
    }
}

