/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.types;

import hlt.language.design.kernel.Global;
import hlt.language.design.types.ChoicePoint;
import hlt.language.design.types.CodeEntry;
import hlt.language.design.types.FailedUnificationException;
import hlt.language.design.types.Goal;
import hlt.language.design.types.Type;
import hlt.language.design.types.TypeChecker;
import hlt.language.design.types.TypeClashException;
import hlt.language.design.types.TypingGoal;
import hlt.language.util.Locatable;
import java.util.Iterator;

public class GlobalTypingGoal
extends Goal {
    private Global _global;
    private TypingGoal _currentGoal;
    private boolean _initialized = false;
    private ChoicePoint _choicePoint;

    public GlobalTypingGoal(Global global) {
        this._global = global;
    }

    @Override
    final Locatable extent() {
        return this._global;
    }

    private final ChoicePoint _choicePoint() {
        if (this._choicePoint == null) {
            this._choicePoint = new ChoicePoint();
        }
        return this._choicePoint;
    }

    private final void _initialize(TypeChecker typeChecker) throws FailedUnificationException {
        Iterator iterator = this._global.viableTypes().iterator();
        if (!iterator.hasNext()) {
            Type.resetNames();
            typeChecker.error(new TypeClashException((Object)("no type allowed for '" + this._global + "' fits " + this._global.sieve().toQuantifiedString())), this._global);
        }
        this._setCurrentGoal((CodeEntry)iterator.next());
        if (iterator.hasNext()) {
            this._choicePoint().setTimeStamp(this);
            while (iterator.hasNext()) {
                this._choicePoint.push((CodeEntry)iterator.next());
            }
            typeChecker.pushChoicePoint(this._choicePoint);
        }
        this._initialized = true;
    }

    private final void _setCurrentGoal(CodeEntry codeEntry) {
        this._currentGoal = new TypingGoal(this._global, codeEntry.type().copy());
        this._currentGoal.setIsTrailable(false);
        this._currentGoal.setTimeStamp(this);
        this._global.setCodeEntry(codeEntry);
    }

    private final void _backtrack(TypeChecker typeChecker) {
        this._setCurrentGoal(this._choicePoint.pop());
        if (this._choicePoint.isEmpty()) {
            typeChecker.popChoicePoint();
        }
    }

    @Override
    final void prove(TypeChecker typeChecker) throws FailedUnificationException {
        this.trail(typeChecker);
        if (!this._initialized) {
            this._initialize(typeChecker);
        } else {
            this._backtrack(typeChecker);
        }
        if (typeChecker.isTracing()) {
            typeChecker.showGoal(this._currentGoal);
        }
        this._currentGoal.prove(typeChecker);
    }

    @Override
    final void undo(TypeChecker typeChecker) {
        this._initialized = false;
        typeChecker.pushGoal(this);
    }

    @Override
    public final String toString() {
        return this._initialized ? this._currentGoal.toString() : super.toString() + ": (global) symbol => " + this._global;
    }
}

