/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.types;

import hlt.language.design.kernel.TupleFieldName;
import hlt.language.design.types.FailedUnificationException;
import hlt.language.design.types.TupleType;
import hlt.language.design.types.Type;
import hlt.language.design.types.TypeChecker;
import hlt.language.design.types.TypeClashException;
import hlt.language.design.types.TypeParameter;
import hlt.language.design.types.TypingErrorException;
import hlt.language.tools.Misc;
import java.util.AbstractList;
import java.util.HashMap;

public class NamedTupleType
extends TupleType {
    private TupleFieldName[] _fields;
    private int[] _index;

    public NamedTupleType(Type[] typeArray, TupleFieldName[] tupleFieldNameArray) {
        this._components = typeArray;
        this._fields = tupleFieldNameArray;
    }

    public NamedTupleType(AbstractList abstractList, AbstractList abstractList2) {
        this._fields = new TupleFieldName[abstractList2.size()];
        int n = this._fields.length;
        while (n-- > 0) {
            this._fields[n] = new TupleFieldName((String)abstractList2.get(n), n);
        }
        Misc.sort(this._fields);
        this._components = new Type[abstractList.size()];
        n = this._components.length;
        while (n-- > 0) {
            this._components[n] = (Type)abstractList.get(this._fields[n].index());
            if (!this._components[n].value().isVoid()) continue;
            throw new TypingErrorException((Object)"void tuple component type");
        }
    }

    public final TupleFieldName[] fields() {
        return this._fields;
    }

    public final int[] index() {
        if (this._index == null) {
            this._index = new int[this.dimension()];
            int n = this._index.length;
            while (n-- > 0) {
                this._index[this._fields[n].index()] = n;
            }
        }
        return this._index;
    }

    public final String fieldSet() {
        StringBuilder stringBuilder = new StringBuilder("{");
        for (int i = 0; i < this.dimension(); ++i) {
            stringBuilder.append(this._fields[this.index()[i]]).append(i == this.dimension() - 1 ? "" : ", ");
        }
        return stringBuilder.append("}").toString();
    }

    public final int position(String string) {
        for (int i = 0; i < this._fields.length; ++i) {
            if (!this._fields[i].isEqualTo(string)) continue;
            return i + 1;
        }
        return 0;
    }

    public final TupleFieldName field(int n) {
        for (int i = 0; i < this._fields.length; ++i) {
            if (this._fields[i].index() != n) continue;
            return this._fields[i];
        }
        return null;
    }

    public final int fieldPosition(int n) {
        --n;
        for (int i = 0; i < this._fields.length; ++i) {
            if (this._fields[i].index() != n) continue;
            return i + 1;
        }
        return 0;
    }

    @Override
    public final byte kind() {
        return 6;
    }

    @Override
    public final void unify(Type type, TypeChecker typeChecker) throws FailedUnificationException {
        Type type2;
        if ((type = type.value()) == this) {
            return;
        }
        if (TypeChecker.ALLOWS_UNIFYING_OPAQUE_TUPLES && type.kind() == 12 && ((type2 = type.actualType()).kind() == 5 || type2.kind() == 6)) {
            type = type2;
        }
        switch (type.kind()) {
            case 2: {
                type.unify(this, typeChecker);
                return;
            }
            case 6: {
                type2 = (NamedTupleType)type;
                if (((TupleType)type2).dimension() != this.dimension()) {
                    typeChecker.error(new TypeClashException(this, type2));
                }
                int n = this.dimension();
                while (n-- > 0) {
                    if (!this._fields[n].equals(((NamedTupleType)type2).fields()[n])) {
                        typeChecker.error(new TypeClashException(this, type2));
                    }
                    this.component(n).unify(((TupleType)type2).components()[n], typeChecker);
                }
                return;
            }
            case 5: {
                if (!TypeChecker.ALLOWS_POSITIONAL_NAMED_TUPLES) break;
                type2 = (TupleType)type;
                if (((TupleType)type2).dimension() != this.dimension()) {
                    typeChecker.error(new TypeClashException(this, type2));
                }
                int n = this.dimension();
                while (n-- > 0) {
                    this.component(this._fields[n].index()).unify(((TupleType)type2).components()[n], typeChecker);
                }
                return;
            }
        }
        typeChecker.error(new TypeClashException(this, type));
    }

    @Override
    public boolean unify(Type type) {
        Type type2;
        if ((type = type.findValue()) == this) {
            return true;
        }
        if (TypeChecker.ALLOWS_UNIFYING_OPAQUE_TUPLES && type.kind() == 12 && ((type2 = type.actualType()).kind() == 5 || type2.kind() == 6)) {
            type = type2;
        }
        switch (type.kind()) {
            case 2: {
                ((TypeParameter)type).bind(this);
                return true;
            }
            case 6: {
                boolean bl;
                type2 = (NamedTupleType)type;
                int n = this.dimension();
                boolean bl2 = bl = n == ((TupleType)type2).dimension();
                while (bl && n-- > 0) {
                    bl &= this._fields[n].equals(((NamedTupleType)type2).fields()[n]) && this._components[n].findValue().unify(((TupleType)type2).components()[n]);
                }
                return bl;
            }
        }
        return false;
    }

    @Override
    public final Type copy(HashMap hashMap) {
        if (this.dimension() == 0) {
            return this;
        }
        Type[] typeArray = new Type[this.dimension()];
        int n = this.dimension();
        while (n-- > 0) {
            typeArray[n] = this.component(n).copy(hashMap);
        }
        return new NamedTupleType(typeArray, this._fields);
    }

    @Override
    public final boolean isEqualTo(Type type) {
        if (this == type) {
            return true;
        }
        if (!(type instanceof NamedTupleType)) {
            return false;
        }
        NamedTupleType namedTupleType = (NamedTupleType)type;
        if (this.dimension() != namedTupleType.dimension()) {
            return false;
        }
        int n = this.dimension();
        while (n-- > 0) {
            if (this._fields[n].equals(namedTupleType.fields()[n]) && this.component(n).isEqualTo(namedTupleType.component(n))) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean isEqualTo(Type type, HashMap hashMap) {
        if (this == type) {
            return true;
        }
        if (!(type instanceof NamedTupleType)) {
            return false;
        }
        NamedTupleType namedTupleType = (NamedTupleType)type;
        if (this.dimension() != namedTupleType.dimension()) {
            return false;
        }
        int n = this.dimension();
        while (n-- > 0) {
            if (this._fields[n].equals(namedTupleType.fields()[n]) && this.component(n).isEqualTo(namedTupleType.component(n), hashMap)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder("<");
        for (int i = 0; i < this.dimension(); ++i) {
            stringBuilder.append(this._fields[this.index()[i]]).append(":").append(this.component(this.index()[i])).append(i == this.dimension() - 1 ? "" : ",");
        }
        return stringBuilder.append(">").toString();
    }
}

