/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.types;

import hlt.language.design.types.FailedUnificationException;
import hlt.language.design.types.Goal;
import hlt.language.design.types.GoalProver;
import hlt.language.design.types.Type;
import hlt.language.design.types.TypeChecker;
import hlt.language.design.types.TypeParameter;
import hlt.language.util.Locatable;
import java.util.Iterator;

public class ResiduatedGoal
extends Goal {
    private Goal _goal;
    private int _refCount = 0;

    public ResiduatedGoal(Goal goal) {
        this.setGoal(goal);
    }

    final Goal goal() {
        return this._goal;
    }

    @Override
    final Locatable extent() {
        return this._goal.extent();
    }

    public final int refCount() {
        return this._refCount;
    }

    public final ResiduatedGoal setGoal(Goal goal) {
        this._goal = goal;
        this._goal.setTimeStamp(this);
        this._goal.setIsTrailable(false);
        return this;
    }

    public final void setRefCount(int n) {
        this._refCount = n;
    }

    public final void addTrigger(Type type) {
        int n = this._refCount;
        Iterator iterator = type.value().getParameters().iterator();
        while (iterator.hasNext()) {
            if (!((TypeParameter)iterator.next()).addResiduation(this, n)) continue;
            ++this._refCount;
        }
    }

    public final void release(Type type, GoalProver goalProver) throws FailedUnificationException {
        --this._refCount;
        this.addTrigger(type);
        this.trigger(goalProver);
    }

    @Override
    final void prove(TypeChecker typeChecker) throws FailedUnificationException {
        this.trail(typeChecker);
        this.trigger(typeChecker);
    }

    public final void trigger(GoalProver goalProver) throws FailedUnificationException {
        if (this._refCount == 0) {
            this._goal.prove((TypeChecker)goalProver);
        }
    }

    @Override
    public String toString() {
        return this._refCount == 0 ? this._goal.toString() : super.toString() + ": (residuation) refs => " + this._refCount + ", goal => " + this._goal;
    }
}

