/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.types;

import hlt.language.design.instructions.Instruction;
import hlt.language.design.kernel.DefinitionException;
import hlt.language.design.types.BuiltinEntry;
import hlt.language.design.types.CodeEntry;
import hlt.language.design.types.DefinedEntry;
import hlt.language.design.types.DuplicateCodeEntryException;
import hlt.language.design.types.FunctionType;
import hlt.language.design.types.SetType;
import hlt.language.design.types.Type;
import hlt.language.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class Symbol {
    private String _name;
    private int _index;
    private boolean _noCurrying = false;
    private ArrayList _typeTable = new ArrayList();
    public static final Symbol INDEX_SET = new Symbol("INDEX_SET");
    public static final Symbol INDEXABLE;
    public static final Symbol COLLECTION;

    public Symbol(String string) {
        this._name = string.intern();
    }

    public Symbol(String string, int n) {
        this._name = string.intern();
        this._index = n;
    }

    public final String name() {
        return this._name;
    }

    public final int index() {
        return this._index;
    }

    public final ArrayList typeTable() {
        return this._typeTable;
    }

    public final Symbol setNoCurrying(boolean bl) {
        this._noCurrying = bl;
        return this;
    }

    public final DefinedEntry registerCodeEntry(Type type) throws DefinitionException {
        CodeEntry codeEntry = this.getCodeEntry(type);
        if (codeEntry.isBuiltIn() || codeEntry.isDefinedField()) {
            throw new DefinitionException((Object)("cannot redefine " + codeEntry));
        }
        return (DefinedEntry)codeEntry;
    }

    public final CodeEntry getCodeEntry(Type type) {
        return this.getCodeEntry(type, false);
    }

    public final CodeEntry getCodeEntry(Type type, boolean bl) throws DuplicateCodeEntryException {
        DefinedEntry definedEntry = null;
        int n = this._codeEntryIndex(type);
        if (n == -1) {
            definedEntry = new DefinedEntry(this, type);
            this._typeTable.add(definedEntry);
            return definedEntry;
        }
        if (bl) {
            Type.resetNames();
            throw new DuplicateCodeEntryException((Object)("Attempt to duplicate code entry for " + this + " : " + type));
        }
        return (CodeEntry)this._typeTable.get(n);
    }

    private final int _codeEntryIndex(Type type) {
        int n = this._typeTable.size();
        while (n-- > 0) {
            if (!type.isEqualTo(((CodeEntry)this._typeTable.get(n)).type(), new HashMap())) continue;
            return n;
        }
        return -1;
    }

    public final void removeLatestEntry() {
        this._typeTable.remove(this._typeTable.size() - 1);
    }

    public final void defineBuiltIn(Type type, Instruction instruction) throws DuplicateCodeEntryException {
        if (type.kind() == 3 && this._noCurrying) {
            ((FunctionType)type).setNoCurrying();
        }
        this._typeTable.add(new BuiltinEntry(this, type.standardize(), instruction));
    }

    public final boolean isDefined() {
        return !this._typeTable.isEmpty();
    }

    public final boolean isDefined(Type type) {
        if (!this.isDefined()) {
            return false;
        }
        type = type.standardize();
        int n = this._typeTable.size();
        while (n-- > 0) {
            if (!type.equals(((CodeEntry)this._typeTable.get(n)).type())) continue;
            return true;
        }
        return false;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Symbol)) {
            return false;
        }
        return this._name == ((Symbol)object).name();
    }

    public final void showDefinedEntries() {
        boolean bl = false;
        for (CodeEntry codeEntry : this._typeTable) {
            if (codeEntry.isBuiltIn()) continue;
            Type.resetNames();
            System.out.println("\t" + codeEntry);
            bl = true;
        }
        if (bl) {
            System.out.println();
        }
    }

    public final void showCodeEntries() {
        Iterator iterator = this._typeTable.iterator();
        while (iterator.hasNext()) {
            Type.resetNames();
            System.out.println("\t" + iterator.next());
        }
        System.out.println();
    }

    public final String toString() {
        return this._name;
    }

    static {
        INDEX_SET.getCodeEntry(Type.INT());
        INDEX_SET.getCodeEntry(Type.INT_RANGE);
        INDEX_SET.getCodeEntry(new SetType());
        INDEXABLE = new Symbol("INDEXABLE");
        INDEXABLE.getCodeEntry(Type.INT_RANGE);
        INDEXABLE.getCodeEntry(new SetType());
        COLLECTION = new Symbol("COLLECTION");
        COLLECTION.getCodeEntry(Type.INT_RANGE);
        COLLECTION.getCodeEntry(new SetType());
    }
}

