/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.types;

import hlt.language.design.instructions.Instruction;
import hlt.language.design.kernel.Constant;
import hlt.language.design.kernel.Global;
import hlt.language.design.kernel.UndefinedEqualityException;
import hlt.language.design.types.ClassDeclarationException;
import hlt.language.design.types.ClassType;
import hlt.language.design.types.CodeEntry;
import hlt.language.design.types.DefinedType;
import hlt.language.design.types.DuplicateCodeEntryException;
import hlt.language.design.types.FunctionType;
import hlt.language.design.types.StaticSemanticsErrorException;
import hlt.language.design.types.Symbol;
import hlt.language.design.types.Type;
import hlt.language.design.types.TypeDefinition;
import hlt.language.design.types.TypeDefinitionException;
import hlt.language.design.types.TypeParameter;
import hlt.language.util.ArrayList;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;

public class Tables {
    private static final HashSet _EQUALITY_SYMBOLS = new HashSet();
    private static String _EQUALITY_SYMBOL;
    private String _inSymbol = "in";
    private final HashMap _symbolTable = new HashMap();
    private final HashMap _typeTable = new HashMap();
    private ArrayList _builtinSymbols = new ArrayList();
    private ArrayList _builtinTypeDefinitions = new ArrayList();

    public final boolean isEquality(String string) throws UndefinedEqualityException {
        if (_EQUALITY_SYMBOL == null) {
            throw new UndefinedEqualityException();
        }
        return (string = string.intern()) == _EQUALITY_SYMBOL || _EQUALITY_SYMBOLS.contains(string);
    }

    public final Symbol defineEqualitySymbol(String string) {
        string = string.intern();
        if (_EQUALITY_SYMBOL == null) {
            _EQUALITY_SYMBOL = string;
            return this.symbol(_EQUALITY_SYMBOL);
        }
        _EQUALITY_SYMBOLS.add(string);
        return this.symbol(string);
    }

    public final Symbol equalitySymbol() throws UndefinedEqualityException {
        if (_EQUALITY_SYMBOL == null) {
            throw new UndefinedEqualityException();
        }
        return this.symbol(_EQUALITY_SYMBOL);
    }

    public final Global equality() throws UndefinedEqualityException {
        return new Global(this.equalitySymbol());
    }

    public final Global in() {
        return new Global(this, this._inSymbol);
    }

    public final void setInSymbol(String string) {
        this._inSymbol = string;
    }

    public final void clear() {
        this._symbolTable.clear();
        this._typeTable.clear();
    }

    public final void reset() {
        this.clear();
        this._redefineBuiltins();
        Constant.initialize(this);
    }

    public final Symbol symbol(String string) {
        Symbol symbol = (Symbol)this._symbolTable.get(string);
        if (symbol == null) {
            symbol = new Symbol(string, this._symbolTable.size());
            this._symbolTable.put(string, symbol);
        }
        return symbol;
    }

    public final Symbol symbol(String string, boolean bl) {
        return this.symbol(string).setNoCurrying(bl);
    }

    public final boolean isDefined(String string) {
        return this._symbolTable.get(string) != null;
    }

    public final boolean isDefinedScalar(String string) {
        Symbol symbol = (Symbol)this._symbolTable.get(string);
        if (symbol == null) {
            return false;
        }
        int n = symbol.typeTable().size();
        while (n-- > 0) {
            if (((CodeEntry)symbol.typeTable().get(n)).type().kind() == 3) continue;
            return true;
        }
        return false;
    }

    public final void showSymbols() {
        System.out.println("Showing declared symbols:\n");
        Iterator iterator = this._symbolTable.values().iterator();
        while (iterator.hasNext()) {
            ((Symbol)iterator.next()).showCodeEntries();
        }
    }

    public final void showSortedSymbols() {
        System.out.println("Showing known symbols in lexicographic order:\n");
        Iterator iterator = new TreeMap(this._symbolTable).values().iterator();
        while (iterator.hasNext()) {
            ((Symbol)iterator.next()).showCodeEntries();
        }
    }

    public final void showOrderedSymbols() {
        Symbol[] symbolArray = new Symbol[this._symbolTable.size()];
        Iterator iterator = this._symbolTable.values().iterator();
        while (iterator.hasNext()) {
            Symbol symbol;
            symbolArray[symbol.index()] = symbol = (Symbol)iterator.next();
        }
        System.out.println("Showing known symbols in the order they have been defined:\n");
        for (int i = 0; i < symbolArray.length; ++i) {
            symbolArray[i].showCodeEntries();
        }
    }

    public final void showDefined() {
        System.out.println("Showing known symbols:\n");
        Iterator iterator = this._symbolTable.values().iterator();
        while (iterator.hasNext()) {
            ((Symbol)iterator.next()).showDefinedEntries();
        }
    }

    public final ClassType declareClass(String string, AbstractList abstractList, AbstractList abstractList2, AbstractList abstractList3, AbstractList abstractList4) throws ClassDeclarationException {
        Type type = this.getType(string, abstractList4);
        if (type.kind() != 10) {
            throw new ClassDeclarationException((Object)("a type is already defined with name " + string));
        }
        ClassType classType = (ClassType)type;
        if (classType.isDeclared()) {
            throw new ClassDeclarationException((Object)("duplicate class type declaration: " + string));
        }
        if (classType.arguments() != null && abstractList4 != null && abstractList4.size() != classType.arity()) {
            throw new ClassDeclarationException((Object)("wrong number of arguments for class " + string + "; expected: " + classType.arity() + ", found: " + abstractList4.size()));
        }
        return classType.declareMembers(abstractList, abstractList2, abstractList3, abstractList4);
    }

    public final TypeDefinition defineTypeAlias(String string, Type type) throws TypeDefinitionException {
        return this.defineTypeAlias(string, type, null);
    }

    public final TypeDefinition defineTypeAlias(String string, Type type, AbstractList abstractList) throws TypeDefinitionException {
        if (this._typeTable.get(string) != null) {
            throw new TypeDefinitionException((Object)("a type is already defined with name " + string));
        }
        TypeDefinition typeDefinition = new TypeDefinition(string, type, abstractList);
        this._typeTable.put(string, typeDefinition);
        return typeDefinition;
    }

    public final TypeDefinition defineBuiltinTypeAlias(String string, Type type) throws TypeDefinitionException {
        return this.defineBuiltinTypeAlias(string, type, null);
    }

    public final TypeDefinition defineBuiltinTypeAlias(String string, Type type, AbstractList abstractList) throws TypeDefinitionException {
        TypeDefinition typeDefinition = this.defineTypeAlias(string, type, abstractList);
        this._builtinTypeDefinitions.add(new BuiltinTypeDefinition(string, type, abstractList, false));
        return typeDefinition;
    }

    public final TypeDefinition defineNewType(String string, Type type) throws TypeDefinitionException {
        return this.defineNewType(string, type, null);
    }

    public final TypeDefinition defineNewType(String string, Type type, AbstractList abstractList) throws TypeDefinitionException {
        if (this._typeTable.get(string) != null) {
            throw new TypeDefinitionException((Object)("a type is already defined with name " + string));
        }
        TypeDefinition typeDefinition = new TypeDefinition(string, (Type)new DefinedType(string, type, abstractList), abstractList);
        this._typeTable.put(string, typeDefinition);
        return typeDefinition;
    }

    public final TypeDefinition defineBuiltinNewType(String string, Type type) throws TypeDefinitionException {
        return this.defineBuiltinNewType(string, type, null);
    }

    public final TypeDefinition defineBuiltinNewType(String string, Type type, AbstractList abstractList) throws TypeDefinitionException {
        TypeDefinition typeDefinition = this.defineNewType(string, type, abstractList);
        this._builtinTypeDefinitions.add(new BuiltinTypeDefinition(string, type, abstractList, true));
        return typeDefinition;
    }

    public final Type getDefinedType(String string) {
        TypeDefinition typeDefinition = (TypeDefinition)this._typeTable.get(string);
        return typeDefinition == null ? null : typeDefinition.definition();
    }

    public final Type getType(String string) {
        TypeDefinition typeDefinition = (TypeDefinition)this._typeTable.get(string);
        if (typeDefinition == null) {
            typeDefinition = new TypeDefinition(string, new ClassType(this, string));
            this._typeTable.put(string, typeDefinition);
        }
        return typeDefinition.definition();
    }

    public final Type getType(String string, AbstractList abstractList) throws StaticSemanticsErrorException {
        TypeDefinition typeDefinition = (TypeDefinition)this._typeTable.get(string);
        if (typeDefinition == null) {
            Type[] typeArray = null;
            if (abstractList != null) {
                typeArray = new TypeParameter[abstractList.size()];
                for (int i = 0; i < typeArray.length; ++i) {
                    typeArray[i] = new TypeParameter();
                }
            }
            typeDefinition = new TypeDefinition(string, (Type)new ClassType(this, string).setArguments(typeArray), (TypeParameter[])typeArray);
            this._typeTable.put(string, typeDefinition);
        }
        return typeDefinition.instantiate(abstractList);
    }

    public final void showTypes() {
        System.out.println("Showing registered types:\n");
        Iterator iterator = this._typeTable.values().iterator();
        while (iterator.hasNext()) {
            System.out.println(iterator.next());
        }
    }

    public final void defineBuiltIn(Symbol symbol, Type type, Instruction instruction) throws DuplicateCodeEntryException {
        symbol.defineBuiltIn(type, instruction);
        this._builtinSymbols.add(new BuiltinDefinition(symbol.name(), type, instruction));
    }

    public final void defineBuiltIn(String string, Type type, Instruction instruction) throws DuplicateCodeEntryException {
        this.defineBuiltIn(this.symbol(string), type, instruction);
    }

    public final void defineBuiltIn(Symbol symbol, Type type, Type type2, Instruction instruction) throws DuplicateCodeEntryException {
        this.defineBuiltIn(symbol, (Type)new FunctionType(type, type2), instruction);
    }

    public final void defineBuiltIn(String string, Type type, Type type2, Instruction instruction) throws DuplicateCodeEntryException {
        this.defineBuiltIn(this.symbol(string), type, type2, instruction);
    }

    public final void defineBuiltIn(Symbol symbol, Type type, Type type2, Type type3, Instruction instruction) throws DuplicateCodeEntryException {
        Type[] typeArray = new Type[]{type, type2};
        this.defineBuiltIn(symbol, (Type)new FunctionType(typeArray, type3), instruction);
    }

    public final void defineBuiltIn(String string, Type type, Type type2, Type type3, Instruction instruction) throws DuplicateCodeEntryException {
        this.defineBuiltIn(this.symbol(string), type, type2, type3, instruction);
    }

    public final void defineBuiltIn(Symbol symbol, Type type, Type type2, Type type3, Type type4, Instruction instruction) throws DuplicateCodeEntryException {
        Type[] typeArray = new Type[]{type, type2, type3};
        this.defineBuiltIn(symbol, (Type)new FunctionType(typeArray, type4), instruction);
    }

    public final void defineBuiltIn(String string, Type type, Type type2, Type type3, Type type4, Instruction instruction) throws DuplicateCodeEntryException {
        this.defineBuiltIn(this.symbol(string), type, type2, type3, type4, instruction);
    }

    public final void defineBuiltIn(Symbol symbol, Type[] typeArray, Type type, Instruction instruction) throws DuplicateCodeEntryException {
        this.defineBuiltIn(symbol, (Type)new FunctionType(typeArray, type), instruction);
    }

    public final void defineBuiltIn(String string, Type[] typeArray, Type type, Instruction instruction) throws DuplicateCodeEntryException {
        this.defineBuiltIn(this.symbol(string), typeArray, type, instruction);
    }

    private final void _redefineBuiltins() throws DuplicateCodeEntryException, TypeDefinitionException {
        for (Object object : this._builtinSymbols) {
            this.symbol(((BuiltinDefinition)object).name).defineBuiltIn(((BuiltinDefinition)object).type, ((BuiltinDefinition)object).instruction);
        }
        for (Object object : this._builtinTypeDefinitions) {
            if (((BuiltinTypeDefinition)object).isNew) {
                this.defineNewType(((BuiltinTypeDefinition)object).name, ((BuiltinTypeDefinition)object).definition, ((BuiltinTypeDefinition)object).parameters);
                continue;
            }
            this.defineTypeAlias(((BuiltinTypeDefinition)object).name, ((BuiltinTypeDefinition)object).definition, ((BuiltinTypeDefinition)object).parameters);
        }
    }

    private static class BuiltinTypeDefinition {
        String name;
        Type definition;
        AbstractList parameters;
        boolean isNew;

        BuiltinTypeDefinition(String string, Type type, AbstractList abstractList, boolean bl) {
            this.name = string;
            this.definition = type;
            this.parameters = abstractList;
            this.isNew = bl;
        }
    }

    private static class BuiltinDefinition {
        String name;
        Type type;
        Instruction instruction;

        BuiltinDefinition(String string, Type type, Instruction instruction) {
            this.name = string;
            this.type = type;
            this.instruction = instruction;
        }
    }
}

