/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.types;

import hlt.language.design.types.ConstructedType;
import hlt.language.design.types.FailedUnificationException;
import hlt.language.design.types.NamedTupleType;
import hlt.language.design.types.NoSuchTypeComponentException;
import hlt.language.design.types.Type;
import hlt.language.design.types.TypeChecker;
import hlt.language.design.types.TypeClashException;
import hlt.language.design.types.TypeParameter;
import hlt.language.design.types.TypingErrorException;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.HashSet;

public class TupleType
extends ConstructedType {
    protected Type[] _components;
    public static final TupleType EMPTY = new TupleType();

    @Override
    public final int numberOfTypeComponents() {
        return this.dimension();
    }

    @Override
    public final Type typeRefComponent(int n) throws NoSuchTypeComponentException {
        if (n >= 0 && n < this.dimension()) {
            return this._components[n];
        }
        throw new NoSuchTypeComponentException(this, n);
    }

    @Override
    public final void setTypeRefComponent(int n, Type type) throws NoSuchTypeComponentException {
        if (n < 0 || n >= this.dimension()) {
            throw new NoSuchTypeComponentException(this, n);
        }
        this._components[n] = type;
    }

    protected TupleType() {
    }

    private TupleType(Type[] typeArray) {
        this._components = typeArray;
    }

    public static final TupleType newTupleType(Type[] typeArray) {
        if (typeArray == null || typeArray.length == 0) {
            return EMPTY;
        }
        for (int i = 0; i < typeArray.length; ++i) {
            if (!typeArray[i].value().isVoid()) continue;
            throw new TypingErrorException((Object)"void tuple component type");
        }
        return new TupleType(typeArray);
    }

    public static final TupleType newTupleType(AbstractList abstractList) {
        if (abstractList == null || abstractList.size() == 0) {
            return EMPTY;
        }
        Type[] typeArray = new Type[abstractList.size()];
        for (int i = 0; i < typeArray.length; ++i) {
            typeArray[i] = (Type)abstractList.get(i);
            if (!typeArray[i].value().isVoid()) continue;
            throw new TypingErrorException((Object)"void tuple component type");
        }
        return new TupleType(typeArray);
    }

    @Override
    public byte kind() {
        return 5;
    }

    public final Type component(int n) {
        return this._components[n].value();
    }

    public final Type[] components() {
        return this._components;
    }

    public final int dimension() {
        return this._components == null ? 0 : this._components.length;
    }

    @Override
    public void unify(Type type, TypeChecker typeChecker) throws FailedUnificationException {
        Type type2;
        if ((type = type.value()) == this) {
            return;
        }
        if (TypeChecker.ALLOWS_UNIFYING_OPAQUE_TUPLES && type.kind() == 12 && ((type2 = type.actualType()).kind() == 5 || type2.kind() == 6)) {
            type = type2;
        }
        switch (type.kind()) {
            case 2: {
                type.unify(this, typeChecker);
                return;
            }
            case 5: {
                type2 = (TupleType)type;
                if (((TupleType)type2).dimension() != this.dimension()) {
                    typeChecker.error(new TypeClashException(this, type2));
                }
                int n = this.dimension();
                while (n-- > 0) {
                    this.component(n).unify(((TupleType)type2).components()[n], typeChecker);
                    if (!this.component(n).isVoid()) continue;
                    typeChecker.error(new TypingErrorException((Object)"void tuple component type"));
                }
                return;
            }
            case 6: {
                if (!TypeChecker.ALLOWS_POSITIONAL_NAMED_TUPLES) break;
                type2 = (NamedTupleType)type;
                if (((TupleType)type2).dimension() != this.dimension()) {
                    typeChecker.error(new TypeClashException(this, type2));
                }
                int n = this.dimension();
                while (n-- > 0) {
                    this.component(n).unify(((TupleType)type2).components()[((NamedTupleType)type2).fields()[n].index()], typeChecker);
                    if (!this.component(n).isVoid()) continue;
                    typeChecker.error(new TypingErrorException((Object)"void tuple component type"));
                }
                return;
            }
        }
        typeChecker.error(new TypeClashException(this, type));
    }

    @Override
    public boolean unify(Type type) {
        Type type2;
        if ((type = type.findValue()) == this) {
            return true;
        }
        if (TypeChecker.ALLOWS_UNIFYING_OPAQUE_TUPLES && type.kind() == 12 && ((type2 = type.actualType()).kind() == 5 || type2.kind() == 6)) {
            type = type2;
        }
        switch (type.kind()) {
            case 2: {
                ((TypeParameter)type).bind(this);
                return true;
            }
            case 5: {
                boolean bl;
                type2 = (TupleType)type;
                int n = this.dimension();
                boolean bl2 = bl = n == ((TupleType)type2).dimension();
                while (bl && n-- > 0) {
                    bl &= this._components[n].findValue().unify(((TupleType)type2).components()[n]);
                }
                return bl;
            }
        }
        return false;
    }

    @Override
    public final void checkOccurrence(TypeParameter typeParameter, Type type, TypeChecker typeChecker) throws FailedUnificationException {
        int n = this.dimension();
        while (n-- > 0) {
            this.component(n).checkOccurrence(typeParameter, type, typeChecker);
        }
    }

    @Override
    public final HashSet getParameters(HashSet hashSet) {
        int n = this.dimension();
        while (n-- > 0) {
            this.component(n).getParameters(hashSet);
        }
        return hashSet;
    }

    @Override
    public final Type flatten() {
        int n = this.dimension();
        while (n-- > 0) {
            this._components[n] = this.component(n).flatten();
        }
        return this;
    }

    @Override
    public Type copy(HashMap hashMap) {
        if (this.dimension() == 0) {
            return this;
        }
        Type[] typeArray = new Type[this.dimension()];
        int n = this.dimension();
        while (n-- > 0) {
            typeArray[n] = this.component(n).copy(hashMap);
        }
        return new TupleType(typeArray);
    }

    @Override
    public Type instantiate(HashMap hashMap) {
        if (this.dimension() == 0) {
            return this;
        }
        Type[] typeArray = new Type[this.dimension()];
        int n = this.dimension();
        while (n-- > 0) {
            typeArray[n] = this.component(n).instantiate(hashMap);
        }
        return new TupleType(typeArray);
    }

    @Override
    public final int eqCode() {
        int n = this.kind() + this.dimension();
        int n2 = this.dimension();
        while (n2-- > 0) {
            n += (n2 + 1) * this.component(n2).eqCode();
        }
        return n;
    }

    @Override
    public boolean isEqualTo(Type type) {
        if (this == type) {
            return true;
        }
        if (!(type instanceof TupleType)) {
            return false;
        }
        TupleType tupleType = (TupleType)type;
        if (this.dimension() != tupleType.dimension()) {
            return false;
        }
        int n = this.dimension();
        while (n-- > 0) {
            if (this.component(n).isEqualTo(tupleType.component(n))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEqualTo(Type type, HashMap hashMap) {
        if (this == type) {
            return true;
        }
        if (!(type instanceof TupleType)) {
            return false;
        }
        TupleType tupleType = (TupleType)type;
        if (this.dimension() != tupleType.dimension()) {
            return false;
        }
        int n = this.dimension();
        while (n-- > 0) {
            if (this.component(n).isEqualTo(tupleType.component(n), hashMap)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("<");
        for (int i = 0; i < this.dimension(); ++i) {
            stringBuilder.append(this.component(i) + (i == this.dimension() - 1 ? "" : ","));
        }
        return stringBuilder.append(">").toString();
    }
}

