/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.types;

import hlt.language.design.kernel.Constant;
import hlt.language.design.kernel.Expression;
import hlt.language.design.types.ArrayType;
import hlt.language.design.types.BoxableTypeConstant;
import hlt.language.design.types.ClassType;
import hlt.language.design.types.Collection;
import hlt.language.design.types.CollectionTypeConstant;
import hlt.language.design.types.DefinedEntry;
import hlt.language.design.types.DefinedType;
import hlt.language.design.types.FailedUnificationException;
import hlt.language.design.types.NoSuchTypeComponentException;
import hlt.language.design.types.SetType;
import hlt.language.design.types.TupleType;
import hlt.language.design.types.TypeChecker;
import hlt.language.design.types.TypeConstant;
import hlt.language.design.types.TypeParameter;
import hlt.language.design.types.Valuable;
import hlt.language.tools.Misc;
import hlt.language.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public abstract class Type
implements Valuable {
    public static final byte CONSTANT = 0;
    public static final byte BOXABLE = 1;
    public static final byte PARAMETER = 2;
    public static final byte FUNCTION = 3;
    public static final byte ARRAY = 4;
    public static final byte TUPLE = 5;
    public static final byte NAMED_TUPLE = 6;
    public static final byte SET = 7;
    public static final byte BAG = 8;
    public static final byte LIST = 9;
    public static final byte CLASS = 10;
    public static final byte COLLECTION = 11;
    public static final byte DEFINED = 12;
    public static final byte VOID_SORT = 0;
    public static final byte INT_SORT = 1;
    public static final byte REAL_SORT = 2;
    public static final byte OBJECT_SORT = 3;
    public static final TypeConstant VOID = new TypeConstant("void", 0, false);
    public static final TypeConstant INT = new TypeConstant("int", 1, false);
    public static final TypeConstant REAL = new TypeConstant("real", 2, false);
    public static final TypeConstant CHAR = new TypeConstant("char", 1, false);
    public static final TypeConstant BOOLEAN = new TypeConstant("boolean", 1, false);
    public static final TypeConstant STRING = new TypeConstant("string");
    public static final TypeConstant INT_RANGE = new CollectionTypeConstant("int..int", Type.INT());
    public static final TypeConstant REAL_RANGE = new TypeConstant("real..real");
    private static ArrayList _dejaVu = new ArrayList();
    private static final HashMap _names = new HashMap();
    private static int _varCount = 0;

    public abstract int numberOfTypeComponents();

    public abstract Type typeRefComponent(int var1) throws NoSuchTypeComponentException;

    public abstract void setTypeRefComponent(int var1, Type var2) throws NoSuchTypeComponentException;

    public final Type typeComponent(int n) throws NoSuchTypeComponentException {
        return this.typeRefComponent(n).value();
    }

    public static final BoxableTypeConstant BOOLEAN() {
        return new BoxableTypeConstant(BOOLEAN, false);
    }

    public static final BoxableTypeConstant INT() {
        return new BoxableTypeConstant(INT, false);
    }

    public static final BoxableTypeConstant REAL() {
        return new BoxableTypeConstant(REAL, false);
    }

    public static final BoxableTypeConstant CHAR() {
        return new BoxableTypeConstant(CHAR, false);
    }

    public static final BoxableTypeConstant BOXED_BOOLEAN() {
        return new BoxableTypeConstant(BOOLEAN, true);
    }

    public static final BoxableTypeConstant BOXED_INT() {
        return new BoxableTypeConstant(INT, true);
    }

    public static final BoxableTypeConstant BOXED_REAL() {
        return new BoxableTypeConstant(REAL, true);
    }

    public static final BoxableTypeConstant BOXED_CHAR() {
        return new BoxableTypeConstant(CHAR, true);
    }

    public final boolean isCollection() {
        return this instanceof Collection;
    }

    public final boolean isPrimitive() {
        return this == VOID || this == BOOLEAN || this == INT || this == REAL || this == CHAR || this.kind() == 12 && ((DefinedType)this).definition().isPrimitive();
    }

    public final boolean is(Type type) {
        return this == type || this.kind() == 12 && ((DefinedType)this).definition().is(type) || this.kind() == 1 && ((BoxableTypeConstant)this).type() == type;
    }

    public final boolean isVoid() {
        return this == VOID;
    }

    public final boolean isBoolean() {
        return this.is(BOOLEAN);
    }

    public final boolean isInt() {
        return this.is(INT);
    }

    public final boolean isReal() {
        return this.is(REAL);
    }

    public final boolean isChar() {
        return this.is(CHAR);
    }

    public final boolean isString() {
        return this == STRING;
    }

    public final boolean isSet() {
        return this.kind() == 7;
    }

    public final boolean isBag() {
        return this.kind() == 8;
    }

    public final boolean isList() {
        return this.kind() == 9;
    }

    public Type baseTypeRef() {
        return this;
    }

    public Type baseType() {
        return this.value();
    }

    public Type actualType() {
        return this;
    }

    public Type shadowType() {
        return this.value();
    }

    public final int rank() {
        if (this.isCollection()) {
            return 1 + this.baseType().rank();
        }
        return 0;
    }

    public final ArrayType array(Expression[] expressionArray) {
        return this._array(expressionArray, 0);
    }

    private final ArrayType _array(Expression[] expressionArray, int n) {
        return new ArrayType(n >= expressionArray.length - 1 ? this : this._array(expressionArray, n + 1), expressionArray[n].type());
    }

    public final ArrayType array(int n) {
        return this._array(n, 0);
    }

    private final ArrayType _array(int n, int n2) {
        return new ArrayType(n2 >= n - 1 ? this : this._array(n, n2 + 1), new TypeParameter());
    }

    public final boolean isGlobalUnsafe() {
        switch (this.kind()) {
            case 12: {
                return ((DefinedType)this).definition().isGlobalUnsafe();
            }
            case 3: {
                return false;
            }
            case 4: {
                Type type = ((ArrayType)this).baseType();
                return type.isPolymorphic() || type.isGlobalUnsafe();
            }
            case 7: {
                Type type = ((SetType)this).baseType();
                return type.isPolymorphic() || type.isGlobalUnsafe();
            }
            case 5: 
            case 6: {
                TupleType tupleType = (TupleType)this;
                for (int i = 0; i < tupleType.dimension(); ++i) {
                    Type type = tupleType.component(i);
                    if (!type.isPolymorphic() && !type.isGlobalUnsafe()) continue;
                    return true;
                }
                return false;
            }
            case 10: {
                ClassType classType = (ClassType)this;
                if (!classType.isDeclared()) {
                    return true;
                }
                if (Type._isDejaVu(this)) {
                    return false;
                }
                DefinedEntry[] definedEntryArray = classType.fields();
                boolean bl = false;
                classType.bindArguments();
                for (int i = 0; i < definedEntryArray.length; ++i) {
                    Type type = definedEntryArray[i].fieldType();
                    if (!type.isPolymorphic() && !type.isGlobalUnsafe()) continue;
                    bl = true;
                    break;
                }
                classType.unbindArguments();
                return bl;
            }
        }
        return this.isPolymorphic();
    }

    private static final boolean _isDejaVu(Type type) {
        int n = _dejaVu.size();
        while (n-- > 0) {
            if (!type.isEqualTo((Type)_dejaVu.get(n))) continue;
            return true;
        }
        _dejaVu.add(type);
        return false;
    }

    public boolean isPolymorphic() {
        return false;
    }

    public Type value() {
        return this;
    }

    public Type findValue() {
        return this;
    }

    @Override
    public final Valuable getValue() {
        return this.value();
    }

    public byte sort() {
        return 3;
    }

    public final byte boxSort() {
        return this.isBoxedType() ? (byte)3 : (byte)this.sort();
    }

    public final Expression wrapper() {
        if (this.sort() == 1) {
            return Constant.WRAP_INT;
        }
        return Constant.WRAP_REAL;
    }

    public final Expression unwrapper() {
        if (this.sort() == 1) {
            return Constant.UNWRAP_INT;
        }
        return Constant.UNWRAP_REAL;
    }

    public boolean isBoxedType() {
        return true;
    }

    public Type setBoxed(boolean bl) {
        return this;
    }

    public abstract byte kind();

    public final String kindString() {
        switch (this.kind()) {
            case 0: {
                return "CONSTANT";
            }
            case 1: {
                return "BOXABLE";
            }
            case 2: {
                return "PARAMETER";
            }
            case 3: {
                return "FUNCTION";
            }
            case 4: {
                return "ARRAY";
            }
            case 5: {
                return "TUPLE";
            }
            case 6: {
                return "NAMED_TUPLE";
            }
            case 7: {
                return "SET";
            }
            case 8: {
                return "BAG";
            }
            case 9: {
                return "LIST";
            }
            case 10: {
                return "CLASS";
            }
            case 12: {
                return "DEFINED";
            }
        }
        return "ILLEGAL";
    }

    public abstract void unify(Type var1, TypeChecker var2) throws FailedUnificationException;

    public abstract boolean unify(Type var1);

    public void checkOccurrence(TypeParameter typeParameter, Type type, TypeChecker typeChecker) throws FailedUnificationException {
    }

    public void curry(int n, TypeChecker typeChecker) {
    }

    public Type flatten() {
        return this;
    }

    public Type copy(HashMap hashMap) {
        return this;
    }

    public Type copy() {
        return this.copy(new HashMap());
    }

    public Type instantiate(HashMap hashMap) {
        return this.copy(hashMap);
    }

    public final Type standardize() {
        return this.copy().flatten();
    }

    public HashSet getParameters(HashSet hashSet) {
        return hashSet;
    }

    public final HashSet getParameters() {
        return this.getParameters(new HashSet());
    }

    public abstract int eqCode();

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Type)) {
            return false;
        }
        return this.isEqualTo((Type)object, new HashMap());
    }

    public abstract boolean isEqualTo(Type var1);

    public abstract boolean isEqualTo(Type var1, HashMap var2);

    protected static final String name(Type type) {
        String string = (String)_names.get(type);
        if (string == null) {
            string = Type._newVarName();
            _names.put(type, string);
        }
        return string;
    }

    private static String _newVarName() {
        Object object = "";
        int n = _varCount++;
        do {
            object = String.valueOf((char)(65 + n % 26)) + (String)object;
        } while ((n = n / 26 - 1) >= 0);
        return object;
    }

    public static final void resetNames() {
        _names.clear();
        _varCount = 0;
    }

    public String toFullString() {
        return this.toString();
    }

    public final String toQuantifiedString(boolean bl) {
        HashMap hashMap = new HashMap();
        Type type = this.copy(hashMap);
        if (hashMap.isEmpty()) {
            return bl ? this.toFullString() : this.toString();
        }
        return Misc.arrayToString(this._mapToArray(hashMap), "forall ", ",", ". ") + (bl ? type.toFullString() : type.toString());
    }

    private final TypeParameter[] _mapToArray(HashMap hashMap) {
        TypeParameter[] typeParameterArray = new TypeParameter[hashMap.size()];
        for (Map.Entry entry : hashMap.entrySet()) {
            typeParameterArray[((TypeParameter)entry.getKey()).parameterIndex()] = (TypeParameter)entry.getValue();
        }
        return typeParameterArray;
    }

    public final String toQuantifiedString() {
        return this.toQuantifiedString(false);
    }
}

