/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.types;

import hlt.language.design.kernel.Application;
import hlt.language.design.kernel.Expression;
import hlt.language.design.kernel.Global;
import hlt.language.design.kernel.Scope;
import hlt.language.design.types.Bindable;
import hlt.language.design.types.BoxingMask;
import hlt.language.design.types.ChoicePoint;
import hlt.language.design.types.FailedUnificationException;
import hlt.language.design.types.FunctionType;
import hlt.language.design.types.GlobalTypingGoal;
import hlt.language.design.types.Goal;
import hlt.language.design.types.GoalProver;
import hlt.language.design.types.NoVoidTypeGoal;
import hlt.language.design.types.PruningGoal;
import hlt.language.design.types.ResiduatedGoal;
import hlt.language.design.types.StaticSemanticsErrorException;
import hlt.language.design.types.Type;
import hlt.language.design.types.TypingErrorException;
import hlt.language.design.types.TypingGoal;
import hlt.language.design.types.TypingState;
import hlt.language.design.types.UnifyGoal;
import hlt.language.tools.Debug;
import hlt.language.tools.Misc;
import hlt.language.util.Locatable;
import hlt.language.util.Stack;
import hlt.language.util.ViewableStack;
import java.util.AbstractList;

public class TypeChecker
implements GoalProver {
    private Stack _goalStack = new Stack();
    private Stack _chptStack = new Stack();
    private Stack _bindTrail = new Stack();
    private Stack _typeTrail = new Stack();
    private Stack _applTrail = new Stack();
    private Stack _goalTrail = new Stack();
    private Stack _ctptStack = new Stack();
    private Stack _exitStack = new Stack();
    private boolean _tracing = false;
    public static boolean GIVES_DETAILS = false;
    public static boolean ALLOWS_POSITIONAL_NAMED_TUPLES = false;
    public static boolean ALLOWS_UNIFYING_OPAQUE_TUPLES = false;
    private static final TypingErrorException _GENERIC_ERROR = new TypingErrorException((Object)"ill-typed form");
    private StaticSemanticsErrorException _error;
    private Goal _currentGoal;
    private Locatable _currentExtent;

    public final boolean isTracing() {
        return this._tracing;
    }

    public final void setTracing(boolean bl) {
        if (bl) {
            Type.resetNames();
        }
        this._tracing = bl;
    }

    public final void toggleTrace() {
        this.setTracing(!this._tracing);
    }

    final Scope checkExitable(Locatable locatable) throws TypingErrorException {
        if (this._exitStack.isEmpty()) {
            this.error(new TypingErrorException((Object)"not within an exitable scope"), locatable);
        }
        return (Scope)this._exitStack.peek();
    }

    public final void pushGoal(Goal goal) {
        this._goalStack.push(goal);
    }

    public final void pushExitable(Scope scope) {
        this._exitStack.push(scope);
    }

    public final void popExitable() {
        this._exitStack.pop();
    }

    public final void pushCutPoint() {
        this._ctptStack.push(this.getTypingState());
    }

    public final TypingState popCutPoint() {
        return (TypingState)this._ctptStack.pop();
    }

    @Override
    public final void trail(Bindable bindable) {
        this._bindTrail.push(bindable);
    }

    final void trail(FunctionType functionType, Type[] typeArray, Type type, BoxingMask boxingMask) {
        this._typeTrail.push(boxingMask);
        this._typeTrail.push(type);
        this._typeTrail.push(typeArray);
        this._typeTrail.push(functionType);
    }

    public final void trail(Application application, Expression expression, Expression[] expressionArray) {
        this._applTrail.push(expressionArray);
        this._applTrail.push(expression);
        this._applTrail.push(application);
    }

    @Override
    public final void trail(Goal goal) {
        this._goalTrail.push(goal);
    }

    public final void unify(Type type, Type type2) throws TypingErrorException {
        this.prove(new UnifyGoal(type, type2));
    }

    public final void unify(Type type, Type type2, Locatable locatable) throws TypingErrorException {
        this.prove(new UnifyGoal(type, type2, locatable));
    }

    public final void typeCheck(Expression expression, Type type) throws TypingErrorException {
        this.prove(new TypingGoal(expression, type));
    }

    public final void prune(Global global, Type type, Locatable locatable) throws TypingErrorException {
        this.prove(new PruningGoal(global, type, locatable));
    }

    public final void residuate(Type type, Goal goal) throws TypingErrorException {
        ResiduatedGoal residuatedGoal = new ResiduatedGoal(goal);
        residuatedGoal.addTrigger(type);
        this.prove(goal);
    }

    public final void disallowVoid(Type type, Locatable locatable, Object object) throws TypingErrorException {
        this.residuate(type, new NoVoidTypeGoal(type, locatable, ": " + object));
    }

    @Override
    public final void prove(Goal goal) throws TypingErrorException {
        this._goalStack.push(goal);
        this._typeCheck();
    }

    private final void _typeCheck() throws TypingErrorException {
        while (!this._goalStack.isEmpty()) {
            this._currentGoal = (Goal)this._goalStack.pop();
            this._currentExtent = this._currentGoal.extent();
            try {
                if (this._tracing) {
                    if (!(this._currentGoal instanceof GlobalTypingGoal)) {
                        this.showGoal(this._currentGoal);
                    }
                    this._showState();
                }
                this._currentGoal.prove(this);
                if (!this._tracing) continue;
                this._showStep("Goal " + this._currentGoal.timeStamp() + " succeeded; proceeding...");
            }
            catch (FailedUnificationException failedUnificationException) {
                if (this._tracing) {
                    this._showStep("Goal " + this._currentGoal.timeStamp() + " failed: " + failedUnificationException.msg());
                }
                this._backtrack();
            }
        }
    }

    public final void allTypes(Expression expression, AbstractList abstractList) {
        try {
            expression.typeCheck(this);
            abstractList.add(expression.type().copy());
            if (this._tracing) {
                this._showStep("Types so far: " + abstractList);
            }
        }
        catch (TypingErrorException typingErrorException) {
            return;
        }
        try {
            while (true) {
                if (this._tracing) {
                    this._showStep("Backtracking to find more types...");
                }
                this._backtrack();
                this._typeCheck();
                abstractList.add(expression.type().copy());
                if (!this._tracing) continue;
                this._showStep("Types so far: " + abstractList);
            }
        }
        catch (TypingErrorException typingErrorException) {
            return;
        }
    }

    public final void remainingTypes(Expression expression, AbstractList abstractList) {
        try {
            while (true) {
                if (this._tracing) {
                    this._showStep("Found type " + expression.type() + "; looking for more types...");
                }
                this._backtrack();
                this._typeCheck();
                abstractList.add(expression.type().copy());
                if (!this._tracing) continue;
                this._showStep("Types so far: " + abstractList);
            }
        }
        catch (TypingErrorException typingErrorException) {
            return;
        }
    }

    public final TypingState getTypingState() {
        return new TypingState().save(this._goalStack.size(), this._chptStack.size(), this._bindTrail.size(), this._typeTrail.size(), this._applTrail.size(), this._goalTrail.size());
    }

    final void pushChoicePoint(ChoicePoint choicePoint) {
        this._chptStack.push(choicePoint.save(this._goalStack.size(), this._chptStack.size(), this._bindTrail.size(), this._typeTrail.size(), this._applTrail.size(), this._goalTrail.size()));
    }

    final void popChoicePoint() {
        this._chptStack.pop();
    }

    private final ChoicePoint _getChoicePoint() {
        return (ChoicePoint)this._chptStack.peek();
    }

    private final TypingState _getCutPoint() {
        return (TypingState)this._ctptStack.peek();
    }

    public final TypeChecker reset() {
        _GENERIC_ERROR.setExtent(this._currentExtent);
        this._currentExtent = null;
        this._error = null;
        this._clearAllStacks();
        return this;
    }

    private final void _clearAllStacks() {
        this._goalStack.clear();
        this._chptStack.clear();
        this._exitStack.clear();
        this._goalTrail.clear();
        this._unwindBindTrail();
        this._unwindTypeTrail();
        this._unwindApplTrail();
    }

    public final void undoCutPoint() {
        if (this._tracing) {
            System.out.println("Undoing cut point from state:");
            this._showState();
        }
        TypingState typingState = this.popCutPoint();
        while (!this._goalTrail.isEmpty() && ((Goal)this._goalTrail.peek()).timeStamp() > typingState.timeStamp()) {
            this._goalTrail.pop();
        }
        this._unwindBindTrail(typingState.bindTrailPoint());
        this._unwindTypeTrail(typingState.typeTrailPoint());
        this._unwindApplTrail(typingState.applTrailPoint());
    }

    private final boolean _noMoreChoices() {
        return this._chptStack.isEmpty() || !this._ctptStack.isEmpty() && this._getChoicePoint().timeStamp() < this._getCutPoint().timeStamp();
    }

    private final void _backtrack() throws TypingErrorException {
        if (this._noMoreChoices()) {
            this.reportError();
        }
        ChoicePoint choicePoint = (ChoicePoint)this._chptStack.peek();
        this._unwindGoalTrail(choicePoint.timeStamp());
        this._unwindBindTrail(choicePoint.bindTrailPoint());
        this._unwindTypeTrail(choicePoint.typeTrailPoint());
        this._unwindApplTrail(choicePoint.applTrailPoint());
        if (this._tracing) {
            this._show("Retrying Goal " + choicePoint.timeStamp() + " ...");
        }
    }

    private final void _unwindBindTrail() {
        this._unwindBindTrail(0);
    }

    private final void _unwindBindTrail(int n) {
        while (this._bindTrail.size() > n) {
            ((Bindable)this._bindTrail.pop()).unbind();
        }
    }

    private final void _unwindTypeTrail() {
        this._unwindTypeTrail(0);
    }

    private final void _unwindTypeTrail(int n) {
        while (this._typeTrail.size() > n) {
            FunctionType functionType = (FunctionType)this._typeTrail.pop();
            functionType.setDomains((Type[])this._typeTrail.pop());
            functionType.setRange((Type)this._typeTrail.pop());
            functionType.setMask((BoxingMask)this._typeTrail.pop());
        }
    }

    private final void _unwindApplTrail() {
        this._unwindApplTrail(0);
    }

    private final void _unwindApplTrail(int n) {
        while (this._applTrail.size() > n) {
            Application application = (Application)this._applTrail.pop();
            application.setFunction((Expression)this._applTrail.pop());
            application.setArguments((Expression[])this._applTrail.pop());
        }
    }

    private final void _unwindGoalTrail(long l) {
        while (((Goal)this._goalTrail.peek()).timeStamp() > l) {
            ((Goal)this._goalTrail.pop()).undo(this);
        }
        this._goalStack.push(this._goalTrail.pop());
    }

    private final void _assessCulprit(StaticSemanticsErrorException staticSemanticsErrorException) {
        if (this._error == null || this._currentGoal.timeStamp() > this._error.stamp()) {
            this._error = staticSemanticsErrorException.setExtent(this._currentExtent);
            if (this._currentGoal != null) {
                this._error.setStamp(this._currentGoal.timeStamp());
            }
        }
    }

    public final void error(StaticSemanticsErrorException staticSemanticsErrorException) throws StaticSemanticsErrorException {
        this._assessCulprit(staticSemanticsErrorException);
        throw this._error;
    }

    public final void error(StaticSemanticsErrorException staticSemanticsErrorException, Locatable locatable) throws StaticSemanticsErrorException {
        this._currentExtent = locatable;
        this.error(staticSemanticsErrorException);
    }

    public final void reportError() throws StaticSemanticsErrorException {
        StaticSemanticsErrorException staticSemanticsErrorException = this._error;
        throw staticSemanticsErrorException != null ? staticSemanticsErrorException : _GENERIC_ERROR;
    }

    private final void _showState() {
        if (this._tracing) {
            this._show(this._showNonEmpty(this._goalStack, "        Goal stack") + this._showNonEmpty(this._goalTrail, "        Goal trail") + this._showNonEmpty(this._exitStack, "        Exit stack") + this._showNonEmpty(this._ctptStack, "   Cut point stack") + this._showNonEmpty(this._chptStack, "Choice point stack") + this._showChoicePointEntries());
        }
    }

    private final String _showNonEmpty(ViewableStack viewableStack, String string) {
        return viewableStack.isEmpty() ? "" : Misc.view(viewableStack, string, 0, 100);
    }

    private final String _showChoicePointEntries() {
        if (this._chptStack.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this._chptStack.size(); ++i) {
            ChoicePoint choicePoint = (ChoicePoint)this._chptStack.get(i);
            stringBuilder.append(Misc.view(choicePoint.entries(), "Next choices for goal " + choicePoint.timeStamp(), 0, 86));
        }
        return stringBuilder.toString();
    }

    private final void _show(String string) {
        System.out.println(string);
    }

    private final void _showStep(String string) {
        Debug.step(string);
    }

    final void showGoal(Goal goal) {
        if (this._tracing) {
            this._show(Misc.etc(120, "Currently attempting ==> " + goal));
        }
    }
}

