/*
 * Decompiled with CFR 0.152.
 */
package hlt.language.design.types;

import hlt.language.design.types.DefinedType;
import hlt.language.design.types.StaticSemanticsErrorException;
import hlt.language.design.types.Type;
import hlt.language.design.types.TypeDefinitionException;
import hlt.language.design.types.TypeParameter;
import hlt.language.design.types.TypeTermScheme;
import hlt.language.design.types.TypingErrorException;
import java.util.AbstractList;
import java.util.HashMap;

public class TypeDefinition
extends TypeTermScheme {
    private String _name;
    private Type _definition;

    TypeDefinition(String string, Type type) {
        this._name = string.intern();
        this._definition = type.flatten();
    }

    TypeDefinition(String string, Type type, TypeParameter[] typeParameterArray) {
        this(string, type);
        this._parameters = typeParameterArray;
    }

    TypeDefinition(String string, Type type, AbstractList abstractList) {
        this(string, type);
        if (abstractList != null && !abstractList.isEmpty()) {
            this._parameters = new TypeParameter[abstractList.size()];
            for (int i = 0; i < this._parameters.length; ++i) {
                this._parameters[i] = (TypeParameter)abstractList.get(i);
            }
        }
    }

    public final Type definition() {
        return this._definition.copy();
    }

    public final Type instantiate(AbstractList abstractList) throws StaticSemanticsErrorException {
        int n;
        int n2;
        HashMap<TypeParameter, Type> hashMap = new HashMap<TypeParameter, Type>();
        int n3 = n2 = abstractList == null ? 0 : abstractList.size();
        if (n2 != this.arity()) {
            if (this._parameters == null) {
                this._parameters = new TypeParameter[n2];
                n = n2;
                while (n-- > 0) {
                    this._parameters[n] = new TypeParameter();
                }
            } else {
                throw new TypeDefinitionException((Object)("wrong number of arguments for type " + this._name + "; expected: " + this.arity() + ", found: " + n2));
            }
        }
        n = n2;
        while (n-- > 0) {
            Type type = (Type)abstractList.get(n);
            if (type.isVoid()) {
                throw new TypingErrorException((Object)"void type instantiation");
            }
            hashMap.put(this._parameters[n], type);
        }
        return this._definition.instantiate(hashMap);
    }

    public final String toString() {
        Type type = this._definition.kind() == 12 ? ((DefinedType)this._definition).definition() : this._definition;
        Type.resetNames();
        StringBuilder stringBuilder = new StringBuilder(this._name);
        for (int i = 0; i < this.arity(); ++i) {
            if (i == 0) {
                stringBuilder.append("(");
            }
            stringBuilder.append(this._parameters[i]);
            stringBuilder.append(i == this.arity() - 1 ? ")" : ",");
        }
        return stringBuilder.append(" = ").append(type.toFullString()).toString();
    }
}

